/***************************************************************************
         ccasefolder.h  -  Get a case folded version of a string
                             -------------------
    begin                : Thu Jul 17 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CCASEFOLDER_H
#define CCASEFOLDER_H

/**
 * author Edward Sheldrake
 *
 * This class produces a case folded version of a string, required to
 * make comparisions / searching case insensitive. It does not matter
 * if it's uppercase, lowercase or some mixture, just that both strings
 * have been processed by the same algorithm.
 *
 * This does full case mapping and the output may be longer than the
 * input.
 *
 * The data is based on CaseFolding-5.1.0.txt from the Unicode Character
 * Database.
 *
 * This class appears to be necessary because the C function toupper()
 * does not handle UTF-8 and converting to wchar_t and using towupper()
 * also leaves all the accented characters unconverted.
 *
 * Other software: Shakespeer seems to have various unicode data
 * tables in it's source under splib/unicode-spec but DC++ relies
 * on CharLowerW on Windows and towlower() elsewhere.
 *
 * QT's QString class works entirely in unicode and has a toLower()
 * function that handles everything, not just ascii A-Z.
 */

#include <dclib/dcos.h>
#include <dclib/core/cstring.h>

#include <iconv.h>

class CCaseFolder {

public:
	/** Constructor */
	CCaseFolder();
	/** Destructor */
	~CCaseFolder();

	/**
	 * Do the case folding. To reduce copying, a CString to put the
	 * output in is a parameter.
	 *
	 * Returns true if everything suceeded.
	 */
	bool Fold( const CString & input, CString & output );

private:
	/** local to UCS-4 */
	iconv_t to_ucs4;
	/** UCS-4 to local */
	iconv_t from_ucs4;
};

#endif // CCASEFOLDER_H
