#if   !defined(__MAPSITE_HPP)
#define __MAPSITE_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

//
// Domain : These are the positions of various
// objects in the maze
//

enum  Direction
{
   NORTH = 0,
   SOUTH,
   EAST,
   WEST
};

DECLARE_CLASS( MapSite );

/**
MapSite is a common abstraction for all components of a maze.
*/

class MapSite
{
public:

   //
   // Constructors and destructor
   //

                        /// Default constructor

                        MapSite( void )
                        {
                           ;  // do nothing
                        }

                        /// Copy constructor

                        MapSite( MapSiteCref )
                        {
                           ; // do nothing
                        }

                        /// Virtual destructor

   virtual              ~MapSite( void )
                        {
                           ;  // do nothing
                        }

   //
   // Operator overloads
   //

            /// Assignment operator

            MapSiteRef  operator=( MapSiteCref )
            {
               return (*this);
            }

            /// Equality operator returns true 
            /// if instances are the same

            bool  operator==( MapSiteCref aRef ) const
            {
               return ( this == &aRef );
            }

   //
   // Pure virtual
   //
            /**
            The one operation "enter", the meaning
            depends on the derivation, or what it
            is you are entering
            */

   virtual  void  enter( void ) = 0;
};

#endif // if !defined(__MAPSITE_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/04/21 02:38:47 $
   $Locker:  $
*/

