/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__HELPHANDLER_HPP)
#include <HelpHandler.hpp>
#endif

using namespace corelinux;

// Default constructor

HelpHandler::HelpHandler( HelpTopicCref aTopic )
   :
   Handler(),
   theTypeHandled( aTopic )
{
   ;  // do nothing
}

// Copy constructor

HelpHandler::HelpHandler( HelpHandlerCref aHandler )
   :
   Handler(aHandler),
   theTypeHandled( aHandler.getTypeHandled() )
{
   ;  // do nothing
}

// Default is an error

HelpHandler::HelpHandler( void ) throw ( Assertion )
   :
   Handler(),
   theTypeHandled( UNKNOWN_HELP )
{
   NEVER_GET_HERE;
}

// Destructor cleans slate

HelpHandler::~HelpHandler( void )
{
   theTypeHandled =  UNKNOWN_HELP;
}

// Assignment operator

HelpHandlerRef   HelpHandler::operator=( HelpHandlerCref aHandler )
{
   Handler::operator=( aHandler );
   theTypeHandled = aHandler.getTypeHandled();
   return  (*this);
}

// Calls topic comparison

bool  HelpHandler::operator==( HelpHandlerCref aHandler ) const
{
   return 
      ( 
         ( this == &aHandler ? true :
            theTypeHandled == aHandler.getTypeHandled() )
      );
}

// Get my type

HelpTopicCref  HelpHandler::getTypeHandled( void ) const
{
   return theTypeHandled;
}

// Dispatch mechanism

bool HelpHandler::handlesType( RequestPtr aRequest )
{
   REQUIRE( aRequest != NULLPTR );
   return( *(HelpRequestPtr(aRequest)) == theTypeHandled );
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/04/27 14:32:21 $
   $Locker:  $
*/


