/*=============================================================================
**  Lynkeos
**  $Id: stack.c,v 1.3 2005/02/05 20:49:36 j-etienne Exp $
**-----------------------------------------------------------------------------
**
**  Created by Jean-Etienne LAMIAUD on Wed Dec 03 2003.
**  Copyright (c) 2003-2004. Jean-Etienne LAMIAUD
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
**
**-----------------------------------------------------------------------------
*/
#include <assert.h>

#include "stack.h"

static inline short range( short i, short l )
{
    if ( i < 0 )
        i += l;

    else if ( i >= l )
        i -= l;

    return( i );
}

static inline void scalar_addition( RGB *result, RGB layer, double scalar )
{
    result->red += layer.red*scalar;
    result->green += layer.green*scalar;
    result->blue += layer.blue*scalar;
}

void stack_layer( RGB *result, RGB *layer, double dx, double dy, short w, short h )
{
    short i_dx, i_dy;
    double f_dx, f_dy;
    short x, y;

    /* Separate the shift in an integer and a positive fractionary part */
    i_dx = (int)dx;
    f_dx = dx - (double)i_dx;
    if ( f_dx < 0 )
    {
        i_dx --;
        f_dx += 1.0;
    }

    i_dy = (int)dy;
    f_dy = dy - (double)i_dy;
    if ( f_dy < 0 )
    {
        i_dy --;
        f_dy += 1.0;
    }

    /* Add the layer with the shift */
    for( y = 0; y < h; y++ )
    {
        for( x = 0; x < w; x++ )
        {
            short xp, yp;

            /* First quadrant */
            xp = range(x - i_dx - 1, w);
            yp = range(y - i_dy - 1, h);
            scalar_addition( &result[y*w+x], layer[yp*w+xp], f_dx * f_dy );

            /* Second quadrant */
            xp = range(x - i_dx, w);
            yp = range(y - i_dy - 1, h);
            scalar_addition( &result[y*w+x], layer[yp*w+xp], (1 - f_dx) * f_dy );

            /* Third quadrant */
            xp = range(x - i_dx - 1, w);
            yp = range(y - i_dy, h);
            scalar_addition( &result[y*w+x], layer[yp*w+xp], f_dx * (1 - f_dy) );

            /* Fourth and last quadrant */
            xp = range(x - i_dx, w);
            yp = range(y - i_dy, h);
            scalar_addition( &result[y*w+x], layer[yp*w+xp], (1 - f_dx) * (1 - f_dy) );
        }
    }
}
