//
//  Lynkeos 
//  $Id: MyDocumentData.m,v 1.6 2005/01/27 23:03:05 j-etienne Exp $
//
//  Created by Jean-Etienne LAMIAUD on Thu Jul 29 2004.
//  Copyright (c) 2003-2004. Jean-Etienne LAMIAUD
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#include "MyDocumentData.h"

//==============================================================================
// V1 file format
//==============================================================================

#define K_OBJECT_LIST_KEY	@"object"
#define K_DARK_FRAME_LIST_KEY   @"darkframes"
#define K_FLAT_FIELD_LIST_KEY   @"flatfields"
#define K_BLACK_LEVEL_KEY	@"blackl"
#define K_WHITE_LEVEL_KEY	@"whitel"
#define K_MONOFLAT_KEY          @"monoflat"
#define K_ANALYSIS_METHOD_KEY   @"analysmethod"
#define K_WINDOW_FRAME_KEY      @"window"

@implementation MyDocumentDataV1

- (void)encodeWithCoder:(NSCoder *)encoder
{
   [encoder encodeObject:_imageList forKey:K_OBJECT_LIST_KEY];
   [encoder encodeObject:_darkFrameList forKey:K_DARK_FRAME_LIST_KEY];
   [encoder encodeObject:_flatFieldList forKey:K_FLAT_FIELD_LIST_KEY];
   [encoder encodeBool:_monochromeFlat forKey:K_MONOFLAT_KEY];
   [encoder encodeInt:_analysisMethod forKey:K_ANALYSIS_METHOD_KEY];
   [encoder encodeObject:_windowFrame forKey:K_WINDOW_FRAME_KEY];
}

- (id)initWithCoder:(NSCoder *)decoder
{
   if ( [decoder containsValueForKey:K_OBJECT_LIST_KEY] )
   {
      _imageList = [[decoder decodeObjectForKey:K_OBJECT_LIST_KEY] retain];
      _darkFrameList = [[decoder decodeObjectForKey:K_DARK_FRAME_LIST_KEY]
                          retain];
      _flatFieldList = [[decoder decodeObjectForKey:K_FLAT_FIELD_LIST_KEY]
                          retain];
      _monochromeFlat = [decoder decodeBoolForKey:K_MONOFLAT_KEY];

      if ( [decoder containsValueForKey:K_ANALYSIS_METHOD_KEY] )
         _analysisMethod = [decoder decodeIntForKey:K_ANALYSIS_METHOD_KEY];
      else
         _analysisMethod = 0;
      _windowFrame = [[decoder decodeObjectForKey:K_WINDOW_FRAME_KEY] retain];

      return( self );
   }
   else
   {
      [self release];
      return( nil );
   }
}

// No override of dealloc since this class only contains references to objects
// later owned by the document
@end

//==============================================================================
// V0 file format
//==============================================================================
#define K_LIST_KEY		@"images"
#define K_SEARCH_ORIGIN_KEY	@"sorigin"
#define K_SEARCH_SIDE_KEY	@"sside"
#define K_ANALYZE_ORIGIN_KEY	@"aorigin"
#define K_ANALYZE_SIDE_KEY	@"aside"
#define K_SELECT_THRESHOLD_KEY	@"selectthr"
#define K_CROP_RECTANGLE_KEY	@"crop"
#define K_SIZE_FACTOR_KEY	@"sizef"
#define K_RAW_STACK_KEY		@"stack"
#define K_UNSHARP_RADIUS_KEY	@"uradius"
#define K_UNSHARP_GAIN_KEY	@"ugain"
#define K_DECONV_RADIUS_KEY	@"dradius"
#define K_DECONV_THRESHOLD_KEY	@"dthreshold"
#define K_DOUBLE_SIZE_KEY	@"double"

@implementation MyImageListData
- (void)encodeWithCoder:(NSCoder *)encoder
{
   // I don't intend to support saving in V0 format
}

- (id)initWithCoder:(NSCoder *)decoder
{
   if ( [decoder containsValueForKey:K_LIST_KEY] )
   {
      _imageList = [[decoder decodeObjectForKey:K_LIST_KEY] retain];
      _searchSquareOrigin = [decoder decodePointForKey:K_SEARCH_ORIGIN_KEY];
      _searchSquareSide = [decoder decodeDoubleForKey:K_SEARCH_SIDE_KEY];
      _analyzeSquareOrigin = [decoder decodePointForKey:K_ANALYZE_ORIGIN_KEY];
      _analyzeSquareSide = [decoder decodeDoubleForKey:K_ANALYZE_SIDE_KEY];
      _selectThreshold = [decoder decodeDoubleForKey:K_SELECT_THRESHOLD_KEY];
      _cropRectangle = [decoder decodeRectForKey:K_CROP_RECTANGLE_KEY];
      _doubleSize = [decoder decodeBoolForKey:K_DOUBLE_SIZE_KEY];
      _rawStack = [[decoder decodeObjectForKey:K_RAW_STACK_KEY] retain];
      
      _uRadius = [decoder decodeDoubleForKey:K_UNSHARP_RADIUS_KEY];
      _uGain = [decoder decodeDoubleForKey:K_UNSHARP_GAIN_KEY];
      _dRadius = [decoder decodeDoubleForKey:K_DECONV_RADIUS_KEY];
      _dThreshold = [decoder decodeDoubleForKey:K_DECONV_THRESHOLD_KEY];
      _blackLevel = [decoder decodeDoubleForKey:K_BLACK_LEVEL_KEY];
      _whiteLevel = [decoder decodeDoubleForKey:K_WHITE_LEVEL_KEY];
      
      _referenceItem = [decoder decodeObjectForKey:K_REFERENCE_ITEM_KEY];
      return( self );
   }
   else
   {
      [self release];
      return( nil );
   }
}

@end

