use strict;

return {
#{  0x80, 0x80,  "ATSC stuffing descriptor" },
#{  0x81, 0x81,  "ATSC AC-3 audio descriptor" },
#{  0x82, 0x85,  "ATSC TODO" },
#{  0x86, 0x86,  "ATSC caption service descriptor" },
#{  0x87, 0x87,  "ATSC content advisory descriptor" },
#{  0x88, 0x8F,  "ATSC TODO" },
#{  0xA0, 0xA0,  "ATSC extended channel name descriptor" },
#{  0xA1, 0xA1,  "ATSC service location descriptor" },
#{  0xA2, 0xA2,  "ATSC time-shifted service descriptor" },
#{  0xA3, 0xA3,  "ATSC component name descriptor" },
#{  0xA4, 0xA7,  "ATSC TODO" },
#{  0xA8, 0xA8,  "ATSC DCC departing request descriptor" },
#{  0xA9, 0xA9,  "ATSC DCC arriving request descriptor" },
#{  0xAA, 0xAA,  "ATSC redistribution control descriptor" },
	descriptors => [
		{	id   => 0xa0,
			name => "ATSC_extended_channel_name_descriptor",
			elements => [
				descriptor_tag    => 8,
				descriptor_length => 8,
				TODO              => 1,
			],
		},
		{	id   => 0xa1,
			name => "ATSC_service_location_descriptor",
			elements => [
				descriptor_tag    => 8,
				descriptor_length => 8,
				reserved          => 3,
				PCR_PID           => 13,
				number_elements   => 8,
			],
		}
	],
	misc => [
		{	name => "ATSC_service_location_element",
			elements => [
				stream_type           => 8,
				reserved              => 3,
				elementary_PID        => 13,
				ISO_639_language_code => 24,
			],
		},
		{	name => "tvct_channel",
			elements => [
				short_name0 => 16,
				short_name1 => 16,
				short_name2 => 16,
				short_name3 => 16,
				short_name4 => 16,
				short_name5 => 16,
				short_name6 => 16,
				reserved0 => 4,
				major_channel_number => 10,
				minor_channel_number => 10,
				modulation_mode => 8,
				carrier_frequency => 32,
				channel_TSID => 16,
				program_number => 16,
				ETM_location => 2,
				access_controlled => 1,
				hidden => 1,
				reserved1 => 2,
				hide_guide => 1,
				reserved2 => 3,
				service_type => 6,
				source_id => 16,
				reserved3 => 6,
				descriptors_length => 10,
			],
		},
	]
};
