package latexDraw.ui.dialog;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;

import javax.swing.*;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;

import latexDraw.figures.Figure;
import latexDraw.figures.GridShape;
import latexDraw.lang.LaTeXDrawLang;
import latexDraw.ui.DrawPanel;
import latexDraw.util.LaTeXDrawPoint2D;
import latexDraw.util.LaTeXDrawResources;

/** 
 * This class defines the frame which allows to modify a grid<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE.  See the GNU General Public License for more details.<br>
 *<br>
 * 08/17/06<br>
 * @author Arnaud BLOUIN<br>
 * @since 1.8<br>
 * @version 2.0.0<br>
 */
public abstract class AbstractGridShapeFrame extends AbstractParametersFrame
{
	private static final long serialVersionUID = 1L;

	/** Allows to change the minimum value of X */
	protected JSpinner xGridStart;
	
	/** Allows to change the minimum value of Y */
	protected JSpinner yGridStart;
	
	/** Allows to change the maximum value of X */
	protected JSpinner xGridEnd;
	
	/** Allows to change the maximum value of Y */
	protected JSpinner yGridEnd;
	
	/** Allows to change the X-origin */
	protected JSpinner xOrigin;
	
	/** Allows to change the Y-origin */
	protected JSpinner yOrigin;
	
	/** This field allows the set the X-coordinate of position of the grid 
	 * (the south-west point) */
	protected JSpinner xPosition;
	
	/** This field allows the set the Y-coordinate of position of the grid 
	 * (the south-west point) */
	protected JSpinner yPosition;
	
	/** Allows to know if we must draw the labels */
	protected JCheckBox invertXLabelsCB;
	
	/** Allows to know if we must draw the labels */
	protected JCheckBox invertYLabelsCB;

	
	
	/** The label of the invertXLabelsCB */
	public static final String LABEL_ISXLABEL = LaTeXDrawLang.getString1_6("ParametersGridFrame.0"); //$NON-NLS-1$
	
	/** The label of the invertYLabelsCB */
	public static final String LABEL_ISYLABEL = LaTeXDrawLang.getString1_6("ParametersGridFrame.1"); //$NON-NLS-1$
	
	/** The label of the yOrigin item */
	public static final String LABEL_YORIGIN = LaTeXDrawLang.getDialogFrameString("ParametersGridFrame.0"); //$NON-NLS-1$
	
	/** The label of the xOrigin item */
	public static final String LABEL_XORIGIN = LaTeXDrawLang.getDialogFrameString("ParametersGridFrame.1"); //$NON-NLS-1$
	
	/** The label of the gridLabelsColor item */
	public static final String LABEL_LABELSCOLOR = LaTeXDrawLang.getDialogFrameString("ParametersGridFrame.2"); //$NON-NLS-1$
	
	/** The label of the xGridEnd item */
	public static final String LABEL_XGRIDEND = LaTeXDrawLang.getDialogFrameString("ParametersGridFrame.11"); //$NON-NLS-1$
	
	/** The label of the xGridStart item */
	public static final String LABEL_XGRIDSTART = LaTeXDrawLang.getDialogFrameString("ParametersGridFrame.12"); //$NON-NLS-1$
	
	/** The label of the yGridEnd item */
	public static final String LABEL_YGRIDEND = LaTeXDrawLang.getDialogFrameString("ParametersGridFrame.13"); //$NON-NLS-1$
	
	/** The label of the yGridStart item */
	public static final String LABEL_YGRIDSTART = LaTeXDrawLang.getDialogFrameString("ParametersGridFrame.14"); //$NON-NLS-1$
	


	protected AbstractGridShapeFrame(Frame parent, DrawPanel d, boolean attachToMainFrame)
	{
		super(parent, d, attachToMainFrame);
	}


	
	protected JPanel createPositionPanel(boolean withOrigin)
	{
  		JPanel coordP = new JPanel(new GridBagLayout());
  		
  		GridBagConstraints constraint = new GridBagConstraints();
    	constraint.gridx = 0;
     	constraint.gridy = 0;
     	constraint.gridwidth = 1;
     	constraint.gridheight = 1;
     	constraint.weightx = 0.1;
     	constraint.weighty = 0.1;
     	constraint.fill = GridBagConstraints.NONE;
     	constraint.anchor = GridBagConstraints.CENTER;
     	coordP.add(new JLabel(LABEL_X), constraint);
  		
     	SpinnerModel model = new SpinnerNumberModel(0,0,10000,0.1);
     	xPosition = new JSpinner(model);
     	xPosition.setEditor(new JSpinner.NumberEditor(xPosition, "0.0"));//$NON-NLS-1$
		xPosition.addChangeListener(this);
     	xPosition.setName(LABEL_X);
     	constraint.gridx++;
     	coordP.add(xPosition, constraint);	  		

    	constraint.gridx++;
    	coordP.add(new JLabel(LABEL_Y), constraint);
  		
     	model = new SpinnerNumberModel(0,0,10000,0.1);
     	yPosition = new JSpinner(model);
     	yPosition.setEditor(new JSpinner.NumberEditor(yPosition, "0.0"));//$NON-NLS-1$
     	yPosition.addChangeListener(this);
     	yPosition.setName(LABEL_Y);
     	constraint.gridx++;
     	coordP.add(yPosition, constraint);
     	
    	constraint.gridx = 0;	constraint.gridy++;
    	coordP.add(new JLabel(LABEL_XGRIDSTART), constraint);
  		
     	model = new SpinnerNumberModel(0,-10000,10000,1);
     	xGridStart = new JSpinner(model);
     	xGridStart.setEditor(new JSpinner.NumberEditor(xGridStart, "0"));//$NON-NLS-1$
     	xGridStart.addChangeListener(this);
     	xGridStart.setName(LABEL_XGRIDSTART);
     	constraint.gridx++;
     	coordP.add(xGridStart, constraint);
   
     	constraint.gridx++;
     	coordP.add(new JLabel(LABEL_YGRIDSTART), constraint);
  		
     	model = new SpinnerNumberModel(0,-10000,10000,1);
     	yGridStart = new JSpinner(model);
     	yGridStart.setEditor(new JSpinner.NumberEditor(yGridStart, "0"));//$NON-NLS-1$
     	yGridStart.addChangeListener(this);
     	yGridStart.setName(LABEL_YGRIDSTART);
     	constraint.gridx++;
     	coordP.add(yGridStart, constraint);	     	
    	
     	constraint.gridx = 0;	constraint.gridy++;
     	coordP.add(new JLabel(LABEL_XGRIDEND), constraint);
     	
     	model = new SpinnerNumberModel(0,-10000,10000,1);
     	xGridEnd = new JSpinner(model);
     	xGridEnd.setEditor(new JSpinner.NumberEditor(xGridEnd, "0"));//$NON-NLS-1$
     	xGridEnd.addChangeListener(this);
     	xGridEnd.setName(LABEL_XGRIDEND);
     	constraint.gridx++;
     	coordP.add(xGridEnd, constraint);
   
     	constraint.gridx++;
     	coordP.add(new JLabel(LABEL_YGRIDEND), constraint);
  		
     	model = new SpinnerNumberModel(0,-10000,10000,1);
     	yGridEnd = new JSpinner(model);
     	yGridEnd.setEditor(new JSpinner.NumberEditor(yGridEnd, "0"));//$NON-NLS-1$
     	yGridEnd.addChangeListener(this);
     	yGridEnd.setName(LABEL_YGRIDEND);
     	constraint.gridx++;
     	coordP.add(yGridEnd, constraint);	   
     	
     	if(withOrigin)
     	{
	     	constraint.gridx=0; constraint.gridy++;
	     	coordP.add(new JLabel(LABEL_XORIGIN), constraint);
	     	
	     	model = new SpinnerNumberModel(0,-10000,10000,1);
	     	xOrigin = new JSpinner(model);
	     	xOrigin.setEditor(new JSpinner.NumberEditor(xOrigin, "0"));//$NON-NLS-1$
	     	xOrigin.addChangeListener(this);
	     	xOrigin.setName(LABEL_XORIGIN);
	     	constraint.gridx++;
	     	coordP.add(xOrigin, constraint);	   
	     	
	     	constraint.gridx++; 
	     	coordP.add(new JLabel(LABEL_YORIGIN), constraint);
	     	
	     	model = new SpinnerNumberModel(0,-10000,10000,1);
	     	yOrigin = new JSpinner(model);
	     	yOrigin.setEditor(new JSpinner.NumberEditor(yOrigin, "0"));//$NON-NLS-1$
	     	yOrigin.addChangeListener(this);
	     	yOrigin.setName(LABEL_YORIGIN);
	     	constraint.gridx++;
	     	coordP.add(yOrigin, constraint);	
     	}
     	
     	constraint.gridx = 0;	constraint.gridy++;
     	coordP.add(new JLabel(LABEL_ROTATION), constraint);
     	
     	model = new SpinnerNumberModel(Figure.DEFAULT_ROTATION_ANGLE, -360, 360,0.1);
     	rotationField = new JSpinner(model);
     	rotationField.setEditor(new JSpinner.NumberEditor(rotationField, "0.0"));//$NON-NLS-1$
     	rotationField.setName(LaTeXDrawResources.LABEL_ROTATE);
     	rotationField.addChangeListener(this);
     	constraint.gridx++;
     	coordP.add(rotationField, constraint);
     	coordP.setBorder(new CompoundBorder(new TitledBorder(null, LABEL_POSITION_DIMENSIONS, 
				  TitledBorder.LEFT, TitledBorder.TOP), new EmptyBorder(0,0,0,0)));
     	coordP.setPreferredSize(new Dimension(WIDTH_PANELS, 200));
     	coordP.setMinimumSize(new Dimension(WIDTH_PANELS, 200));

     	return coordP;
	}


	
	
	@Override
	public void actionPerformed(ActionEvent e) 
	{
		try
		{
			Object o = e.getSource();
			GridShape g = (GridShape)glimpsePanel.getGlimpseFigure();
			
			if(o instanceof JCheckBox)
			{
				String label = ((JCheckBox)o).getActionCommand();
			
				if(label.equals(LABEL_ISXLABEL))
				{
					setModified(true);
					g.setYLabelWest(!invertXLabelsCB.isSelected());
					glimpsePanel.repaint();
					return ;
				}
				
				if(label.equals(LABEL_ISYLABEL))
				{
					setModified(true);
					g.setXLabelSouth(!invertYLabelsCB.isSelected());
					glimpsePanel.repaint();
					return ;
				}
			}
		}catch(Exception ex)
		{
			ex.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(ex);
		}
		
		super.actionPerformed(e);
	}
			
	
	
	@Override
	public void stateChanged(ChangeEvent e) 
	{
		try
		{
			Object o = e.getSource();
			GridShape g = (GridShape)glimpsePanel.getGlimpseFigure();
			
			if(o instanceof JSpinner)
			{
				String name = ((JSpinner)o).getName();
				double v = Double.valueOf(((JSpinner)o).getValue().toString()).doubleValue();
				
				if(name.equals(LABEL_XGRIDEND))
				{
					int xE = (int)v;
					int xS = Integer.valueOf(xGridStart.getValue().toString()).intValue();
					
					setModified(true);
					g.getGridEnd().x = xE;
					xGridStart.removeChangeListener(this);
					xGridStart.setModel(new SpinnerNumberModel(xE,-10000,xE,1));
					xGridStart.setValue(Math.min(xE, xS));
					xGridStart.addChangeListener(this);
					g.updateBorders(null);
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_YGRIDEND))
				{
					int yE = (int)v;
					int yS = Integer.valueOf(yGridStart.getValue().toString()).intValue();
					
					setModified(true);
					g.getGridEnd().y = yE;
					yGridStart.removeChangeListener(this);
					yGridStart.setModel(new SpinnerNumberModel(yE,-10000,yE,1));
					yGridStart.setValue(Math.min(yE, yS));
					yGridStart.addChangeListener(this);
					g.updateBorders(null);
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_XGRIDSTART))
				{
					int xE = Integer.valueOf(xGridEnd.getValue().toString()).intValue();
					int xS = (int)v;
					
					setModified(true);
					g.getGridStart().x = xS;
					xGridEnd.removeChangeListener(this);
					xGridEnd.setModel(new SpinnerNumberModel(xS,xS,10000,1));
					xGridEnd.setValue(Math.max(xE, xS));
					xGridEnd.addChangeListener(this);
					g.updateBorders(null);
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_YGRIDSTART))
				{
					int yE = Integer.valueOf(yGridEnd.getValue().toString()).intValue();
					int yS = (int)v;
					
					setModified(true);
					g.getGridStart().y = yS;
					yGridEnd.removeChangeListener(this);
					yGridEnd.setModel(new SpinnerNumberModel(yS,yS,10000,1));
					yGridEnd.setValue(Math.max(yE, yS));
					yGridEnd.addChangeListener(this);
					g.updateBorders(null);
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_XORIGIN))
				{
					setModified(true);
					g.getOrigin().x = (int)v;
					g.updateBorders(null);
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_YORIGIN))
				{
					setModified(true);
					g.getOrigin().y = (int)v;
					g.updateBorders(null);
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_X))
				{
					setModified(true);
					g.getPosition().x = (float)v;
					g.updateBorders(null);
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_Y))
				{
					setModified(true);
					g.getPosition().y = (float)v;
					g.updateBorders(null);
					glimpsePanel.repaint();
					return ;
				}
			}
		}catch(Exception ex)
		{
			ex.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(ex);
		}
		
		super.stateChanged(e);
	}

	
	
	@Override
	public void saveParameters()
	{
		GridShape g = (GridShape)figure;

		LaTeXDrawPoint2D gridMax = g.getGridEnd(), gridMin = g.getGridStart();
		gridMax.x = Integer.valueOf(xGridEnd.getValue().toString()).intValue();
		gridMax.y = Integer.valueOf(yGridEnd.getValue().toString()).intValue();
		gridMin.x = Integer.valueOf(xGridStart.getValue().toString()).intValue();
		gridMin.y = Integer.valueOf(yGridStart.getValue().toString()).intValue();
		LaTeXDrawPoint2D position = g.getPosition();
		position.x = Double.valueOf(xPosition.getValue().toString()).doubleValue();
		position.y = Double.valueOf(yPosition.getValue().toString()).doubleValue();
		
		if(xOrigin!=null)
		{
			LaTeXDrawPoint2D origin = g.getOrigin();
			float tmp = Float.valueOf(xOrigin.getValue().toString()).floatValue();
			origin.x = tmp;
			tmp = Float.valueOf(yOrigin.getValue().toString()).floatValue();
			origin.y = tmp;
		}
		
		g.updateBorders();
		g.setXLabelSouth(!invertYLabelsCB.isSelected());
		g.setYLabelWest(!invertXLabelsCB.isSelected());
		super.saveParameters();
		g.updateBorders(null);
	}

	
	
	
	@Override
	public void setFigureFrameField()
	{
		GridShape g = (GridShape)figure;
		
		xGridStart.removeChangeListener(this);
		yGridStart.removeChangeListener(this);
		xGridEnd.removeChangeListener(this);
		yGridEnd.removeChangeListener(this);
		
		xGridStart.setValue((int)g.getGridStart().x);
		xGridStart.setModel(new SpinnerNumberModel((int)g.getGridStart().x,-10000,(int)g.getGridEnd().x,1));
		yGridStart.setValue((int)g.getGridStart().y);
		yGridStart.setModel(new SpinnerNumberModel((int)g.getGridStart().y,-10000,(int)g.getGridEnd().y,1));
		xGridEnd.setValue((int)g.getGridEnd().x);
		xGridEnd.setModel(new SpinnerNumberModel((int)g.getGridEnd().x,(int)g.getGridStart().x,10000,1));
		yGridEnd.setValue((int)g.getGridEnd().y);
		yGridEnd.setModel(new SpinnerNumberModel((int)g.getGridEnd().y,(int)g.getGridStart().y,10000,1));
		
		xGridStart.addChangeListener(this);
		yGridStart.addChangeListener(this);
		xGridEnd.addChangeListener(this);
		yGridEnd.addChangeListener(this);
		
		xPosition.setValue(g.getPosition().x);
		yPosition.setValue(g.getPosition().y);
		
		if(xOrigin!=null)
		{
			xOrigin.setValue((int)g.getOrigin().x);
			yOrigin.setValue((int)g.getOrigin().y);
		}
		
		invertXLabelsCB.setSelected(!g.isYLabelWest());
		invertYLabelsCB.setSelected(!g.isXLabelSouth());
	}

	
	
	
	@Override
	public void setDefaultsValues()
	{
		super.setDefaultsValues();
		
		GridShape gs = (GridShape)glimpsePanel.glimpseFigure;
		
		invertXLabelsCB.setSelected(!GridShape.DEFAULT_ISYLABELWEST);
		invertYLabelsCB.setSelected(!GridShape.DEFAULT_ISXLABELSOUTH);
		gs.setXLabelSouth(GridShape.DEFAULT_ISXLABELSOUTH);
		gs.setYLabelWest(GridShape.DEFAULT_ISYLABELWEST);
		
		xGridStart.removeChangeListener(this);
		yGridStart.removeChangeListener(this);
		xGridEnd.removeChangeListener(this);
		yGridEnd.removeChangeListener(this);
		
		xGridStart.setValue((int)GridShape.DEFAULT_GRIDMIN.x);
		xGridStart.setModel(new SpinnerNumberModel((int)GridShape.DEFAULT_GRIDMIN.x,-10000,(int)GridShape.DEFAULT_GRIDMAX.x,1));
		yGridStart.setValue((int)GridShape.DEFAULT_GRIDMIN.y);
		yGridStart.setModel(new SpinnerNumberModel((int)GridShape.DEFAULT_GRIDMIN.y,-10000,(int)GridShape.DEFAULT_GRIDMAX.y,1));
		xGridEnd.setValue((int)GridShape.DEFAULT_GRIDMAX.x);
		xGridEnd.setModel(new SpinnerNumberModel((int)GridShape.DEFAULT_GRIDMAX.x,(int)GridShape.DEFAULT_GRIDMIN.x,10000,1));
		yGridEnd.setValue((int)GridShape.DEFAULT_GRIDMAX.y);
		yGridEnd.setModel(new SpinnerNumberModel((int)GridShape.DEFAULT_GRIDMAX.y,(int)GridShape.DEFAULT_GRIDMIN.y,10000,1));

		gs.setGridStartX((int)GridShape.DEFAULT_GRIDMIN.x);
		gs.setGridStartY((int)GridShape.DEFAULT_GRIDMIN.y);
		gs.setGridEndX((int)GridShape.DEFAULT_GRIDMAX.x);
		gs.setGridEndY((int)GridShape.DEFAULT_GRIDMAX.y);
		
		xGridStart.addChangeListener(this);
		yGridStart.addChangeListener(this);
		xGridEnd.addChangeListener(this);
		yGridEnd.addChangeListener(this);
		
		if(xOrigin!=null)
		{
			xOrigin.setValue((int)GridShape.DEFAULT_ORIGIN.x);
			yOrigin.setValue((int)GridShape.DEFAULT_ORIGIN.y);
		}
		
		gs.setOriginX((int)GridShape.DEFAULT_ORIGIN.x);
		gs.setOriginY((int)GridShape.DEFAULT_ORIGIN.y);
	}
}
