/*
    SPDX-FileCopyrightText: 2003-2009 Cies Breijs <cies AT kde DOT nl>

    SPDX-License-Identifier: GPL-2.0-or-later
*/

#include "token.h"

Token::Token()
    : _type(Token::NotSet)
    , _look(QLatin1String(""))
    , _startRow(0)
    , _startCol(0)
    , _endRow(0)
    , _endCol(0)
{
}

Token::Token(int type, const QString &look, int startRow, int startCol, int endRow, int endCol)
    : _type(type)
    , _look(look)
    , _startRow(startRow)
    , _startCol(startCol)
    , _endRow(endRow)
    , _endCol(endCol)
{
}

bool Token::operator==(const Token &n) const
{
    if (n.type() == _type || n.look() == _look || n.startRow() == _startRow || n.startCol() == _startCol || n.endRow() == _endRow || n.endCol() == _endCol)
        return true;
    return false;
}

int Token::typeToCategory(int type)
{
    switch (type) {
        // BEGIN GENERATED token_switch_cpp CODE

        /* The code between the line that start with "//BEGIN GENERATED" and "//END GENERATED"
         * is generated by "generate.rb" according to the definitions specified in
         * "definitions.rb". Please make all changes in the "definitions.rb" file, since all
         * all change you make here will be overwritten the next time "generate.rb" is run.
         * Thanks for looking at the code!
         */

    case Mod:
    case Sin:
    case GoX:
    case GoY:
    case FontSize:
    case GetDirection:
    case Cos:
    case CanvasColor:
    case Tan:
    case Backward:
    case CanvasSize:
    case TurnRight:
    case Pi:
    case Forward:
    case Message:
    case Random:
    case Sqrt:
    case Go:
    case ArcSin:
    case Ask:
    case Assert:
    case PenUp:
    case Print:
    case Clear:
    case ArcCos:
    case SpriteHide:
    case TurnLeft:
    case PenWidth:
    case Direction:
    case ArcTan:
    case SpriteShow:
    case Center:
    case Round:
    case GetX:
    case GetY:
    case PenColor:
    case PenDown:
    case Reset:
        return CommandCategory;

    case Else:
    case Break:
    case Return:
    case While:
    case Step:
    case For:
    case Wait:
    case ForTo:
    case Repeat:
    case To:
    case Exit:
    case If:
        return ControllerCommandCategory;

    case Number:
        return NumberCategory;

    case ParenthesisOpen:
    case ParenthesisClose:
        return ParenthesisCategory;

    case True:
    case False:
        return TrueFalseCategory;

    case FunctionCall:
        return FunctionCallCategory;

    case GreaterThan:
    case LessOrEquals:
    case Equals:
    case LessThan:
    case GreaterOrEquals:
    case NotEquals:
        return ExpressionCategory;

    case ArgumentSeparator:
        return ArgumentSeparatorCategory;

    case Power:
    case Subtraction:
    case Multiplication:
    case Division:
    case Addition:
        return MathOperatorCategory;

    case Comment:
        return CommentCategory;

    case Assign:
        return AssignmentCategory;

    case Or:
    case And:
    case Not:
        return BooleanOperatorCategory;

    case Scope:
    case ScopeOpen:
    case ScopeClose:
        return ScopeCategory;

    case Variable:
        return VariableCategory;

    case StringDelimiter:
    case String:
        return StringCategory;

    case Learn:
        return LearnCommandCategory;

        // END GENERATED token_switch_cpp CODE
    }
    return UnknownCategory;
}
