{- This module was generated from data in the Kate syntax
   highlighting file isocpp.xml, version 6, by Alex Turbov (i.zaufi@gmail.com) -}

module Text.Highlighting.Kate.Syntax.Isocpp
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Gcc
import qualified Text.Highlighting.Kate.Syntax.Doxygen
import qualified Text.Highlighting.Kate.Syntax.Alert
import qualified Text.Highlighting.Kate.Syntax.Modelines
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "ISO C++"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.c++;*.cxx;*.cpp;*.cc;*.C;*.h;*.hh;*.H;*.h++;*.hxx;*.hpp;*.hcc;*.moc"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("ISO C++","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("ISO C++","Normal") -> return ()
      ("ISO C++","Main") -> return ()
      ("ISO C++","UDLOperator") -> (popContext) >> pEndLine
      ("ISO C++","Char Literal") -> (popContext) >> pEndLine
      ("ISO C++","U-Char Literal") -> (popContext) >> pEndLine
      ("ISO C++","Simple Esc") -> (popContext) >> pEndLine
      ("ISO C++","Universal Char") -> (popContext) >> pEndLine
      ("ISO C++","String") -> (popContext) >> pEndLine
      ("ISO C++","UDLStringSuffix") -> (popContext >> popContext) >> pEndLine
      ("ISO C++","Attribute") -> return ()
      ("ISO C++","RawString") -> return ()
      ("ISO C++","DetectIdentifierEnd") -> (popContext) >> pEndLine
      ("ISO C++","Region Marker") -> (popContext) >> pEndLine
      ("ISO C++","DetectNSEnd") -> (popContext) >> pEndLine
      ("ISO C++","Standard Classes") -> (popContext) >> pEndLine
      ("ISO C++","Boost Stuff") -> (popContext) >> pEndLine
      ("ISO C++","InternalsNS") -> (popContext) >> pEndLine
      ("ISO C++","Comment 1") -> (popContext) >> pEndLine
      ("ISO C++","Comment 2") -> return ()
      ("ISO C++","AfterHash") -> (popContext) >> pEndLine
      ("ISO C++","Include") -> (popContext) >> pEndLine
      ("ISO C++","Preprocessor") -> (popContext) >> pEndLine
      ("ISO C++","Define") -> (popContext) >> pEndLine
      ("ISO C++","Comment/Preprocessor") -> return ()
      ("ISO C++","Outscoped Common") -> return ()
      ("ISO C++","Outscoped") -> return ()
      ("ISO C++","Outscoped 2") -> return ()
      ("ISO C++","Inscoped") -> return ()
      ("ISO C++","Outscoped intern") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_controlflow = Set.fromList $ words $ "break case catch continue default do else for goto if return switch throw try while"
list_keywords = Set.fromList $ words $ "alignof alignas asm auto class constexpr const_cast decltype delete dynamic_cast enum explicit export false final friend inline namespace new noexcept nullptr operator override private protected public reinterpret_cast sizeof static_assert static_cast struct template this true typedef typeid typename union using virtual and and_eq bitand bitor compl not not_eq or or_eq xor xor_eq"
list_template = Set.fromList $ words $ "template"
list_attributes = Set.fromList $ words $ "noreturn carries_dependency deprecated"
list_types = Set.fromList $ words $ "bool char char16_t char32_t double float int long short signed unsigned void int8_t int16_t int32_t int64_t uint8_t uint16_t uint32_t uint64_t int_least8_t int_least16_t int_least32_t int_least64_t uint_least8_t uint_least16_t uint_least32_t uint_least64_t int_fast8_t int_fast16_t int_fast32_t int_fast64_t uint_fast8_t uint_fast16_t uint_fast32_t uint_fast64_t size_t ssize_t wchar_t intptr_t uintptr_t intmax_t uintmax_t ptrdiff_t sig_atomic_t wint_t"
list_modifiers = Set.fromList $ words $ "const extern mutable register static thread_local volatile"
list_StdMacros = Set.fromList $ words $ "__FILE__ __LINE__ __DATE__ __TIME__ __STDC__ __STDC_VERSION__ __STDC_HOSTED__ __STDC_ISO_10646__ __STDC_MB_MIGHT_NEQ_WC__ __cplusplus __func__"

regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2aif'5cs'2b'280'7cfalse'29'5cs'2a = compileRegex True "(#|%\\:|\\?\\?=)\\s*if\\s+(0|false)\\s*"
regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2aif'5cs'2b'281'7ctrue'29'5cs'2a = compileRegex True "(#|%\\:|\\?\\?=)\\s*if\\s+(1|true)\\s*"
regex_operator'5cs'2a'22'22_'5f'5b'5f0'2d9A'2dZa'2dz'5d'2a'5cb = compileRegex True "operator\\s*\"\" _[_0-9A-Za-z]*\\b"
regex_operator'5cs'2a'22'22_'5b'5f0'2d9A'2dZa'2dz'5d'2a'5cb = compileRegex True "operator\\s*\"\" [_0-9A-Za-z]*\\b"
regex_'5b'5c'2b'5c'2d'5d'3f0x'5b0'2d9A'2dFa'2df'5d'28'27'3f'5b0'2d9A'2dFa'2df'5d'2b'29'2a'28'5bUu'5d'5bLl'5d'7b0'2c2'7d'7c'5bLl'5d'7b0'2c2'7d'5bUu'5d'3f'7c'5f'5b'5f0'2d9A'2dZa'2dz'5d'2a'29'3f'5cb = compileRegex True "[\\+\\-]?0x[0-9A-Fa-f]('?[0-9A-Fa-f]+)*([Uu][Ll]{0,2}|[Ll]{0,2}[Uu]?|_[_0-9A-Za-z]*)?\\b"
regex_0'5bBb'5d'5b01'5d'28'27'3f'5b01'5d'2b'29'2a'28'5bUu'5d'5bLl'5d'7b0'2c2'7d'7c'5bLl'5d'7b0'2c2'7d'5bUu'5d'3f'7c'5f'5b'5f0'2d9A'2dZa'2dz'5d'2a'29'3f'5cb = compileRegex True "0[Bb][01]('?[01]+)*([Uu][Ll]{0,2}|[Ll]{0,2}[Uu]?|_[_0-9A-Za-z]*)?\\b"
regex_'5b'5c'2b'5c'2d'5d'3f0'27'3f'5b0'2d7'5d'28'27'3f'5b0'2d7'5d'2b'29'2a'28'5bUu'5d'5bLl'5d'7b0'2c2'7d'7c'5bLl'5d'7b0'2c2'7d'5bUu'5d'3f'7c'5f'5b'5f0'2d9A'2dZa'2dz'5d'2a'29'3f'5cb = compileRegex True "[\\+\\-]?0'?[0-7]('?[0-7]+)*([Uu][Ll]{0,2}|[Ll]{0,2}[Uu]?|_[_0-9A-Za-z]*)?\\b"
regex_'5b'5c'2b'5c'2d'5d'3f'280'7c'5b1'2d9'5d'28'27'3f'5b0'2d9'5d'2b'29'2a'29'28'5bUu'5d'5bLl'5d'7b0'2c2'7d'7c'5bLl'5d'7b0'2c2'7d'5bUu'5d'3f'7c'5f'5b'5f0'2d9A'2dZa'2dz'5d'2a'29'3f'5cb = compileRegex True "[\\+\\-]?(0|[1-9]('?[0-9]+)*)([Uu][Ll]{0,2}|[Ll]{0,2}[Uu]?|_[_0-9A-Za-z]*)?\\b"
regex_'5b'5c'2b'5c'2d'5d'3f'280x'3f'7c'5b1'2d9'5d'5b0'2d9'5d'2a'29'5b0'2d9A'2dZa'2dz'5d'5b'5f0'2d9A'2dZa'2dz'5d'2a'5cb = compileRegex True "[\\+\\-]?(0x?|[1-9][0-9]*)[0-9A-Za-z][_0-9A-Za-z]*\\b"
regex_'28u'7cu8'7cU'7cL'29'3fR'22'28'5b'5e'5c'28'5d'7b0'2c16'7d'29'5c'28 = compileRegex True "(u|u8|U|L)?R\"([^\\(]{0,16})\\("
regex_'28u'7cu8'7cU'7cL'29'3fR'22'28'5b'5e'5c'28'5d'7b16'2c'7d'29'5c'28 = compileRegex True "(u|u8|U|L)?R\"([^\\(]{16,})\\("
regex_'5f'5ba'2dzA'2dZ0'2d9'5f'5d'2b = compileRegex True "_[a-zA-Z0-9_]+"
regex_'5ba'2dzA'2dZ'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'5f'5f'5cb = compileRegex True "[a-zA-Z][a-zA-Z0-9_]*__\\b"
regex_'5ba'2dz'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'5f'5cb = compileRegex True "[a-z][a-zA-Z0-9_]*_\\b"
regex_m'5f'5ba'2dzA'2dZ0'2d9'5f'5d'2b = compileRegex True "m_[a-zA-Z0-9_]+"
regex_g'5f'5ba'2dzA'2dZ0'2d9'5f'5d'2b = compileRegex True "g_[a-zA-Z0-9_]+"
regex_s'5f'5ba'2dzA'2dZ0'2d9'5f'5d'2b = compileRegex True "s_[a-zA-Z0-9_]+"
regex_'5bA'2dZ'5d'5bA'2dZ0'2d9'5f'5d'7b2'2c'7d'5cb = compileRegex True "[A-Z][A-Z0-9_]{2,}\\b"
regex_'5ba'2dzA'2dZ'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'5ft'28ype'29'3f'5cb = compileRegex True "[a-zA-Z][a-zA-Z0-9_]*_t(ype)?\\b"
regex_'5b'5e'27'5d'7b2'2c'7d = compileRegex True "[^']{2,}"
regex_'2e'7b1'7d = compileRegex True ".{1}"
regex_'5b0'2d7'5d'7b1'2c3'7d = compileRegex True "[0-7]{1,3}"
regex_x'5b0'2d9A'2dFa'2df'5d'7b1'2c'7d = compileRegex True "x[0-9A-Fa-f]{1,}"
regex_'2e = compileRegex True "."
regex_'5c'5cu'5b0'2d9A'2dFa'2df'5d'7b4'7d = compileRegex True "\\\\u[0-9A-Fa-f]{4}"
regex_'5c'5cu'2e'7b0'2c3'7d = compileRegex True "\\\\u.{0,3}"
regex_'5c'5cU'5b0'2d9A'2dFa'2df'5d'7b8'7d = compileRegex True "\\\\U[0-9A-Fa-f]{8}"
regex_'5c'5cU'2e'7b0'2c7'7d = compileRegex True "\\\\U.{0,7}"
regex_'25'5b'5e'22diouxXeEfFgGaAcsP'25'5cs'5d'2a'5bdiouxXeEfFgGaAcsP'25'5d = compileRegex True "%[^\"diouxXeEfFgGaAcsP%\\s]*[diouxXeEfFgGaAcsP%]"
regex_'5f'5b'5f0'2d9A'2dZ'2da'2dz'5d'2a'5cb = compileRegex True "_[_0-9A-Z-a-z]*\\b"
regex_'2e'2a = compileRegex True ".*"
regex_'23'5cs'2a'28'3f'3ainclude'7cinclude'5fnext'29 = compileRegex True "#\\s*(?:include|include_next)"
regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2aif'28'3f'3adef'7cndef'29'3f'28'3f'3d'28'3f'3a'5c'28'7c'5cs'2b'29'5cS'29 = compileRegex True "(#|%\\:|\\?\\?=)\\s*if(?:def|ndef)?(?=(?:\\(|\\s+)\\S)"
regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2aendif = compileRegex True "(#|%\\:|\\?\\?=)\\s*endif"
regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2a'28cmake'29'3fdefine'2e'2a'28'28'3f'3d'5c'5c'29'29 = compileRegex True "(#|%\\:|\\?\\?=)\\s*(cmake)?define.*((?=\\\\))"
regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2a'28'3f'3ael'28'3f'3ase'7cif'29'7c'28cmake'29'3fdefine'7cundef'7cline'7cerror'7cwarning'7cpragma'29 = compileRegex True "(#|%\\:|\\?\\?=)\\s*(?:el(?:se|if)|(cmake)?define|undef|line|error|warning|pragma)"
regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2b'5b0'2d9'5d'2b = compileRegex True "(#|%\\:|\\?\\?=)\\s+[0-9]+"
regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2aif = compileRegex True "(#|%\\:|\\?\\?=)\\s*if"
regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2ael'28'3f'3ase'7cif'29 = compileRegex True "(#|%\\:|\\?\\?=)\\s*el(?:se|if)"

parseRules ("ISO C++","Normal") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2aif'5cs'2b'280'7cfalse'29'5cs'2a >>= withAttribute PreprocessorTok) >>~ pushContext ("ISO C++","Outscoped"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2aif'5cs'2b'281'7ctrue'29'5cs'2a >>= withAttribute PreprocessorTok) >>~ pushContext ("ISO C++","Inscoped"))
   <|>
   ((parseRules ("ISO C++","Main")))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("ISO C++","Main") =
  (((pFirstNonSpace >> lookAhead (pDetectChar False '#') >> pushContext ("ISO C++","AfterHash") >> currentContext >>= parseRules))
   <|>
   ((pFirstNonSpace >> lookAhead (pDetect2Chars False '%' ':') >> pushContext ("ISO C++","AfterHash") >> currentContext >>= parseRules))
   <|>
   ((pFirstNonSpace >> lookAhead (pString False "??=") >> pushContext ("ISO C++","AfterHash") >> currentContext >>= parseRules))
   <|>
   ((pDetect2Chars False '%' ':' >>= withAttribute ErrorTok))
   <|>
   ((pString False "??=" >>= withAttribute ErrorTok))
   <|>
   ((pFirstNonSpace >> pString False "//BEGIN" >>= withAttribute RegionMarkerTok) >>~ pushContext ("ISO C++","Region Marker"))
   <|>
   ((pFirstNonSpace >> pString False "//END" >>= withAttribute RegionMarkerTok) >>~ pushContext ("ISO C++","Region Marker"))
   <|>
   ((lookAhead (pRegExpr regex_operator'5cs'2a'22'22_'5f'5b'5f0'2d9A'2dZa'2dz'5d'2a'5cb) >> pushContext ("ISO C++","UDLOperator") >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_operator'5cs'2a'22'22_'5b'5f0'2d9A'2dZa'2dz'5d'2a'5cb >>= withAttribute ErrorTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_controlflow >>= withAttribute ControlFlowTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pDetect2Chars False '[' '[' >>= withAttribute NormalTok) >>~ pushContext ("ISO C++","Attribute"))
   <|>
   ((pRegExpr regex_'5b'5c'2b'5c'2d'5d'3f0x'5b0'2d9A'2dFa'2df'5d'28'27'3f'5b0'2d9A'2dFa'2df'5d'2b'29'2a'28'5bUu'5d'5bLl'5d'7b0'2c2'7d'7c'5bLl'5d'7b0'2c2'7d'5bUu'5d'3f'7c'5f'5b'5f0'2d9A'2dZa'2dz'5d'2a'29'3f'5cb >>= withAttribute BaseNTok))
   <|>
   ((pRegExpr regex_0'5bBb'5d'5b01'5d'28'27'3f'5b01'5d'2b'29'2a'28'5bUu'5d'5bLl'5d'7b0'2c2'7d'7c'5bLl'5d'7b0'2c2'7d'5bUu'5d'3f'7c'5f'5b'5f0'2d9A'2dZa'2dz'5d'2a'29'3f'5cb >>= withAttribute BaseNTok))
   <|>
   (withChildren (pFloat >>= withAttribute FloatTok) ((pAnyChar "FfLl" >>= withAttribute FloatTok)))
   <|>
   ((pRegExpr regex_'5b'5c'2b'5c'2d'5d'3f0'27'3f'5b0'2d7'5d'28'27'3f'5b0'2d7'5d'2b'29'2a'28'5bUu'5d'5bLl'5d'7b0'2c2'7d'7c'5bLl'5d'7b0'2c2'7d'5bUu'5d'3f'7c'5f'5b'5f0'2d9A'2dZa'2dz'5d'2a'29'3f'5cb >>= withAttribute BaseNTok))
   <|>
   ((pRegExpr regex_'5b'5c'2b'5c'2d'5d'3f'280'7c'5b1'2d9'5d'28'27'3f'5b0'2d9'5d'2b'29'2a'29'28'5bUu'5d'5bLl'5d'7b0'2c2'7d'7c'5bLl'5d'7b0'2c2'7d'5bUu'5d'3f'7c'5f'5b'5f0'2d9A'2dZa'2dz'5d'2a'29'3f'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5b'5c'2b'5c'2d'5d'3f'280x'3f'7c'5b1'2d9'5d'5b0'2d9'5d'2a'29'5b0'2d9A'2dZa'2dz'5d'5b'5f0'2d9A'2dZa'2dz'5d'2a'5cb >>= withAttribute ErrorTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("ISO C++","String"))
   <|>
   ((pDetect2Chars False 'U' '"' >>= withAttribute StringTok) >>~ pushContext ("ISO C++","String"))
   <|>
   ((pDetect2Chars False 'u' '"' >>= withAttribute StringTok) >>~ pushContext ("ISO C++","String"))
   <|>
   ((pDetect2Chars False 'L' '"' >>= withAttribute StringTok) >>~ pushContext ("ISO C++","String"))
   <|>
   ((pString False "u8\"" >>= withAttribute StringTok) >>~ pushContext ("ISO C++","String"))
   <|>
   ((lookAhead (pRegExpr regex_'28u'7cu8'7cU'7cL'29'3fR'22'28'5b'5e'5c'28'5d'7b0'2c16'7d'29'5c'28) >> pushContext ("ISO C++","RawString") >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_'28u'7cu8'7cU'7cL'29'3fR'22'28'5b'5e'5c'28'5d'7b16'2c'7d'29'5c'28 >>= withAttribute ErrorTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("ISO C++","Char Literal"))
   <|>
   ((pDetect2Chars False 'L' '\'' >>= withAttribute StringTok) >>~ pushContext ("ISO C++","Char Literal"))
   <|>
   ((pDetect2Chars False 'u' '\'' >>= withAttribute StringTok) >>~ pushContext ("ISO C++","U-Char Literal"))
   <|>
   ((pDetect2Chars False 'U' '\'' >>= withAttribute StringTok) >>~ pushContext ("ISO C++","U-Char Literal"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Gcc.parseExpression (Just ("GCCExtensions","DetectGccExtensions"))))
   <|>
   ((pString False "std::" >>= withAttribute BuiltInTok) >>~ pushContext ("ISO C++","Standard Classes"))
   <|>
   ((pString False "boost::" >>= withAttribute ExtensionTok) >>~ pushContext ("ISO C++","Boost Stuff"))
   <|>
   ((pString False "BOOST_" >>= withAttribute ExtensionTok) >>~ pushContext ("ISO C++","Boost Stuff"))
   <|>
   ((pString False "detail::" >>= withAttribute NormalTok) >>~ pushContext ("ISO C++","InternalsNS"))
   <|>
   ((pString False "details::" >>= withAttribute NormalTok) >>~ pushContext ("ISO C++","InternalsNS"))
   <|>
   ((pString False "aux::" >>= withAttribute NormalTok) >>~ pushContext ("ISO C++","InternalsNS"))
   <|>
   ((pString False "internals::" >>= withAttribute NormalTok) >>~ pushContext ("ISO C++","InternalsNS"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_modifiers >>= withAttribute AttributeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_StdMacros >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5f'5ba'2dzA'2dZ0'2d9'5f'5d'2b >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'5f'5f'5cb >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5ba'2dz'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'5f'5cb >>= withAttribute VariableTok))
   <|>
   ((pRegExpr regex_m'5f'5ba'2dzA'2dZ0'2d9'5f'5d'2b >>= withAttribute VariableTok))
   <|>
   ((pRegExpr regex_g'5f'5ba'2dzA'2dZ0'2d9'5f'5d'2b >>= withAttribute VariableTok))
   <|>
   ((pRegExpr regex_s'5f'5ba'2dzA'2dZ0'2d9'5f'5d'2b >>= withAttribute VariableTok))
   <|>
   ((pRegExpr regex_'5bA'2dZ'5d'5bA'2dZ0'2d9'5f'5d'7b2'2c'7d'5cb >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'5ft'28ype'29'3f'5cb >>= withAttribute DataTypeTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression (Just ("Doxygen",""))))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("ISO C++","Comment 1"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("ISO C++","Comment 2"))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   ((pAnyChar ",;" >>= withAttribute NormalTok))
   <|>
   ((pAnyChar ":!% &()+-/.*<=>?[]{|}~^,;" >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '#' >>= withAttribute ErrorTok))
   <|>
   ((pDetectChar False '$' >>= withAttribute ErrorTok))
   <|>
   ((pDetectChar False '@' >>= withAttribute ErrorTok))
   <|>
   ((pDetectChar False '`' >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","Main")) >> pDefault >>= withAttribute NormalTok))

parseRules ("ISO C++","UDLOperator") =
  (((pString False "operator" >>= withAttribute KeywordTok))
   <|>
   ((pString False "\"\"" >>= withAttribute StringTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","UDLOperator")) >> pDefault >>= withAttribute NormalTok))

parseRules ("ISO C++","Char Literal") =
  (((parseRules ("ISO C++","Universal Char")))
   <|>
   ((pDetectChar False '\\' >>= withAttribute SpecialCharTok) >>~ pushContext ("ISO C++","Simple Esc"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","Char Literal")) >> pDefault >>= withAttribute StringTok))

parseRules ("ISO C++","U-Char Literal") =
  (((parseRules ("ISO C++","Universal Char")))
   <|>
   ((pDetectChar False '\\' >>= withAttribute SpecialCharTok) >>~ pushContext ("ISO C++","Simple Esc"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5b'5e'27'5d'7b2'2c'7d >>= withAttribute ErrorTok))
   <|>
   ((pRegExpr regex_'2e'7b1'7d >>= withAttribute StringTok))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","U-Char Literal")) >> pDefault >>= withAttribute StringTok))

parseRules ("ISO C++","Simple Esc") =
  (((pAnyChar "tnvbrfa'\"\\" >>= withAttribute SpecialCharTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5b0'2d7'5d'7b1'2c3'7d >>= withAttribute SpecialCharTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_x'5b0'2d9A'2dFa'2df'5d'7b1'2c'7d >>= withAttribute SpecialCharTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'2e >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","Simple Esc")) >> pDefault >>= withAttribute SpecialCharTok))

parseRules ("ISO C++","Universal Char") =
  (((pRegExpr regex_'5c'5cu'5b0'2d9A'2dFa'2df'5d'7b4'7d >>= withAttribute SpecialCharTok))
   <|>
   ((pRegExpr regex_'5c'5cu'2e'7b0'2c3'7d >>= withAttribute ErrorTok))
   <|>
   ((pRegExpr regex_'5c'5cU'5b0'2d9A'2dFa'2df'5d'7b8'7d >>= withAttribute SpecialCharTok))
   <|>
   ((pRegExpr regex_'5c'5cU'2e'7b0'2c7'7d >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","Universal Char")) >> pDefault >>= withAttribute SpecialCharTok))

parseRules ("ISO C++","String") =
  (((pLineContinue >>= withAttribute StringTok))
   <|>
   ((pHlCStringChar >>= withAttribute SpecialCharTok))
   <|>
   ((parseRules ("ISO C++","Universal Char")))
   <|>
   ((pRegExpr regex_'25'5b'5e'22diouxXeEfFgGaAcsP'25'5cs'5d'2a'5bdiouxXeEfFgGaAcsP'25'5d >>= withAttribute SpecialCharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("ISO C++","UDLStringSuffix"))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("ISO C++","UDLStringSuffix") =
  (((pRegExpr regex_'5f'5b'5f0'2d9A'2dZ'2da'2dz'5d'2a'5cb >>= withAttribute StringTok) >>~ (popContext >> popContext))
   <|>
   ((lookAhead (pRegExpr regex_'2e'2a) >> (popContext >> popContext) >> currentContext >>= parseRules))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","UDLStringSuffix")) >> pDefault >>= withAttribute StringTok))

parseRules ("ISO C++","Attribute") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_attributes >>= withAttribute AttributeTok))
   <|>
   ((pDetect2Chars False ']' ']' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pAnyChar "!% &()+-/.*<=>?[]{|}~^,;" >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("ISO C++","String"))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","Attribute")) >> pDefault >>= withAttribute AttributeTok))

parseRules ("ISO C++","RawString") =
  (((pLineContinue >>= withAttribute StringTok))
   <|>
   ((pRegExpr regex_'25'5b'5e'22diouxXeEfFgGaAcsP'25'5cs'5d'2a'5bdiouxXeEfFgGaAcsP'25'5d >>= withAttribute SpecialCharTok))
   <|>
   ((pRegExprDynamic "\\)%2\"" >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","RawString")) >> pDefault >>= withAttribute StringTok))

parseRules ("ISO C++","DetectIdentifierEnd") =
  (((pAnyChar ":!% &()+-/.*<=>?[]{|}~^,;" >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","DetectIdentifierEnd")) >> pDefault >>= withAttribute NormalTok))

parseRules ("ISO C++","Region Marker") =
  (currentContext >>= \x -> guard (x == ("ISO C++","Region Marker")) >> pDefault >>= withAttribute RegionMarkerTok)

parseRules ("ISO C++","DetectNSEnd") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_template >>= withAttribute KeywordTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((pAnyChar ",;" >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pAnyChar "!% &()+-/.*<=>?[]{|}~^,;" >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pAnyChar " " >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","DetectNSEnd")) >> pDefault >>= withAttribute NormalTok))

parseRules ("ISO C++","Standard Classes") =
  (((parseRules ("ISO C++","DetectNSEnd")))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","Standard Classes")) >> pDefault >>= withAttribute BuiltInTok))

parseRules ("ISO C++","Boost Stuff") =
  (((parseRules ("ISO C++","DetectNSEnd")))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","Boost Stuff")) >> pDefault >>= withAttribute ExtensionTok))

parseRules ("ISO C++","InternalsNS") =
  (((parseRules ("ISO C++","DetectNSEnd")))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","InternalsNS")) >> pDefault >>= withAttribute NormalTok))

parseRules ("ISO C++","Comment 1") =
  (((pLineContinue >>= withAttribute CommentTok))
   <|>
   ((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((Text.Highlighting.Kate.Syntax.Modelines.parseExpression (Just ("Modelines","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","Comment 1")) >> pDefault >>= withAttribute CommentTok))

parseRules ("ISO C++","Comment 2") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pLineContinue >>= withAttribute CommentTok))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((Text.Highlighting.Kate.Syntax.Modelines.parseExpression (Just ("Modelines","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","Comment 2")) >> pDefault >>= withAttribute CommentTok))

parseRules ("ISO C++","AfterHash") =
  (((pFirstNonSpace >> pRegExpr regex_'23'5cs'2a'28'3f'3ainclude'7cinclude'5fnext'29 >>= withAttribute PreprocessorTok) >>~ pushContext ("ISO C++","Include"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2aif'28'3f'3adef'7cndef'29'3f'28'3f'3d'28'3f'3a'5c'28'7c'5cs'2b'29'5cS'29 >>= withAttribute PreprocessorTok) >>~ pushContext ("ISO C++","Preprocessor"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2aendif >>= withAttribute PreprocessorTok) >>~ pushContext ("ISO C++","Preprocessor"))
   <|>
   ((pFirstNonSpace >> lookAhead (pRegExpr regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2a'28cmake'29'3fdefine'2e'2a'28'28'3f'3d'5c'5c'29'29) >> pushContext ("ISO C++","Define") >> currentContext >>= parseRules))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2a'28'3f'3ael'28'3f'3ase'7cif'29'7c'28cmake'29'3fdefine'7cundef'7cline'7cerror'7cwarning'7cpragma'29 >>= withAttribute PreprocessorTok) >>~ pushContext ("ISO C++","Preprocessor"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2b'5b0'2d9'5d'2b >>= withAttribute PreprocessorTok) >>~ pushContext ("ISO C++","Preprocessor"))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","AfterHash")) >> pDefault >>= withAttribute ErrorTok))

parseRules ("ISO C++","Include") =
  (((pLineContinue >>= withAttribute PreprocessorTok))
   <|>
   ((pRangeDetect '"' '"' >>= withAttribute ImportTok))
   <|>
   ((pRangeDetect '<' '>' >>= withAttribute ImportTok))
   <|>
   ((parseRules ("ISO C++","Preprocessor")))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","Include")) >> pDefault >>= withAttribute PreprocessorTok))

parseRules ("ISO C++","Preprocessor") =
  (((pLineContinue >>= withAttribute PreprocessorTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_StdMacros >>= withAttribute OtherTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Gcc.parseExpression (Just ("GCCExtensions","GNUMacros")) >>= ((withAttribute PreprocessorTok) . snd)))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression (Just ("Doxygen","")) >>= ((withAttribute PreprocessorTok) . snd)))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("ISO C++","Comment/Preprocessor"))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("ISO C++","Comment 1"))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","Preprocessor")) >> pDefault >>= withAttribute PreprocessorTok))

parseRules ("ISO C++","Define") =
  (((pLineContinue >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '\\' >>= withAttribute ErrorTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_StdMacros >>= withAttribute OtherTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Gcc.parseExpression (Just ("GCCExtensions","GNUMacros")) >>= ((withAttribute PreprocessorTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","Define")) >> pDefault >>= withAttribute PreprocessorTok))

parseRules ("ISO C++","Comment/Preprocessor") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","Comment/Preprocessor")) >> pDefault >>= withAttribute CommentTok))

parseRules ("ISO C++","Outscoped Common") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((Text.Highlighting.Kate.Syntax.Modelines.parseExpression (Just ("Modelines","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression (Just ("Doxygen","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("ISO C++","Comment 1"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2aif >>= withAttribute CommentTok) >>~ pushContext ("ISO C++","Outscoped intern"))
   <|>
   ((pLineContinue >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","Outscoped Common")) >> pDefault >>= withAttribute CommentTok))

parseRules ("ISO C++","Outscoped") =
  (((parseRules ("ISO C++","Outscoped Common")))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2ael'28'3f'3ase'7cif'29 >>= withAttribute PreprocessorTok) >>~ (popContext))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2aendif >>= withAttribute PreprocessorTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","Outscoped")) >> pDefault >>= withAttribute CommentTok))

parseRules ("ISO C++","Outscoped 2") =
  (((parseRules ("ISO C++","Outscoped Common")))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2aendif >>= withAttribute PreprocessorTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","Outscoped 2")) >> pDefault >>= withAttribute CommentTok))

parseRules ("ISO C++","Inscoped") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2aif'5cs'2b'280'7cfalse'29'5cs'2a >>= withAttribute PreprocessorTok) >>~ pushContext ("ISO C++","Outscoped"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2ael'28'3f'3ase'7cif'29 >>= withAttribute PreprocessorTok) >>~ pushContext ("ISO C++","Outscoped 2"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2aendif >>= withAttribute PreprocessorTok) >>~ (popContext))
   <|>
   ((parseRules ("ISO C++","Main")))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","Inscoped")) >> pDefault >>= withAttribute NormalTok))

parseRules ("ISO C++","Outscoped intern") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((Text.Highlighting.Kate.Syntax.Modelines.parseExpression (Just ("Modelines","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression (Just ("Doxygen","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("ISO C++","Comment 1"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("ISO C++","Comment 2"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2aif >>= withAttribute CommentTok) >>~ pushContext ("ISO C++","Outscoped intern"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'28'23'7c'25'5c'3a'7c'5c'3f'5c'3f'3d'29'5cs'2aendif >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("ISO C++","Outscoped intern")) >> pDefault >>= withAttribute CommentTok))

parseRules ("GCCExtensions", _) = Text.Highlighting.Kate.Syntax.Gcc.parseExpression Nothing
parseRules ("Doxygen", _) = Text.Highlighting.Kate.Syntax.Doxygen.parseExpression Nothing
parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing
parseRules ("Modelines", _) = Text.Highlighting.Kate.Syntax.Modelines.parseExpression Nothing

parseRules x = parseRules ("ISO C++","Normal") <|> fail ("Unknown context" ++ show x)
