// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Information about the acquisition, creates the info file
// ****************************************************************************

// Copyright 2008, 2009, 2010, 2011, 2012, 2013, 2014 Guy Voncken
//
// This file is part of guymager.
//
// guymager is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// guymager is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with guymager. If not, see <http://www.gnu.org/licenses/>.

#ifndef __INFO_H__
#define __INFO_H__

#include <QObject>

#ifndef __COMMON_H__
   #include "common.h"
#endif


class t_InfoLocal;

class t_Info: public QObject
{
   Q_OBJECT

   public:
      t_Info (t_pcAcquisition pAcquisition=NULL);
     ~t_Info (void);

//      void   SetAcquisiiton  (t_pcAcquisition pAcquisition);
      APIRET Create     (void);
      APIRET vWrite     (const char *pFormat, va_list pArguments);
      APIRET Write      (const char *pFormat, ...) __attribute__ ((format (printf, 2, 3))); // Non-static class functions have implicit this argument, thus we start counting the parameters for __attribute__ at 2, not 1 (see GNU C-Lib Function-Atttributes.html)
      APIRET Write      (const QString &Text);
      APIRET WriteLn    (const QString &Text=QString());
      APIRET Title      (const QString &Text);
      APIRET InitTable  (const QString &ColSep, const QString &ColSepReplace);
      APIRET AddRow     (const QString &Row);
      APIRET WriteTable (void);

      APIRET WriteDeviceInfo (void);

      static APIRET GetDeviceInfo (t_pcDevice pDevice, bool RichText, QString &Info);

   private:
      QString FullFileName (void);

   private:
      t_InfoLocal *pOwn;
};

typedef t_Info *t_pInfo;


// ------------------------------------
//             Error codes
// ------------------------------------

   #ifdef __MODULES_H__
      enum
      {
         ERROR_INFO_FILE_CREATE_FAILED  = ERROR_BASE_INFO + 1,
         ERROR_INFO_FILE_OPEN_FAILED,
         ERROR_INFO_FILE_WRITE_FAILED,
         ERROR_INFO_FILE_CLOSE_FAILED,
      };
   #endif

#endif

