#include "config.h"
#include "rdp_keymap.h"
#include <freerdp/input.h>

#ifdef HAVE_FREERDP_LOCALE_KEYBOARD_H
#include <freerdp/locale/keyboard.h>
#else
#include <freerdp/kbd/layouts.h>
#endif

#include <stddef.h>


/* Autogenerated from keymaps/base.keymap */
static guac_rdp_keysym_desc __guac_rdp_keymap_base[] = {
    { .keysym = 32, .scancode = 57 },
    { .keysym = 65289, .scancode = 15 },
    { .keysym = 65288, .scancode = 14 },
    { .keysym = 65293, .scancode = 28 },
    { .keysym = 65307, .scancode = 1 },
    { .keysym = 65379, .scancode = 82, .flags = KBD_FLAGS_EXTENDED },
    { .keysym = 65535, .scancode = 83, .flags = KBD_FLAGS_EXTENDED },
    { .keysym = 65360, .scancode = 71, .flags = KBD_FLAGS_EXTENDED },
    { .keysym = 65367, .scancode = 79, .flags = KBD_FLAGS_EXTENDED },
    { .keysym = 65361, .scancode = 75, .flags = KBD_FLAGS_EXTENDED },
    { .keysym = 65362, .scancode = 72, .flags = KBD_FLAGS_EXTENDED },
    { .keysym = 65363, .scancode = 77, .flags = KBD_FLAGS_EXTENDED },
    { .keysym = 65364, .scancode = 80, .flags = KBD_FLAGS_EXTENDED },
    { .keysym = 65365, .scancode = 73, .flags = KBD_FLAGS_EXTENDED },
    { .keysym = 65366, .scancode = 81, .flags = KBD_FLAGS_EXTENDED },
    { .keysym = 65407, .scancode = 69 },
    { .keysym = 65300, .scancode = 70 },
    { .keysym = 65509, .scancode = 58, .flags = KBD_FLAGS_EXTENDED },
    { .keysym = 65456, .scancode = 82 },
    { .keysym = 65457, .scancode = 79 },
    { .keysym = 65458, .scancode = 80 },
    { .keysym = 65459, .scancode = 81 },
    { .keysym = 65460, .scancode = 75 },
    { .keysym = 65461, .scancode = 76 },
    { .keysym = 65462, .scancode = 77 },
    { .keysym = 65463, .scancode = 71 },
    { .keysym = 65464, .scancode = 72 },
    { .keysym = 65465, .scancode = 73 },
    { .keysym = 65450, .scancode = 55 },
    { .keysym = 65451, .scancode = 78 },
    { .keysym = 65453, .scancode = 74 },
    { .keysym = 65454, .scancode = 83 },
    { .keysym = 65455, .scancode = 53, .flags = KBD_FLAGS_EXTENDED },
    { .keysym = 65470, .scancode = 59 },
    { .keysym = 65471, .scancode = 60 },
    { .keysym = 65472, .scancode = 61 },
    { .keysym = 65473, .scancode = 62 },
    { .keysym = 65474, .scancode = 63 },
    { .keysym = 65475, .scancode = 64 },
    { .keysym = 65476, .scancode = 65 },
    { .keysym = 65477, .scancode = 66 },
    { .keysym = 65478, .scancode = 67 },
    { .keysym = 65479, .scancode = 68 },
    { .keysym = 65480, .scancode = 87 },
    { .keysym = 65481, .scancode = 88 },
    { .keysym = 65505, .scancode = 42 },
    { .keysym = 65506, .scancode = 54 },
    { .keysym = 65507, .scancode = 29 },
    { .keysym = 65508, .scancode = 157 },
    { .keysym = 65513, .scancode = 56 },
    { .keysym = 65514, .scancode = 56, .flags = KBD_FLAGS_EXTENDED },
    { .keysym = 65515, .scancode = 91, .flags = KBD_FLAGS_EXTENDED },
    { .keysym = 65516, .scancode = 92, .flags = KBD_FLAGS_EXTENDED },
    { .keysym = 65383, .scancode = 93, .flags = KBD_FLAGS_EXTENDED },
    {0}
};

static const guac_rdp_keymap guac_rdp_keymap_base = { 
    .name = "base",
    .mapping = __guac_rdp_keymap_base
};

/* Autogenerated from keymaps/failsafe.keymap */
static guac_rdp_keysym_desc __guac_rdp_keymap_failsafe[] = {
    {0}
};

static const guac_rdp_keymap guac_rdp_keymap_failsafe = { 
    .name = "failsafe",
    .parent = &guac_rdp_keymap_base,
    .freerdp_keyboard_layout = KBD_US,
    .mapping = __guac_rdp_keymap_failsafe
};

/* Autogenerated from keymaps/de_de_qwertz.keymap */
static guac_rdp_keysym_desc __guac_rdp_keymap_de_de_qwertz[] = {
    { .keysym = 49, .scancode = 2, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 50, .scancode = 3, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 51, .scancode = 4, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 52, .scancode = 5, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 53, .scancode = 6, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 54, .scancode = 7, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 55, .scancode = 8, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 56, .scancode = 9, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 57, .scancode = 10, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 48, .scancode = 11, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 223, .scancode = 12, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 113, .scancode = 16, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 119, .scancode = 17, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 101, .scancode = 18, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 114, .scancode = 19, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 116, .scancode = 20, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 122, .scancode = 21, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 117, .scancode = 22, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 105, .scancode = 23, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 111, .scancode = 24, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 112, .scancode = 25, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 252, .scancode = 26, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 43, .scancode = 27, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 97, .scancode = 30, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 115, .scancode = 31, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 100, .scancode = 32, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 102, .scancode = 33, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 103, .scancode = 34, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 104, .scancode = 35, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 106, .scancode = 36, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 107, .scancode = 37, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 108, .scancode = 38, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 246, .scancode = 39, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 228, .scancode = 40, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 35, .scancode = 43, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 60, .scancode = 86, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 121, .scancode = 44, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 120, .scancode = 45, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 99, .scancode = 46, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 118, .scancode = 47, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 98, .scancode = 48, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 110, .scancode = 49, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 109, .scancode = 50, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 44, .scancode = 51, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 46, .scancode = 52, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 45, .scancode = 53, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 176, .scancode = 41, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 33, .scancode = 2, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 34, .scancode = 3, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 167, .scancode = 4, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 36, .scancode = 5, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 37, .scancode = 6, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 38, .scancode = 7, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 47, .scancode = 8, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 40, .scancode = 9, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 41, .scancode = 10, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 61, .scancode = 11, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 63, .scancode = 12, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 81, .scancode = 16, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 87, .scancode = 17, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 69, .scancode = 18, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 82, .scancode = 19, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 84, .scancode = 20, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 90, .scancode = 21, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 85, .scancode = 22, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 73, .scancode = 23, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 79, .scancode = 24, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 80, .scancode = 25, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 220, .scancode = 26, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 42, .scancode = 27, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 65, .scancode = 30, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 83, .scancode = 31, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 68, .scancode = 32, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 70, .scancode = 33, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 71, .scancode = 34, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 72, .scancode = 35, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 74, .scancode = 36, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 75, .scancode = 37, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 76, .scancode = 38, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 214, .scancode = 39, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 196, .scancode = 40, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 39, .scancode = 43, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 62, .scancode = 86, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 89, .scancode = 44, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 88, .scancode = 45, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 67, .scancode = 46, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 86, .scancode = 47, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 66, .scancode = 48, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 78, .scancode = 49, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 77, .scancode = 50, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 59, .scancode = 51, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 58, .scancode = 52, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 95, .scancode = 53, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 178, .scancode = 3, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 179, .scancode = 4, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 123, .scancode = 8, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 91, .scancode = 9, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 93, .scancode = 10, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 125, .scancode = 11, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 92, .scancode = 12, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 64, .scancode = 16, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 16785580, .scancode = 18, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 124, .scancode = 86, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 181, .scancode = 50, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 65104, .scancode = 13, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 65105, .scancode = 13, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 65106, .scancode = 41, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 65107, .scancode = 12, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    {0}
};

static const guac_rdp_keymap guac_rdp_keymap_de_de_qwertz = { 
    .name = "de-de-qwertz",
    .parent = &guac_rdp_keymap_base,
    .freerdp_keyboard_layout = KBD_GERMAN,
    .mapping = __guac_rdp_keymap_de_de_qwertz
};

/* Autogenerated from keymaps/en_us_qwerty.keymap */
static guac_rdp_keysym_desc __guac_rdp_keymap_en_us_qwerty[] = {
    { .keysym = 96, .scancode = 41, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 49, .scancode = 2, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 50, .scancode = 3, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 51, .scancode = 4, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 52, .scancode = 5, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 53, .scancode = 6, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 54, .scancode = 7, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 55, .scancode = 8, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 56, .scancode = 9, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 57, .scancode = 10, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 48, .scancode = 11, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 45, .scancode = 12, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 61, .scancode = 13, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 113, .scancode = 16, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 119, .scancode = 17, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 101, .scancode = 18, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 114, .scancode = 19, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 116, .scancode = 20, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 121, .scancode = 21, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 117, .scancode = 22, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 105, .scancode = 23, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 111, .scancode = 24, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 112, .scancode = 25, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 91, .scancode = 26, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 93, .scancode = 27, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 92, .scancode = 43, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 97, .scancode = 30, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 115, .scancode = 31, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 100, .scancode = 32, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 102, .scancode = 33, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 103, .scancode = 34, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 104, .scancode = 35, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 106, .scancode = 36, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 107, .scancode = 37, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 108, .scancode = 38, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 59, .scancode = 39, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 39, .scancode = 40, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 122, .scancode = 44, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 120, .scancode = 45, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 99, .scancode = 46, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 118, .scancode = 47, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 98, .scancode = 48, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 110, .scancode = 49, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 109, .scancode = 50, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 44, .scancode = 51, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 46, .scancode = 52, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 47, .scancode = 53, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 126, .scancode = 41, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 33, .scancode = 2, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 64, .scancode = 3, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 35, .scancode = 4, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 36, .scancode = 5, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 37, .scancode = 6, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 94, .scancode = 7, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 38, .scancode = 8, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 42, .scancode = 9, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 40, .scancode = 10, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 41, .scancode = 11, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 95, .scancode = 12, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 43, .scancode = 13, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 81, .scancode = 16, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 87, .scancode = 17, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 69, .scancode = 18, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 82, .scancode = 19, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 84, .scancode = 20, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 89, .scancode = 21, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 85, .scancode = 22, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 73, .scancode = 23, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 79, .scancode = 24, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 80, .scancode = 25, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 123, .scancode = 26, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 125, .scancode = 27, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 124, .scancode = 43, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 65, .scancode = 30, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 83, .scancode = 31, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 68, .scancode = 32, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 70, .scancode = 33, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 71, .scancode = 34, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 72, .scancode = 35, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 74, .scancode = 36, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 75, .scancode = 37, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 76, .scancode = 38, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 58, .scancode = 39, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 34, .scancode = 40, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 90, .scancode = 44, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 88, .scancode = 45, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 67, .scancode = 46, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 86, .scancode = 47, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 66, .scancode = 48, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 78, .scancode = 49, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 77, .scancode = 50, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 60, .scancode = 51, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 62, .scancode = 52, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    { .keysym = 63, .scancode = 53, .set_keysyms = GUAC_KEYSYMS_SHIFT },
    {0}
};

static const guac_rdp_keymap guac_rdp_keymap_en_us_qwerty = { 
    .name = "en-us-qwerty",
    .parent = &guac_rdp_keymap_base,
    .freerdp_keyboard_layout = KBD_US,
    .mapping = __guac_rdp_keymap_en_us_qwerty
};

/* Autogenerated from keymaps/fr_fr_azerty.keymap */
static guac_rdp_keysym_desc __guac_rdp_keymap_fr_fr_azerty[] = {
    { .keysym = 178, .scancode = 41, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 38, .scancode = 2, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 233, .scancode = 3, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 34, .scancode = 4, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 39, .scancode = 5, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 40, .scancode = 6, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 45, .scancode = 7, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 232, .scancode = 8, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 95, .scancode = 9, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 231, .scancode = 10, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 224, .scancode = 11, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 41, .scancode = 12, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 61, .scancode = 13, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 97, .scancode = 16, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 122, .scancode = 17, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 101, .scancode = 18, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 114, .scancode = 19, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 116, .scancode = 20, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 121, .scancode = 21, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 117, .scancode = 22, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 105, .scancode = 23, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 111, .scancode = 24, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 112, .scancode = 25, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 36, .scancode = 27, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 113, .scancode = 30, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 115, .scancode = 31, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 100, .scancode = 32, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 102, .scancode = 33, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 103, .scancode = 34, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 104, .scancode = 35, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 106, .scancode = 36, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 107, .scancode = 37, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 108, .scancode = 38, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 109, .scancode = 39, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 249, .scancode = 40, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 42, .scancode = 43, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 60, .scancode = 86, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 119, .scancode = 44, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 120, .scancode = 45, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 99, .scancode = 46, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 118, .scancode = 47, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 98, .scancode = 48, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 110, .scancode = 49, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 44, .scancode = 50, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 59, .scancode = 51, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 58, .scancode = 52, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 33, .scancode = 53, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 49, .scancode = 2, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 50, .scancode = 3, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 51, .scancode = 4, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 52, .scancode = 5, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 53, .scancode = 6, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 54, .scancode = 7, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 55, .scancode = 8, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 56, .scancode = 9, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 57, .scancode = 10, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 48, .scancode = 11, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 176, .scancode = 12, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 43, .scancode = 13, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 65, .scancode = 16, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 90, .scancode = 17, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 69, .scancode = 18, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 82, .scancode = 19, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 84, .scancode = 20, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 89, .scancode = 21, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 85, .scancode = 22, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 73, .scancode = 23, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 79, .scancode = 24, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 80, .scancode = 25, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 163, .scancode = 27, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 81, .scancode = 30, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 83, .scancode = 31, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 68, .scancode = 32, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 70, .scancode = 33, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 71, .scancode = 34, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 72, .scancode = 35, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 74, .scancode = 36, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 75, .scancode = 37, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 76, .scancode = 38, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 77, .scancode = 39, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 37, .scancode = 40, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 181, .scancode = 43, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 62, .scancode = 86, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 87, .scancode = 44, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 88, .scancode = 45, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 67, .scancode = 46, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 86, .scancode = 47, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 66, .scancode = 48, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 78, .scancode = 49, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 63, .scancode = 50, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 46, .scancode = 51, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 47, .scancode = 52, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 167, .scancode = 53, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 126, .scancode = 3, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 35, .scancode = 4, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 123, .scancode = 5, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 91, .scancode = 6, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 124, .scancode = 7, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 96, .scancode = 8, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 92, .scancode = 9, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 94, .scancode = 10, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 64, .scancode = 11, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 93, .scancode = 12, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 125, .scancode = 13, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 16785580, .scancode = 18, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 164, .scancode = 27, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 65106, .scancode = 26, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 65111, .scancode = 26, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    {0}
};

static const guac_rdp_keymap guac_rdp_keymap_fr_fr_azerty = { 
    .name = "fr-fr-azerty",
    .parent = &guac_rdp_keymap_base,
    .freerdp_keyboard_layout = KBD_FRENCH,
    .mapping = __guac_rdp_keymap_fr_fr_azerty
};

/* Autogenerated from keymaps/it_it_qwerty.keymap */
static guac_rdp_keysym_desc __guac_rdp_keymap_it_it_qwerty[] = {
    { .keysym = 92, .scancode = 41, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 49, .scancode = 2, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 50, .scancode = 3, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 51, .scancode = 4, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 52, .scancode = 5, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 53, .scancode = 6, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 54, .scancode = 7, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 55, .scancode = 8, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 56, .scancode = 9, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 57, .scancode = 10, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 48, .scancode = 11, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 39, .scancode = 12, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 236, .scancode = 13, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 113, .scancode = 16, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 119, .scancode = 17, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 101, .scancode = 18, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 114, .scancode = 19, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 116, .scancode = 20, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 121, .scancode = 21, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 117, .scancode = 22, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 105, .scancode = 23, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 111, .scancode = 24, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 112, .scancode = 25, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 232, .scancode = 26, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 43, .scancode = 27, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 97, .scancode = 30, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 115, .scancode = 31, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 100, .scancode = 32, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 102, .scancode = 33, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 103, .scancode = 34, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 104, .scancode = 35, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 106, .scancode = 36, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 107, .scancode = 37, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 108, .scancode = 38, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 242, .scancode = 39, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 224, .scancode = 40, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 249, .scancode = 43, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 60, .scancode = 86, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 122, .scancode = 44, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 120, .scancode = 45, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 99, .scancode = 46, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 118, .scancode = 47, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 98, .scancode = 48, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 110, .scancode = 49, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 109, .scancode = 50, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 44, .scancode = 51, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 46, .scancode = 52, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 45, .scancode = 53, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 124, .scancode = 41, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 33, .scancode = 2, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 34, .scancode = 3, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 163, .scancode = 4, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 36, .scancode = 5, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 37, .scancode = 6, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 38, .scancode = 7, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 47, .scancode = 8, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 40, .scancode = 9, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 41, .scancode = 10, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 61, .scancode = 11, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 63, .scancode = 12, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 94, .scancode = 13, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 81, .scancode = 16, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 87, .scancode = 17, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 69, .scancode = 18, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 82, .scancode = 19, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 84, .scancode = 20, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 89, .scancode = 21, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 85, .scancode = 22, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 73, .scancode = 23, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 79, .scancode = 24, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 80, .scancode = 25, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 233, .scancode = 26, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 42, .scancode = 27, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 65, .scancode = 30, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 83, .scancode = 31, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 68, .scancode = 32, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 70, .scancode = 33, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 71, .scancode = 34, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 72, .scancode = 35, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 74, .scancode = 36, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 75, .scancode = 37, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 76, .scancode = 38, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 231, .scancode = 39, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 176, .scancode = 40, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 167, .scancode = 43, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 62, .scancode = 86, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 90, .scancode = 44, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 88, .scancode = 45, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 67, .scancode = 46, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 86, .scancode = 47, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 66, .scancode = 48, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 78, .scancode = 49, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 77, .scancode = 50, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 59, .scancode = 51, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 58, .scancode = 52, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 95, .scancode = 53, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 16785580, .scancode = 18, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 91, .scancode = 26, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 93, .scancode = 27, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 64, .scancode = 39, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 35, .scancode = 40, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 123, .scancode = 26, .set_keysyms = GUAC_KEYSYMS_SHIFT_ALTGR },
    { .keysym = 125, .scancode = 27, .set_keysyms = GUAC_KEYSYMS_SHIFT_ALTGR },
    {0}
};

static const guac_rdp_keymap guac_rdp_keymap_it_it_qwerty = { 
    .name = "it-it-qwerty",
    .parent = &guac_rdp_keymap_base,
    .freerdp_keyboard_layout = KBD_ITALIAN,
    .mapping = __guac_rdp_keymap_it_it_qwerty
};

/* Autogenerated from keymaps/sv_se_qwerty.keymap */
static guac_rdp_keysym_desc __guac_rdp_keymap_sv_se_qwerty[] = {
    { .keysym = 167, .scancode = 41, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 49, .scancode = 2, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 50, .scancode = 3, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 51, .scancode = 4, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 52, .scancode = 5, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 53, .scancode = 6, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 54, .scancode = 7, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 55, .scancode = 8, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 56, .scancode = 9, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 57, .scancode = 10, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 48, .scancode = 11, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 43, .scancode = 12, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 113, .scancode = 16, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 119, .scancode = 17, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 101, .scancode = 18, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 114, .scancode = 19, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 116, .scancode = 20, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 121, .scancode = 21, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 117, .scancode = 22, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 105, .scancode = 23, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 111, .scancode = 24, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 112, .scancode = 25, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 229, .scancode = 26, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 97, .scancode = 30, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 115, .scancode = 31, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 100, .scancode = 32, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 102, .scancode = 33, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 103, .scancode = 34, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 104, .scancode = 35, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 106, .scancode = 36, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 107, .scancode = 37, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 108, .scancode = 38, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 246, .scancode = 39, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 228, .scancode = 40, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 39, .scancode = 43, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 60, .scancode = 86, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 122, .scancode = 44, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 120, .scancode = 45, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 99, .scancode = 46, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 118, .scancode = 47, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 98, .scancode = 48, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 110, .scancode = 49, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 109, .scancode = 50, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 44, .scancode = 51, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 46, .scancode = 52, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 45, .scancode = 53, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 189, .scancode = 41, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 33, .scancode = 2, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 34, .scancode = 3, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 35, .scancode = 4, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 164, .scancode = 5, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 37, .scancode = 6, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 38, .scancode = 7, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 47, .scancode = 8, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 40, .scancode = 9, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 41, .scancode = 10, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 61, .scancode = 11, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 63, .scancode = 12, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 81, .scancode = 16, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 87, .scancode = 17, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 69, .scancode = 18, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 82, .scancode = 19, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 84, .scancode = 20, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 89, .scancode = 21, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 85, .scancode = 22, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 73, .scancode = 23, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 79, .scancode = 24, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 80, .scancode = 25, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 197, .scancode = 26, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 65, .scancode = 30, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 83, .scancode = 31, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 68, .scancode = 32, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 70, .scancode = 33, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 71, .scancode = 34, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 72, .scancode = 35, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 74, .scancode = 36, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 75, .scancode = 37, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 76, .scancode = 38, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 214, .scancode = 39, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 196, .scancode = 40, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 42, .scancode = 43, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 62, .scancode = 86, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 90, .scancode = 44, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 88, .scancode = 45, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 67, .scancode = 46, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 86, .scancode = 47, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 66, .scancode = 48, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 78, .scancode = 49, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 77, .scancode = 50, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 59, .scancode = 51, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 58, .scancode = 52, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 95, .scancode = 53, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 64, .scancode = 3, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 163, .scancode = 4, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 36, .scancode = 5, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 123, .scancode = 8, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 91, .scancode = 9, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 93, .scancode = 10, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 125, .scancode = 11, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 92, .scancode = 12, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 16785580, .scancode = 18, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 124, .scancode = 86, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 181, .scancode = 50, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    { .keysym = 65105, .scancode = 13, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 65104, .scancode = 13, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 65111, .scancode = 27, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT_ALTGR },
    { .keysym = 65106, .scancode = 27, .set_keysyms = GUAC_KEYSYMS_SHIFT, .clear_keysyms = GUAC_KEYSYMS_ALTGR },
    { .keysym = 65107, .scancode = 27, .set_keysyms = GUAC_KEYSYMS_ALTGR, .clear_keysyms = GUAC_KEYSYMS_ALL_SHIFT },
    {0}
};

static const guac_rdp_keymap guac_rdp_keymap_sv_se_qwerty = { 
    .name = "sv-se-qwerty",
    .parent = &guac_rdp_keymap_base,
    .freerdp_keyboard_layout = KBD_SWEDISH,
    .mapping = __guac_rdp_keymap_sv_se_qwerty
};

const guac_rdp_keymap* GUAC_KEYMAPS[] = {
    &guac_rdp_keymap_base,
    &guac_rdp_keymap_failsafe,
    &guac_rdp_keymap_de_de_qwertz,
    &guac_rdp_keymap_en_us_qwerty,
    &guac_rdp_keymap_fr_fr_azerty,
    &guac_rdp_keymap_it_it_qwerty,
    &guac_rdp_keymap_sv_se_qwerty,
    NULL
};
