function main(args)

_ddir='/d1/obs/fnmoc/dat'
_ldir='/d1/grads/lib'

mod=msu
dmode=subwrd(args,1)
if(dmode='');dmode='y';endif



if(mod=nogaps)


endif

if(mod=msu)

'open /d1/obs/precip/msu/month/v2daily/pr.monmean.msu'


endif


if(mod=nmc)

'open /d1/obs/reanal/nmc/output/grib/flux.ctl'
'set time dec91'
'd tas'
return
endif

if(mod=ng)
'open '_ddir'/nogaps.25.95022100'
'open '_ddir'/nogaps.25.95022112'
*
*	set lat lon bounds
*
*	NOTE: the underscore denotes "global" script variables 
*	which do not have
*	to be passed to calling functions
*
_lat1=0
_lat2=60

_lon1=-140
_lon2=-40

'set lat '_lat1' '_lat2
'set lon '_lon1' '_lon2
'set lev 500'

'define psl=slp/100'

'set gxout stat'
'd psl'

say result

'set gxout shaded'
'd psl'
'run cbarn'

return

*'d grhilo(slp/100)'
'run /home1/grads/lib/cbarn.gs'
'q pos'
'c'
'd z'
'run /home1/grads/lib/cbarn'

'q pos'
'c'
'd z'
'run cbarn'

'set gxout stat'
'd z'
say result

return
endif

return








if(mod=gms)
'open  /home1/grads/gms/gms.ctl'
'set time 12z10nov1992'
'd tb'
endif



if(mod=ng2)
'open '_ddir'/nogaps.25.95021812.ctl'
'set t 1'
'set lev 500'
'd z'
rc=pdim()

'set rgb 90 100 100 100'
'set rgb 91  50  50  50'
'set rgb 92 200 200 200'
'set button 1 90 91 92 0 90 91 92 6'



'set rband 20 box '_xlplot' '_ybplot' '_xrplot' '_ytplot

'c'
if(dmode='y') ; 'set dbuff on' ; endif

while(1)

'd z(t=1)'
'set rband 20 box '_xlplot' '_ybplot' '_xrplot' '_ytplot
'draw button 1 1 0.5 1 0.5 test'
if(dmode=y) ; 'swap' ; endif
'set rband 20 box '_xlplot' '_ybplot' '_xrplot' '_ytplot
'set button 1 90 91 92 0 90 91 92 6'
'draw button 1 1 0.5 1 0.5 test'
'q pos'
say '1 'result
if(dmode!='y') ; 'c' ; endif

'd z(t=2)'
'draw button 1 1 0.5 1 0.5 test'
'set rband 20 box '_xlplot' '_ybplot' '_xrplot' '_ytplot
if(dmode=y) ; 'swap' ; endif
'set rband 20 box '_xlplot' '_ybplot' '_xrplot' '_ytplot
'set button 1 90 91 92 0 90 91 92 6'
'draw button 1 1 0.5 1 0.5 test'
'q pos'
say '2 'result
if(dmode!='y') ; 'c' ; endif

endwhile

return
endif


if(mod=ng)
'open '_ddir'/nogaps.25.95022100'
'open '_ddir'/nogaps.25.95022112'
*
*	set lat lon bounds
*
*	NOTE: the underscore denotes "global" script variables 
*	which do not have
*	to be passed to calling functions
*
_lat1=0
_lat2=60

_lon1=-140
_lon2=-40

'set lat '_lat1' '_lat2
'set lon '_lon1' '_lon2
'set lev 500'

'define psl=slp/100'

'set gxout stat'
'd psl'

say result

'set gxout shaded'
'd psl'
'run cbarn'

return

*'d grhilo(slp/100)'
'run /home1/grads/lib/cbarn.gs'
'q pos'
'c'
'd z'
'run /home1/grads/lib/cbarn'

'q pos'
'c'
'd z'
'run cbarn'

'set gxout stat'
'd z'
say result

return
endif

return

function pdim


  'q gxinfo'
  card=sublin(result,2)
  _pagex=subwrd(card,4)
  _pagey=subwrd(card,6)

  card=sublin(result,3)
  _xlplot=subwrd(card,4)
  _xrplot=subwrd(card,6)

  card=sublin(result,4)
  _ybplot=subwrd(card,4)
  _ytplot=subwrd(card,6)


return


*
*	set lat lon bounds
*
*	NOTE: the underscore denotes "global" script variables 
*	which do not have
*	to be passed to calling functions
*
_lat1=0
_lat2=60

_lon1=100
_lon2=180
*
*	set the dimension environment to 2-D lon,lat
*
'set lat '_lat1' '_lat2
'set lon '_lon1' '_lon2
'set lev 500'
'set t 1'
*
*	define script variables consisting of a string containing 
*	the GrADS "expression" (a grid)
*
*	in this case, compare the u comp at 850 with u at 200 mb
*
x1='u(lev=850)'
x2='u(lev=200)'
*
*	now try u at 500 between t=1 (analysis) and t=2 12 h forecast
*
*x1='u(t=1)'
*x2='u(t=2)'
*
*	calculate the unweighted and weighted corr coefficients
*
rhou=corru(x1,x2)
rhow=corrw(x1,x2)
*
*	contour plot of the fields; use q pos to continue after clicking
*	on the screen
*
'c'
'set gxout contour'
'set ccolor rainbow'
'set cint 5'
'd 'x1
'draw title field #1'
'q pos'
*
*	overlay second field
*
'set ccolor 1'
'set cint 5'
'd 'x2
'draw title field #2'
'q pos'
*
*	clear and look at a scatter plot
*
'c'
'set gxout scatter'
'd 'x1';'x2
*
*	put the coef in the scatter plot title, note the fancy use
*	of fonts and subscripts...
*
'draw title `3r`0`barea weighted`n = 'rhow' `3r`0`bunweighted`n = 'rhou  

return

function corrw(x1,x2)
*
*	calc correlation coefficient for 2-D horizontal fields using aave
*
*	for non horizontal fields use ave(ave...)
*
*	ASSUMES THE GRIDS HAVE THE SAME NUMBER OF DEFINED POINTS!!!!
*
*	based on formula on p.92 of Panofsky and Brier, 1968 "Some applications of
*	statistics to meteorology." Penn State Press
*
*
*	set dimension environment to 0-D (a point), as a consequence
*	all calcs are written to the string variable result
*
*'set x 1'
*'set y 1'
*
*	display (calc) the ave of field #1
*

'd aave('x1',lon='_lon1',lon='_lon2',lat='_lat1',lat='_lat2')'
ave1=subwrd(result,4)
*
*	field #2
*
'd aave('x2',lon='_lon1',lon='_lon2',lat='_lat1',lat='_lat2')'
ave2=subwrd(result,4)
*
*	cross product #1 * #2
*
'd aave('x1'*'x2',lon='_lon1',lon='_lon2',lat='_lat1',lat='_lat2')'
ave12=subwrd(result,4)
*
*	ave of the sqr  #1
*
'd aave('x1'*'x1',lon='_lon1',lon='_lon2',lat='_lat1',lat='_lat2')'
ave1s=subwrd(result,4)
*
*	ave of sqr of #2
'd aave('x2'*'x2',lon='_lon1',lon='_lon2',lat='_lat1',lat='_lat2')'
ave2s=subwrd(result,4)
*
*	the first part of the denominator
*
'd sqrt('ave1s'-'ave1'*'ave1')'
den1=subwrd(result,4)
*
*	the second part
*
'd sqrt('ave2s'-'ave2'*'ave2')'
den2=subwrd(result,4)
*
*	the numerator
*
'd 'ave12'-'ave1'*'ave2
num=subwrd(result,4)
*
*	the coefficient
*
'd 'num'/('den1'*'den2')'
corr=subwrd(result,4)
*
*	output to the terminal
*
say ' The area weighted correlation = 'corr
*
*	return the string to the main program
*
return(corr)


function corru(x1,x2)
*
*	use the new version of gxout stat to get the # of valid points 
*	(for info purposes only)
*	and the biased (/N) vice the unbiased (/(N-1)) averages
*
*	ASSUMES THE GRIDS HAVE THE SAME NUMBER OF DEFINED POINTS!!!!
*
*	imax is the number of lines produced by gxout stat so the loop
*	doesn't go forever...
*
*	based on formula on p.92 of Panofsky and Brier, 1968 "Some applications of
*	statistics to meteorology." Penn State Press
*

imax=12
'set gxout stat'
'd 'x1
result1=result
'd 'x2
result2=result
'd 'x1'*'x2
result3=result
*
*	parse the strings for the info
*
i=1
while(i<=imax)

  card1=sublin(result1,i)
  card2=sublin(result2,i)
  card3=sublin(result3,i)

*
*	get number of defined points
*

  if(subwrd(card1,2)='count')
    npt=subwrd(card1,8)
  endif
*
*	the sum and sumsqr are on the Min, Max line...
*

  if(subwrd(card1,1)='Stats:')
*
*	for demonstration purposes, parse out all the good stuff
*
    sum1=subwrd(card1,2)
    sumsq1=subwrd(card1,3)
    ave1b=subwrd(card1,4)
    avesq1b=subwrd(card1,5)
    ave1u=subwrd(card1,6)
    avesq1u=subwrd(card1,7)

    ave2b=subwrd(card2,4)
    avesq2b=subwrd(card2,5)

    ave12b=subwrd(card3,4)
    avesq12b=subwrd(card3,5)
*
*	break the loop now that we have what we need
*
    break
  endif
  i=i+1
endwhile
*
*	turn off stat output and do the calculation using display
*
*	the result goes to the script variable result
*
'set gxout contour'
'd 'ave12b'-'ave1b'*'ave2b
num=subwrd(result,4)
'd sqrt('avesq1b'-'ave1b'*'ave1b')'
den1=subwrd(result,4)
'd sqrt('avesq2b'-'ave2b'*'ave2b')'
den2=subwrd(result,4)

'd 'num'/('den1'*'den2')'
corr=subwrd(result,4)

say ' The UNWEIGHTED correlation = 'corr
*
*	return to main program
*
return(corr)

