.\" @(#)$RCSfile: gfal_get_timeout_bdii.man,v $ $Revision: 1.1 $ $Date: 2008/12/18 13:19:12 $ CERN Remi Mollon
.\" Copyright (C) 2009 by CERN
.\" All rights reserved
.\"
.TH GFAL_GET_TIMEOUT_* 3 "$Date: 2008/12/18 13:19:12 $" GFAL "Library Functions"

.SH NAME
gfal_get_timeout_* \- Get several timeouts

.SH SYNOPSIS
\fB#include "gfal_api.h"\fR
.sp
.B int gfal_get_timeout_connect ( );
.sp
.B int gfal_get_timeout_sendreceive ( );
.sp
.B int gfal_get_timeout_bdii ( );
.sp
.B int gfal_get_timeout_srm ( );

.SH DESCRIPTION
.B gfal_get_timeout_connect
Gets the connect timeout, used when connecting to a remote host.
.sp
.B gfal_get_timeout_sendreceive
Gets the send/receive data timeout, used when transferring data to/from a remote host.
.sp
.B gfal_get_timeout_bdii
Gets the BDII timeout, used when searching information into BDII.
.sp
.B gfal_get_timeout_srm
Gets the SRM timeout, used when doing an asynchronous SRM request.

.SH RETURN VALUE
This routine returns the value of the corresponding timeout. If the value hasn't been
changed by the user, then the function will return the default value.

.SH SEE ALSO
.BR gfal (3),
.BR gfal_request_new (3),
.BR gfal_internal_free (3),
.BR gfal_init (3),
.BR gfal_deletesurls (3),
.BR gfal_removedir (3),
.BR gfal_turlsfromsurls (3),
.BR gfal_ls (3),
.BR gfal_get (3),
.BR gfal_getstatus (3),
.BR gfal_prestage (3),
.BR gfal_prestagestatus (3),
.BR gfal_pin (3),
.BR gfal_release (3),
.BR gfal_abortrequest (3),
.BR gfal_abortfiles (3),
.BR gfal_set_xfer_done (3),
.BR gfal_set_xfer_running (3),
.BR gfal_get_ids (3),
.BR gfal_set_ids (3),
.BR gfal_get_results (3),
