/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.jni;

import geotrans3.coordinates.Accuracy;
import geotrans3.coordinates.ConvertResults;
import geotrans3.coordinates.CoordinateTuple;
import geotrans3.exception.CoordinateConversionException;
import geotrans3.parameters.CoordinateSystemParameters;
import java.util.Collection;

public class JNICoordinateConversionService {
    private long coordinateConversionServicePtr;

    private native long jniCreate(String var1, CoordinateSystemParameters var2, String var3, CoordinateSystemParameters var4) throws CoordinateConversionException;

    private native void jniDestroy(long var1);

    private native ConvertResults jniConvertSourceToTarget(long var1, CoordinateTuple var3, Accuracy var4, CoordinateTuple var5, Accuracy var6) throws CoordinateConversionException;

    private native ConvertResults jniConvertTargetToSource(long var1, CoordinateTuple var3, Accuracy var4, CoordinateTuple var5, Accuracy var6) throws CoordinateConversionException;

    private native void jniConvertSourceToTargetCollection(long var1, Collection var3, Collection var4, Collection var5, Collection var6) throws CoordinateConversionException;

    private native void jniConvertTargetToSourceCollection(long var1, Collection var3, Collection var4, Collection var5, Collection var6) throws CoordinateConversionException;

    private native long jniGetDatumLibrary(long var1);

    private native long jniGetEllipsoidLibrary(long var1);

    private native double jniGetServiceVersion(long var1);

    private native String jniGetDatum(long var1, int var3) throws CoordinateConversionException;

    private native CoordinateSystemParameters jniGetCoordinateSystem(long var1, int var3) throws CoordinateConversionException;

    public JNICoordinateConversionService(String string, CoordinateSystemParameters coordinateSystemParameters, String string2, CoordinateSystemParameters coordinateSystemParameters2) throws Exception {
        try {
            this.coordinateConversionServicePtr = this.jniCreate(string, coordinateSystemParameters, string2, coordinateSystemParameters2);
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
    }

    public synchronized void destroy() {
        if (this.coordinateConversionServicePtr != 0L) {
            this.jniDestroy(this.coordinateConversionServicePtr);
            this.coordinateConversionServicePtr = 0L;
        }
    }

    public synchronized long getCoordinateConversionServicePtr() {
        return this.coordinateConversionServicePtr;
    }

    public synchronized long getDatumLibrary() throws CoordinateConversionException {
        if (this.coordinateConversionServicePtr == 0L) {
            throw new CoordinateConversionException("getDatumLibrary called with null object");
        }
        return this.jniGetDatumLibrary(this.coordinateConversionServicePtr);
    }

    public synchronized long getEllipsoidLibrary() throws CoordinateConversionException {
        if (this.coordinateConversionServicePtr == 0L) {
            throw new CoordinateConversionException("getEllipsoidLibrary called with null object");
        }
        return this.jniGetEllipsoidLibrary(this.coordinateConversionServicePtr);
    }

    public synchronized String getDatum(int n) throws CoordinateConversionException {
        if (this.coordinateConversionServicePtr == 0L) {
            throw new CoordinateConversionException("getDatum called with null object");
        }
        return this.jniGetDatum(this.coordinateConversionServicePtr, n);
    }

    public synchronized CoordinateSystemParameters getCoordinateSystem(int n) throws CoordinateConversionException {
        if (this.coordinateConversionServicePtr == 0L) {
            throw new CoordinateConversionException("getCoordinateSystem called with null object");
        }
        return this.jniGetCoordinateSystem(this.coordinateConversionServicePtr, n);
    }

    public synchronized ConvertResults convertSourceToTarget(CoordinateTuple coordinateTuple, Accuracy accuracy, CoordinateTuple coordinateTuple2, Accuracy accuracy2) throws CoordinateConversionException {
        if (this.coordinateConversionServicePtr == 0L) {
            throw new CoordinateConversionException("convertSourceToTarget called with null object");
        }
        return this.jniConvertSourceToTarget(this.coordinateConversionServicePtr, coordinateTuple, accuracy, coordinateTuple2, accuracy2);
    }

    public synchronized ConvertResults convertTargetToSource(CoordinateTuple coordinateTuple, Accuracy accuracy, CoordinateTuple coordinateTuple2, Accuracy accuracy2) throws CoordinateConversionException {
        if (this.coordinateConversionServicePtr == 0L) {
            throw new CoordinateConversionException("convertTargetToSource called with null object");
        }
        return this.jniConvertTargetToSource(this.coordinateConversionServicePtr, coordinateTuple, accuracy, coordinateTuple2, accuracy2);
    }

    public synchronized double getServiceVersion() throws CoordinateConversionException {
        if (this.coordinateConversionServicePtr == 0L) {
            throw new CoordinateConversionException("getServiceVersion called with null object");
        }
        return this.jniGetServiceVersion(this.coordinateConversionServicePtr);
    }
}

