*
* $Id: casl0.F,v 1.1.1.1 1995/10/24 10:21:02 cernlib Exp $
*
* $Log: casl0.F,v $
* Revision 1.1.1.1  1995/10/24 10:21:02  cernlib
* Geant
*
*
#include "geant321/pilot.h"
*CMZ :  3.21/02 29/03/94  15.41.39  by  S.Giani
*-- Author :
      SUBROUTINE CASL0(K,INT,NFL)
C
C *** CASCADE OF LAMBDA ***
C *** NVE 04-MAY-1988 CERN GENEVA ***
C
C ORIGIN : H.FESEFELDT (13-SEP-1987)
C
C L0  UNDERGOES INTERACTION WITH NUCLEON WITHIN NUCLEUS.
C CHECK IF ENERGETICALLY POSSIBLE TO PRODUCE PIONS/KAONS.
C IF NOT ASSUME NUCLEAR EXCITATION OCCURS AND INPUT PARTICLE
C IS DEGRADED IN ENERGY.    NO OTHER PARTICLES PRODUCED.
C IF REACTION IS POSSIBLE FIND CORRECT NUMBER OF PIONS/PROTONS/
C NEUTRONS PRODUCED USING AN INTERPOLATION TO MULTIPLICITY DATA.
C REPLACE SOME PIONS OR PROTONS/NEUTRONS BY KAONS OR STRANGE BARYONS
C ACCORDING TO AVERAGE MULTIPLICITY PER INELASTIC REACTIONS.
C
#include "geant321/mxgkgh.inc"
#include "geant321/s_consts.inc"
#include "geant321/s_curpar.inc"
#include "geant321/s_result.inc"
#include "geant321/s_prntfl.inc"
#include "geant321/s_kginit.inc"
#include "geant321/limits.inc"
C
      REAL N
      DIMENSION PMUL(2,1200),ANORM(2,60),CECH(10),IIPA(10,2),B(2)
      DIMENSION RNDM(2)
      SAVE PMUL,ANORM
      DATA CECH/0.50,0.45,0.40,0.35,0.30,0.25,0.06,0.04,0.005,0./
      DATA IIPA/20,21,14,14,16,21,22,16,16,14,
     *          16,14,18,21,20,16,14,18,21,22/
      DATA B/0.7,0.7/,C/1.25/
C
C --- INITIALIZATION INDICATED BY KGINIT(8) ---
      IF (KGINIT(8) .NE. 0) GO TO 10
      KGINIT(8)=1
C
C --- INITIALIZE PMUL AND ANORM ARRAYS ---
      DO 9000 J=1,1200
      DO 9001 I=1,2
      PMUL(I,J)=0.0
      IF (J .LE. 60) ANORM(I,J)=0.0
 9001 CONTINUE
 9000 CONTINUE
C
C** COMPUTE NORMALIZATION CONSTANTS
C** FOR N AS TARGET
C
      L=0
      DO 1 NP1=1,20
      NP=NP1-1
      NMM1=NP1-1
      IF(NMM1.LE.0) NMM1=1
      NPP1=NP1+2
      DO 1 NM1=NMM1,NPP1
      NM=NM1-1
      DO 1 NZ1=1,20
      NZ=NZ1-1
      L=L+1
      IF(L.GT.1200) GOTO 1
      NT=NP+NM+NZ
      IF(NT.LE.0.OR.NT.GT.60) GOTO 1
      PMUL(1,L)=PMLTPC(NP,NM,NZ,NT,B(2),C)
      ANORM(1,NT)=ANORM(1,NT)+PMUL(1,L)
    1 CONTINUE
C** FOR P AS TARGET
      L=0
      DO 2 NP1=1,20
      NP=NP1-1
      NMM1=NP1-2
      IF(NMM1.LE.1) NMM1=1
      NPP1=NP1+1
      DO 2 NM1=NMM1,NPP1
      NM=NM1-1
      DO 2 NZ1=1,20
      NZ=NZ1-1
      L=L+1
      IF(L.GT.1200) GOTO 2
      NT=NP+NM+NZ
      IF(NT.LE.0.OR.NT.GT.60) GOTO 2
      PMUL(2,L)=PMLTPC(NP,NM,NZ,NT,B(1),C)
      ANORM(2,NT)=ANORM(2,NT)+PMUL(2,L)
    2 CONTINUE
      DO 3 I=1,60
      IF(ANORM(1,I).GT.0.) ANORM(1,I)=1./ANORM(1,I)
      IF(ANORM(2,I).GT.0.) ANORM(2,I)=1./ANORM(2,I)
    3 CONTINUE
      IF(.NOT.NPRT(10)) GOTO 10
      WRITE(NEWBCD,2001)
      DO 4 NFL=1,2
      WRITE(NEWBCD,2002) NFL
      WRITE(NEWBCD,2003) (ANORM(NFL,I),I=1,60)
      WRITE(NEWBCD,2003) (PMUL(NFL,I),I=1,1200)
    4 CONTINUE
C**  CHOOSE PROTON OR NEUTRON AS TARGET
   10 NFL=2
      CALL GRNDM(RNDM,1)
      IF(RNDM(1).LT.ZNO2/ATNO2) NFL=1
      TARMAS=RMASS(14)
      IF (NFL .EQ. 2) TARMAS=RMASS(16)
      S=AMASQ+TARMAS**2+2.0*TARMAS*EN
      RS=SQRT(S)
      ENP(8)=AMASQ+TARMAS**2+2.0*TARMAS*ENP(6)
      ENP(9)=SQRT(ENP(8))
      EAB=RS-TARMAS-RMASS(18)
C**  ELASTIC SCATTERING
      NP=0
      NM=0
      NZ=0
      N=0.
      IPA(1)=18
      IPA(2)=14
      IF(NFL.EQ.2) IPA(2)=16
      IF(INT.EQ.2) GOTO 20
C** INTRODUCE CHARGE AND STRANGENESS EXCHANGE REACTIONS
C** LP --> S+N, LP --> S0 P , LN --> S0 N , LN --> S- P
C** LP --> P L, LP --> P S0 , LP --> N S+
C** LN --> N L, LN --> N S0 , LN --> P S-
      IPLAB=IFIX(P*2.5)+1
      IF(IPLAB.GT.10) IPLAB=10
      CALL GRNDM(RNDM,1)
      IF(RNDM(1).GT.CECH(IPLAB)/ATNO2**0.42) GOTO 120
      CALL GRNDM(RNDM,1)
      RAN=RNDM(1)
      IRN=IFIX(RAN/0.2)+1
      IF(IRN.GT.5) IRN=5
      IRN=IRN+(NFL-1)*5
      IPA(1)=IIPA(IRN,1)
      IPA(2)=IIPA(IRN,2)
      GOTO 120
C**  CHECK IF ENERGETICALLY POSSIBLE TO PRODUCE ONE EXTRA PION IN REACT.
  20  IF (EAB .LE. RMASS(7)) GOTO 55
      ALEAB=LOG(EAB)
C** NO. OF TOTAL PARTICLES VS SQRT(S)-MP-MSM
      N=3.62567+0.665843*ALEAB+0.336514*ALEAB*ALEAB
     * +0.117712*ALEAB*ALEAB*ALEAB+0.0136912*ALEAB*ALEAB*ALEAB*ALEAB
      N=N-2.
C** NORMALIZATION CONSTANT FOR  KNO-DISTRIBUTION
      ANPN=0.
      DO 21 NT=1,60
      TEST=-(PI/4.0)*(NT/N)**2
      IF (TEST .LT. EXPXL) TEST=EXPXL
      IF (TEST .GT. EXPXU) TEST=EXPXU
      DUM1=PI*NT/(2.0*N*N)
      DUM2=ABS(DUM1)
      DUM3=EXP(TEST)
      ADDNVE=0.0
      IF (DUM2 .GE. 1.0) ADDNVE=DUM1*DUM3
      IF ((DUM2 .LT. 1.0) .AND. (DUM3 .GE. 1.0E-10)) ADDNVE=DUM1*DUM3
      ANPN=ANPN+ADDNVE
   21 CONTINUE
      ANPN=1./ANPN
C** P OR N AS TARGET
      CALL GRNDM(RNDM,1)
      RAN=RNDM(1)
      EXCS=0.
      GOTO (40,30),NFL
C** FOR N AS TARGET
   30 L=0
      DO 31 NP1=1,20
      NP=NP1-1
      NMM1=NP1-1
      IF(NMM1.LE.0) NMM1=1
      NPP1=NP1+2
      DO 31 NM1=NMM1,NPP1
      NM=NM1-1
      DO 31 NZ1=1,20
      NZ=NZ1-1
      L=L+1
      IF(L.GT.1200) GOTO 31
      NT=NP+NM+NZ
      IF(NT.LE.0.OR.NT.GT.60) GOTO 31
      TEST=-(PI/4.0)*(NT/N)**2
      IF (TEST .LT. EXPXL) TEST=EXPXL
      IF (TEST .GT. EXPXU) TEST=EXPXU
      DUM1=ANPN*PI*NT*PMUL(1,L)*ANORM(1,NT)/(2.0*N*N)
      DUM2=ABS(DUM1)
      DUM3=EXP(TEST)
      ADDNVE=0.0
      IF (DUM2 .GE. 1.0) ADDNVE=DUM1*DUM3
      IF ((DUM2 .LT. 1.0) .AND. (DUM3 .GE. 1.0E-10)) ADDNVE=DUM1*DUM3
      EXCS=EXCS+ADDNVE
      IF(RAN.LT.EXCS) GOTO 100
   31 CONTINUE
      GOTO 80
C** FOR P AS TARGET
   40 L=0
      DO 41 NP1=1,20
      NP=NP1-1
      NMM1=NP1-2
      IF(NMM1.LE.1) NMM1=1
      NPP1=NP1+1
      DO 41 NM1=NMM1,NPP1
      NM=NM1-1
      DO 41 NZ1=1,20
      NZ=NZ1-1
      L=L+1
      IF(L.GT.1200) GOTO 41
      NT=NP+NM+NZ
      IF(NT.LE.0.OR.NT.GT.60) GOTO 41
      TEST=-(PI/4.0)*(NT/N)**2
      IF (TEST .LT. EXPXL) TEST=EXPXL
      IF (TEST .GT. EXPXU) TEST=EXPXU
      DUM1=ANPN*PI*NT*PMUL(2,L)*ANORM(2,NT)/(2.0*N*N)
      DUM2=ABS(DUM1)
      DUM3=EXP(TEST)
      ADDNVE=0.0
      IF (DUM2 .GE. 1.0) ADDNVE=DUM1*DUM3
      IF ((DUM2 .LT. 1.0) .AND. (DUM3 .GE. 1.0E-10)) ADDNVE=DUM1*DUM3
      EXCS=EXCS+ADDNVE
      IF(RAN.LT.EXCS) GOTO 100
   41 CONTINUE
      GOTO 80
   50 IF(NPRT(4))
     *WRITE(NEWBCD,1003) EAB,N,NFL,NP,NM,NZ
      IF(INT.EQ.1) CALL TWOB(18,NFL,N)
      IF(INT.EQ.2) CALL GENXPT(18,NFL,N)
      GO TO 9999
   55 IF(NPRT(4))
     *WRITE(NEWBCD,1001)
      GOTO 53
C** EXCLUSIVE REACTION NOT FOUND
   80 IF(NPRT(4))
     *WRITE(NEWBCD,1004) RS,N
   53 INT=1
      NP=0
      NM=0
      NZ=0
      IPA(1)=18
      IPA(2)=14
      IF(NFL.EQ.2) IPA(2)=16
      GOTO 120
  100 DO 101 I=1,60
  101 IPA(I)=0
      IF(INT.LE.0) GOTO 131
      GOTO (112,102),NFL
  102 NCHT=NP-NM
      NCHT=NCHT+3
      IF(NCHT.LE.0) NCHT=1
      IF(NCHT.GT.4) NCHT=4
      GOTO (103,104,105,106),NCHT
  103 IPA(1)=20
      IPA(2)=14
      GOTO 120
  104 IPA(1)=18
      CALL GRNDM(RNDM,2)
      IF(RNDM(1).LT.0.5) IPA(1)=21
      IPA(2)=14
      IF(RNDM(2).LT.0.5) GOTO 120
      IPA(1)=20
      IPA(2)=16
      GOTO 120
  105 IPA(1)=18
      CALL GRNDM(RNDM,2)
      IF(RNDM(1).LT.0.5) IPA(1)=21
      IPA(2)=16
      IF(RNDM(2).LT.0.5) GOTO 120
      IPA(1)=22
      IPA(2)=14
      GOTO 120
  106 IPA(1)=22
      IPA(2)=16
      GOTO 120
  112 NCHT=NP-NM
      NCHT=NCHT+2
      IF(NCHT.LE.0) NCHT=1
      IF(NCHT.GT.4) NCHT=4
      GOTO (113,114,115,116),NCHT
  113 IPA(1)=20
      IPA(2)=14
      GOTO 120
  114 IPA(1)=18
      CALL GRNDM(RNDM,2)
      IF(RNDM(1).LT.0.5) IPA(1)=21
      IPA(2)=14
      IF(RNDM(2).LT.0.5) GOTO 120
      IPA(1)=20
      IPA(2)=16
      GOTO 120
  115 IPA(1)=18
      CALL GRNDM(RNDM,2)
      IF(RNDM(1).LT.0.5) IPA(1)=21
      IPA(2)=16
      IF(RNDM(2).LT.0.5) GOTO 120
      IPA(1)=22
      IPA(2)=14
      GOTO 120
  116 IPA(1)=22
      IPA(2)=16
  120 NT=2
      IF(NP.EQ.0) GOTO 122
      DO 121 I=1,NP
      NT=NT+1
  121 IPA(NT)=7
  122 IF(NM.EQ.0) GOTO 124
      DO 123 I=1,NM
      NT=NT+1
  123 IPA(NT)=9
  124 IF(NZ.EQ.0) GOTO 130
      DO 125 I=1,NZ
      NT=NT+1
  125 IPA(NT)=8
  130 IF(NPRT(4))
     *WRITE(NEWBCD,2004) NT,(IPA(I),I=1,20)
      GOTO 50
  131 IF(NPRT(4))
     *WRITE(NEWBCD,2005)
C
1001  FORMAT('0*CASL0* CASCADE ENERGETICALLY NOT POSSIBLE',
     $ ' CONTINUE WITH QUASI-ELASTIC SCATTERING')
1003  FORMAT(' *CASL0* LAMBDA-INDUCED CASCADE,',
     $ ' AVAIL. ENERGY',2X,F8.4,
     $ 2X,'<NTOT>',2X,F8.4,2X,'FROM',4(2X,I3),2X,'PARTICLES')
1004  FORMAT(' *CASL0* LAMBDA-INDUCED CASCADE,',
     $ ' EXCLUSIVE REACTION NOT FOUND',
     $ ' TRY ELASTIC SCATTERING  AVAIL. ENERGY',2X,F8.4,2X,
     $ '<NTOT>',2X,F8.4)
2001  FORMAT('0*CASL0* TABLES FOR MULT. DATA LAMBDA INDUCED REACTION',
     $ ' FOR DEFINITION OF NUMBERS SEE FORTRAN CODING')
2002  FORMAT(' *CASL0* TARGET PARTICLE FLAG',2X,I5)
2003  FORMAT(1H ,10E12.4)
2004  FORMAT(' *CASL0* ',I3,2X,'PARTICLES , MASS INDEX ARRAY',2X,20I4)
2005  FORMAT(' *CASL0* NO PARTICLES PRODUCED')
C
 9999 CONTINUE
      END
