/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 1991-2010 OpenCFD Ltd.
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "radiationConstants.H"
#include <OpenFOAM/dimensionedConstants.H>

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

//- Stefan-Boltzmann constant (default in [J/(K4 m2 s)])
const Foam::dimensionedScalar Foam::radiation::sigmaSB
(
    Foam::dimensionedConstant
    (
        "sigmaSB",
        dimensionedScalar
        (
            "sigmaSB",
            dimensionSet(1, 0, -3, -4, 0, 0, 0),
            5.670E-08
        )
    )
);


// ************************ vim: set sw=4 sts=4 et: ************************ //
