// Copyright 2004 "Gilles Degottex"

// This file is part of "fmit"

// "fmit" is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// "fmit" is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "GLSample.h"

static const unsigned char g_icon_sample[] = {
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x73, 0x7a, 0x7a, 0xf4, 0x00, 0x00, 0x05,
    0xf4, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xbd, 0x97, 0x7b, 0x4c, 0x53,
    0x57, 0x1c, 0xc7, 0x3f, 0xf7, 0xb6, 0x45, 0x28, 0x30, 0x9e, 0xad, 0x83,
    0x20, 0x54, 0x59, 0x7c, 0x4d, 0x2a, 0xc4, 0x81, 0x32, 0x61, 0xd9, 0xa6,
    0x53, 0xa7, 0x7f, 0xcc, 0x39, 0x97, 0xa9, 0xd9, 0xe2, 0x96, 0xe8, 0x5e,
    0xd9, 0xcc, 0x92, 0x6d, 0x71, 0x4b, 0x36, 0x71, 0x89, 0x71, 0x5b, 0xf6,
    0x7e, 0xc5, 0x25, 0x2e, 0x3e, 0x92, 0xc5, 0xa9, 0x51, 0x36, 0x63, 0x34,
    0x46, 0x74, 0xce, 0x21, 0x8f, 0x39, 0x03, 0x14, 0xd4, 0x55, 0x44, 0x10,
    0x54, 0x1e, 0xe5, 0xd5, 0x16, 0xda, 0x52, 0x68, 0xef, 0xd9, 0x1f, 0xb7,
    0x76, 0x20, 0x05, 0x04, 0x93, 0x7d, 0x93, 0x9b, 0x7b, 0xee, 0x39, 0xbf,
    0x7b, 0xbe, 0xdf, 0x73, 0xee, 0xef, 0xfc, 0x7e, 0xbf, 0x2b, 0x71, 0xf7,
    0xd0, 0x03, 0xd3, 0x81, 0x24, 0x20, 0x05, 0xf0, 0x02, 0x95, 0x80, 0x15,
    0x18, 0x18, 0xc7, 0x3c, 0x43, 0x20, 0x8d, 0x31, 0x1e, 0x0d, 0x3c, 0x0f,
    0xac, 0x07, 0xa6, 0x00, 0x3a, 0x20, 0x02, 0x88, 0x04, 0x7c, 0x40, 0x77,
    0x80, 0xdc, 0x0d, 0x5c, 0x07, 0x8e, 0x01, 0x3f, 0x06, 0xc4, 0xdd, 0x93,
    0x00, 0x09, 0x78, 0x19, 0xf8, 0x10, 0x48, 0x04, 0x26, 0x85, 0x87, 0x6b,
    0x31, 0x3f, 0x98, 0x48, 0x96, 0xd9, 0x48, 0x96, 0xd9, 0x88, 0xdb, 0xe3,
    0xa3, 0xaa, 0xda, 0x46, 0x85, 0xc5, 0x86, 0xf5, 0x6a, 0x17, 0x3e, 0x9f,
    0x42, 0x80, 0xb8, 0x0d, 0xd8, 0x01, 0x7c, 0x06, 0xf8, 0x27, 0x22, 0x20,
    0x0a, 0x28, 0x02, 0x1e, 0x04, 0xa2, 0x17, 0x2e, 0x48, 0x66, 0xdb, 0x07,
    0x79, 0x64, 0xcc, 0x4e, 0x44, 0xa3, 0x51, 0xcd, 0xbd, 0x52, 0x02, 0x92,
    0x18, 0x20, 0x0c, 0x27, 0x00, 0x7d, 0x7d, 0x3e, 0x8a, 0xcb, 0x6e, 0xb1,
    0xb9, 0xa0, 0x98, 0x86, 0x46, 0x07, 0x80, 0x0b, 0xb8, 0x0c, 0xac, 0x00,
    0xda, 0xc7, 0x23, 0x20, 0x01, 0x38, 0x0b, 0xcc, 0xd0, 0xeb, 0x75, 0xda,
    0x82, 0xcd, 0x0b, 0xd8, 0xb8, 0xde, 0x4c, 0x9f, 0x34, 0x99, 0x4e, 0x39,
    0x07, 0x97, 0x94, 0x8a, 0x4b, 0x4e, 0xc3, 0x8f, 0x1e, 0x00, 0x9d, 0xb0,
    0x13, 0x29, 0x9a, 0xd0, 0x8b, 0x46, 0x8c, 0x4a, 0x09, 0x03, 0xee, 0x6e,
    0x3e, 0xfa, 0xb4, 0x9c, 0x9d, 0x7b, 0xab, 0x11, 0x02, 0x01, 0x34, 0x02,
    0x4b, 0x81, 0xda, 0xbb, 0x11, 0x20, 0x03, 0x17, 0x80, 0xb9, 0xf3, 0x32,
    0x27, 0xcb, 0x3b, 0xbf, 0x7d, 0x02, 0x53, 0x5a, 0x2c, 0xad, 0xf2, 0x62,
    0x6e, 0x69, 0x96, 0x23, 0xd0, 0x8d, 0xb6, 0x10, 0x34, 0xa2, 0x17, 0x93,
    0x72, 0x80, 0x78, 0xa5, 0x92, 0x92, 0xf2, 0x66, 0x36, 0x6c, 0x3a, 0x49,
    0x6b, 0x9b, 0x0b, 0xa0, 0x1e, 0xc8, 0x06, 0xba, 0xc6, 0x12, 0xb0, 0x05,
    0x78, 0x27, 0xe6, 0xbe, 0x49, 0xd1, 0x65, 0x45, 0x6b, 0x89, 0xbb, 0xdf,
    0x44, 0xbd, 0x66, 0x3d, 0x2e, 0xd9, 0x34, 0x2a, 0xf1, 0x9d, 0x88, 0xf3,
    0x57, 0x60, 0x52, 0xf6, 0x51, 0x5a, 0x5a, 0xc7, 0xca, 0x75, 0x47, 0x10,
    0x02, 0x05, 0x28, 0x05, 0xf2, 0x43, 0x0a, 0x0f, 0xdc, 0x8d, 0xc0, 0x4f,
    0x40, 0xc2, 0x57, 0xdb, 0x1f, 0x65, 0x7e, 0xf6, 0x14, 0xae, 0x68, 0x37,
    0xe1, 0x96, 0xa7, 0x8c, 0x8b, 0x1c, 0xe0, 0x96, 0x23, 0x8a, 0xe3, 0x95,
    0xe1, 0x3c, 0x97, 0xdb, 0x42, 0x47, 0x67, 0x1f, 0x15, 0x16, 0x9b, 0x84,
    0x7a, 0x6a, 0xfe, 0x42, 0xfd, 0x24, 0x43, 0x20, 0x07, 0xee, 0x6f, 0x03,
    0xc6, 0x25, 0x8f, 0xa7, 0xb1, 0x76, 0xf5, 0x4c, 0x9a, 0x35, 0xcb, 0xf1,
    0xc8, 0xc9, 0xe3, 0x26, 0x07, 0xf0, 0x78, 0xfa, 0x39, 0x57, 0xed, 0xe6,
    0x7c, 0xeb, 0x3c, 0x3e, 0x7a, 0x3f, 0x97, 0xa9, 0x69, 0x31, 0xa0, 0xfa,
    0xd6, 0xf7, 0xa1, 0xec, 0xe5, 0xc0, 0xb5, 0x4e, 0x92, 0xd0, 0x7c, 0xb5,
    0xfd, 0x51, 0x5c, 0x52, 0x2a, 0x2d, 0xf2, 0xe2, 0x09, 0x91, 0x03, 0x38,
    0x7b, 0x3d, 0x80, 0x60, 0xe7, 0xd9, 0x64, 0x44, 0x58, 0x3c, 0x9f, 0x6c,
    0x0d, 0xee, 0x7c, 0x02, 0x30, 0x6c, 0x55, 0x32, 0xea, 0x71, 0x0b, 0x9b,
    0x66, 0x8a, 0x25, 0x39, 0x29, 0x8a, 0x56, 0xf9, 0x71, 0x90, 0x34, 0x77,
    0xda, 0x8d, 0x53, 0x00, 0x74, 0x3b, 0x3d, 0x14, 0x5e, 0xce, 0xe1, 0xe1,
    0xf9, 0xc9, 0x48, 0x52, 0x50, 0xc0, 0xb0, 0x95, 0xc9, 0x40, 0x1e, 0x10,
    0x9f, 0x65, 0x36, 0x02, 0xe0, 0x92, 0x52, 0x27, 0x4c, 0x0e, 0xe0, 0xec,
    0x71, 0x07, 0xdb, 0x75, 0xb6, 0x08, 0xa2, 0x22, 0x75, 0xa4, 0x4f, 0x8d,
    0x05, 0x08, 0x03, 0x56, 0x85, 0x12, 0xf0, 0x30, 0xa0, 0xcd, 0x32, 0x1b,
    0xf1, 0x11, 0x4e, 0x1f, 0x86, 0x7b, 0x12, 0xd0, 0xde, 0xe5, 0x0c, 0xb6,
    0x9b, 0xda, 0x15, 0x00, 0xe6, 0x66, 0x04, 0xe7, 0x4c, 0x09, 0x25, 0x20,
    0x02, 0x20, 0xcb, 0x6c, 0xc0, 0x2d, 0xa5, 0x22, 0x49, 0x63, 0xa5, 0x87,
    0x91, 0xd1, 0x6a, 0xb3, 0x73, 0xb3, 0xa5, 0x33, 0xf8, 0xdc, 0xd3, 0xdb,
    0x4f, 0x87, 0x3b, 0x8a, 0xb9, 0x73, 0x82, 0x02, 0x86, 0x05, 0x13, 0x19,
    0x98, 0x04, 0xa0, 0xd3, 0x69, 0x50, 0xd0, 0x4e, 0x98, 0x1c, 0xa0, 0xbc,
    0xf2, 0xea, 0xb0, 0x3e, 0xbb, 0x3b, 0x9c, 0x30, 0x5d, 0xd0, 0xa7, 0x86,
    0x11, 0xc8, 0x04, 0x22, 0x54, 0x55, 0x8d, 0x8d, 0x48, 0xd1, 0x34, 0x61,
    0x72, 0xeb, 0xb5, 0x66, 0xae, 0x5c, 0x6b, 0x1e, 0x3a, 0xb9, 0x2c, 0x61,
    0x8a, 0xeb, 0xa4, 0xaa, 0xc6, 0x76, 0xbb, 0xab, 0x35, 0x94, 0x80, 0x52,
    0xc0, 0x5f, 0x61, 0xb1, 0xa1, 0xa3, 0x97, 0x30, 0x11, 0x32, 0x62, 0x8e,
    0x8a, 0xfa, 0xa6, 0x36, 0x8e, 0x16, 0x5d, 0x00, 0xc4, 0x90, 0xfe, 0xa4,
    0x78, 0x1d, 0x5a, 0x8d, 0xc0, 0x72, 0x31, 0x98, 0x8f, 0xfe, 0x0c, 0x25,
    0xc0, 0x02, 0xd8, 0x2b, 0xab, 0x55, 0x95, 0xfa, 0x71, 0xee, 0x42, 0x43,
    0x93, 0x8d, 0x5f, 0x4f, 0x9c, 0x47, 0x51, 0x94, 0x61, 0x63, 0x69, 0x86,
    0x7e, 0x3c, 0x1e, 0x1f, 0xb5, 0x75, 0xdd, 0x00, 0x4e, 0xa0, 0xf8, 0x4e,
    0x1b, 0x2d, 0x50, 0x0d, 0x78, 0x6b, 0xeb, 0xba, 0xe9, 0xec, 0xea, 0xc3,
    0x98, 0x70, 0x0e, 0xbb, 0x9c, 0x39, 0x26, 0xb1, 0xdd, 0xe9, 0xe2, 0x4c,
    0xe9, 0x25, 0x6a, 0xeb, 0x9b, 0x47, 0xb4, 0xc9, 0x37, 0x5d, 0xa5, 0xc2,
    0x62, 0xc3, 0xef, 0x17, 0xa0, 0x16, 0x2d, 0x95, 0x77, 0xda, 0xc8, 0x81,
    0x81, 0x72, 0x45, 0x11, 0xbc, 0xb7, 0xb5, 0x98, 0x18, 0x61, 0xc5, 0xe0,
    0x3f, 0x37, 0xe2, 0xa4, 0x5e, 0xef, 0x00, 0x67, 0x4a, 0x2f, 0xb1, 0x73,
    0xdf, 0xe9, 0x51, 0xc9, 0x73, 0xa7, 0xfb, 0xc8, 0x4e, 0x69, 0xe4, 0x8b,
    0xef, 0x2f, 0x04, 0x5f, 0x45, 0xad, 0xa0, 0x86, 0xe0, 0xb6, 0x57, 0x6e,
    0x07, 0xf2, 0x0f, 0x1d, 0xa9, 0x35, 0xac, 0x5c, 0x91, 0xce, 0xb2, 0xa5,
    0x85, 0x38, 0xe4, 0x59, 0xf4, 0x4b, 0x09, 0x08, 0x01, 0x6d, 0xed, 0x76,
    0xae, 0xdf, 0xb0, 0xd1, 0x70, 0xc3, 0xc6, 0xcd, 0xd6, 0xae, 0x90, 0xdb,
    0x3d, 0x18, 0xd1, 0x7a, 0x0d, 0xaf, 0x2e, 0xf8, 0x83, 0xae, 0xdd, 0x15,
    0x9c, 0x2b, 0xbe, 0x71, 0xbb, 0xbb, 0x25, 0x94, 0xed, 0xe0, 0x43, 0x7f,
    0x12, 0x58, 0x64, 0x34, 0xe8, 0xe5, 0xf2, 0x53, 0x6b, 0x11, 0x51, 0xd3,
    0xd9, 0x51, 0x96, 0x87, 0xf5, 0xba, 0x1d, 0x4f, 0x5f, 0xff, 0xa8, 0x84,
    0x83, 0x11, 0xa6, 0x93, 0x28, 0x48, 0xff, 0x9d, 0x9c, 0x6d, 0x7b, 0x91,
    0xac, 0x0e, 0x6c, 0x0f, 0xc5, 0x73, 0xff, 0x85, 0x2e, 0x84, 0x2a, 0xe0,
    0x11, 0xa0, 0x6e, 0xb0, 0xbd, 0x3c, 0xa8, 0xbd, 0x06, 0x68, 0xb6, 0xb5,
    0xbb, 0xd9, 0xf0, 0xe6, 0x49, 0x84, 0xb3, 0x96, 0x97, 0x32, 0x8f, 0x92,
    0x14, 0x37, 0x66, 0x59, 0x17, 0xc4, 0xac, 0x14, 0xc1, 0x37, 0xcf, 0x9c,
    0x25, 0xe7, 0xb3, 0xc3, 0x48, 0x56, 0x07, 0x00, 0xc6, 0xba, 0x5e, 0xf6,
    0xbf, 0x38, 0x15, 0xd4, 0x6a, 0xba, 0x08, 0xb5, 0xc6, 0x0c, 0x62, 0x70,
    0xd6, 0xf1, 0x00, 0x7f, 0x03, 0xcb, 0x1b, 0x1a, 0x9d, 0x51, 0xbf, 0x1c,
    0xb2, 0x62, 0x9e, 0x11, 0xc1, 0xeb, 0x4f, 0x76, 0xa1, 0x9d, 0x14, 0x4b,
    0x8b, 0x33, 0x0a, 0x8f, 0x57, 0x61, 0x78, 0x15, 0x27, 0x30, 0xc4, 0x68,
    0x58, 0x93, 0x7d, 0x83, 0x57, 0x72, 0xff, 0x26, 0xfa, 0x54, 0x35, 0xe1,
    0x6f, 0xec, 0x85, 0xb2, 0x32, 0x98, 0xea, 0x83, 0x57, 0xcd, 0xcc, 0x4e,
    0x8f, 0xa1, 0x27, 0x42, 0xa1, 0xec, 0xb2, 0x33, 0x06, 0x58, 0x0e, 0xec,
    0x41, 0xad, 0xaa, 0x43, 0x16, 0xa5, 0x0f, 0x01, 0xbf, 0xa1, 0xa6, 0x4e,
    0xe9, 0xd9, 0x95, 0xd3, 0xd9, 0xbe, 0x25, 0x8f, 0xc4, 0x84, 0x08, 0x5c,
    0x5e, 0x2d, 0x57, 0x3b, 0xe2, 0xb1, 0x76, 0xa4, 0xa0, 0xc1, 0xcf, 0xcc,
    0xc4, 0x9b, 0xa4, 0x1b, 0x1c, 0xe8, 0xc3, 0x7c, 0xd4, 0xd5, 0xdb, 0xf9,
    0xf8, 0xcb, 0xf3, 0x94, 0x9c, 0xa9, 0xa7, 0x7e, 0x59, 0x0e, 0xfa, 0x5a,
    0x07, 0x14, 0xbe, 0x0b, 0x15, 0xbb, 0xa0, 0x0d, 0x44, 0x38, 0x3c, 0xbd,
    0xe7, 0x1f, 0x8e, 0x94, 0x74, 0x0c, 0x00, 0x25, 0xc0, 0x22, 0x40, 0x19,
    0x29, 0xf0, 0x27, 0xa1, 0x96, 0xd5, 0x8b, 0x80, 0xc9, 0x92, 0x84, 0x64,
    0x4a, 0x8d, 0x21, 0x33, 0xc3, 0x80, 0x79, 0x8e, 0x81, 0xcc, 0x0c, 0x03,
    0x1e, 0x8f, 0x8f, 0xaa, 0x9a, 0x76, 0x2c, 0x17, 0xdb, 0xa9, 0xaa, 0xb1,
    0xd1, 0x66, 0xfb, 0x2f, 0x0b, 0x6a, 0x25, 0x38, 0xb6, 0x6d, 0x01, 0x4b,
    0x36, 0xed, 0x86, 0x1e, 0x0b, 0x9c, 0xfd, 0x01, 0x3a, 0x40, 0x89, 0x14,
    0x2c, 0xfc, 0xdc, 0x42, 0xf9, 0xe5, 0x1e, 0x37, 0x50, 0x08, 0xbc, 0x30,
    0xe2, 0xf7, 0x0c, 0x20, 0x05, 0x38, 0x84, 0xea, 0x40, 0x3e, 0xd4, 0x50,
    0x17, 0xea, 0xf2, 0xa2, 0x86, 0xd9, 0x7a, 0x60, 0x17, 0x70, 0x0b, 0x10,
    0x05, 0xaf, 0xcd, 0x16, 0x8a, 0xbd, 0x42, 0x88, 0xe6, 0x83, 0x42, 0xfc,
    0x9c, 0x2f, 0xc4, 0x77, 0xf9, 0xc2, 0xbb, 0x3b, 0x4f, 0x3c, 0x90, 0x12,
    0x2e, 0x00, 0x07, 0x50, 0x70, 0xb7, 0xa9, 0x2f, 0x35, 0xb0, 0x1b, 0x79,
    0xc0, 0x5c, 0x54, 0x47, 0x92, 0x81, 0x0e, 0xd4, 0x5a, 0xef, 0x34, 0xaa,
    0xff, 0xdc, 0xae, 0xf9, 0xd2, 0x81, 0x13, 0xc0, 0xb4, 0xd5, 0x8b, 0x93,
    0xe5, 0x03, 0xfb, 0x0f, 0x20, 0xf7, 0xb7, 0x41, 0xd1, 0xd7, 0xe0, 0x94,
    0x70, 0xea, 0xfd, 0x98, 0xde, 0x3a, 0x4f, 0x77, 0x8f, 0x6f, 0xd4, 0x7f,
    0x86, 0x7b, 0x45, 0x0c, 0x50, 0x06, 0xb8, 0x73, 0x33, 0x62, 0x45, 0x5f,
    0xf3, 0x71, 0x21, 0x5a, 0x0e, 0x0b, 0xb1, 0x27, 0x4f, 0x88, 0xe3, 0xf9,
    0x62, 0xe3, 0x53, 0x93, 0x05, 0xd0, 0x21, 0x8f, 0x31, 0xc9, 0xbd, 0xc0,
    0x81, 0xba, 0x63, 0x85, 0x65, 0x35, 0x76, 0xfb, 0xec, 0xec, 0x55, 0x74,
    0xf7, 0x0c, 0xc0, 0xbc, 0x59, 0x88, 0x38, 0x68, 0x53, 0x4f, 0xe9, 0x84,
    0x7f, 0x6a, 0xc7, 0x8b, 0x77, 0x81, 0xf6, 0xd8, 0x68, 0xad, 0x58, 0xf5,
    0x58, 0xa2, 0x58, 0xba, 0xd0, 0x20, 0x00, 0x05, 0x38, 0xf8, 0x7f, 0x09,
    0x00, 0xd5, 0x87, 0x4e, 0x01, 0x0d, 0xc0, 0x25, 0xe0, 0x73, 0xc0, 0xf0,
    0x2f, 0xf1, 0xc1, 0x43, 0x84, 0x70, 0x5c, 0x14, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

#include <cassert>
#include <cmath>
#include <iostream>
using namespace std;
#include <GL/glut.h>
#include <qtimer.h>
#include <qtooltip.h>
#include <qimage.h>
#include <qboxlayout.h>
#include <qwidgetaction.h>

GLSample::GLSample(QWidget* parent)
: QGLWidget(parent)
, View(tr("Wave form"), this)
, m_max_value(1.0)
{
	// settings
	QPixmap img;
	img.loadFromData(g_icon_sample, sizeof(g_icon_sample), "PNG");
	setting_show->setIcon(QIcon(img));
	setting_show->setChecked(false);
	hide();

	setting_hasFading = new QAction(tr("Show fading"), this);
	setting_hasFading->setCheckable(true);
	connect(setting_hasFading, SIGNAL(toggled(bool)), this, SLOT(updateGL()));
	m_popup_menu.addAction(setting_hasFading);

	QHBoxLayout* numFadingActionLayout = new QHBoxLayout(&m_popup_menu);

	QLabel* numFadingActionTitle = new QLabel(tr("Number of fading"), &m_popup_menu);
	numFadingActionLayout->addWidget(numFadingActionTitle);

	setting_spinNumFading = new QSpinBox(&m_popup_menu);
	setting_spinNumFading->setMinimum(1);
	setting_spinNumFading->setMaximum(10000);
	setting_spinNumFading->setSingleStep(1);
	setting_spinNumFading->setValue(20);
	setting_spinNumFading->setToolTip(tr("Number of fading"));
	connect(setting_spinNumFading, SIGNAL(valueChanged(int)), this, SLOT(updateGL()));
	numFadingActionLayout->addWidget(setting_spinNumFading);

	QWidget* numFadingActionWidget = new QWidget(&m_popup_menu);
	numFadingActionWidget->setLayout(numFadingActionLayout);

	QWidgetAction* numFadingAction = new QWidgetAction(&m_popup_menu);
	numFadingAction->setDefaultWidget(numFadingActionWidget);
	m_popup_menu.addAction(numFadingAction);
}

void GLSample::save()
{
	s_settings->setValue("hasFading", setting_hasFading->isChecked());
	s_settings->setValue("spinNumFading", setting_spinNumFading->value());
}
void GLSample::load()
{
	setting_hasFading->setChecked(s_settings->value("hasFading", setting_hasFading->isChecked()).toBool());
	setting_spinNumFading->setValue(s_settings->value("spinNumFading", setting_spinNumFading->value()).toInt());
}
void GLSample::clearSettings()
{
	s_settings->remove("hasFading");
	s_settings->remove("spinNumFading");
}

GLSample::Sample::Sample(double t, const deque<double>& d)
{
	time = t;
	data = d;
	max_value = 0.0;
	for(size_t i=0; i<data.size(); i++)
		max_value = max(max_value, abs(data[i]));
}

void GLSample::add(double time, const deque<double>& data)
{
	m_samples.push_front(Sample(time, data));

	if(setting_hasFading->isChecked())
		while(!m_samples.empty() && int(m_samples.size())>setting_spinNumFading->value())
			m_samples.pop_back();
	else
		while(!m_samples.empty() && m_samples.size()>1)
			m_samples.pop_back();
}

void GLSample::initializeGL()
{
	// Set the clear color to black
	glClearColor(1.0, 1.0, 1.0, 0.0);

	// glShadeModel( GL_FLAT );
	glShadeModel( GL_SMOOTH );

	glLoadIdentity();
}

void GLSample::paintGL()
{
	glClear(GL_COLOR_BUFFER_BIT);

	// name
	string str = tr("Wave form").toStdString();
	glColor3f(0.75,0.75,0.75);
	glRasterPos2i(2, height()-20);
	for(size_t i = 0; i < str.size(); i++)
		glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, (unsigned char)str[i]);

	// horiz lines
	glBegin(GL_LINES);
	float gray = 0.5;
	glColor3f(gray, gray, gray);
	glVertex2i(0,  height()/2);
	glVertex2i(width(),  height()/2);
	glEnd();

	if(m_max_value==0.0)	m_max_value = 1.0;

	// sample
	if(!m_samples.empty())
	{
		m_max_value = 0.0;
		for(int j=m_samples.size()-1; j>=0; j--)
		{
			m_max_value = max(m_max_value, abs(m_samples[j].max_value));
			if(!setting_hasFading->isChecked())	j=-1;
		}

		for(int j=m_samples.size()-1; j>=0; j--)
		{
			if(m_max_value!=0.0)
			{
				glBegin(GL_LINE_STRIP);
				float grey = float(j)/m_samples.size();
				glColor3f(grey, grey, grey);
				int size = m_samples[j].data.size();
				float step = float(width())/size;
				for(int i=size-1; i>0; i--)
					glVertex2i(int((size-i-1)*step), int((m_samples[j].data[i]/m_max_value)*height()/2 + height()/2));
				glVertex2i(width(), int((m_samples[j].data[0]/m_max_value)*height()/2 + height()/2));
				glEnd();
			}

			if(!setting_hasFading->isChecked())	j=-1;
		}
	}

	glFlush();
}

void GLSample::resizeGL( int w, int h )
{
	// Set the new viewport size
	glViewport(0, 0, (GLint)w, (GLint)h);

	// Choose the projection matrix to be the matrix
	// manipulated by the following calls
	glMatrixMode(GL_PROJECTION);

	// Set the projection matrix to be the identity matrix
	glLoadIdentity();

	// Define the dimensions of the Orthographic Viewing Volume
	glOrtho(0.0, w, 0.0, h, 0.0, 1.0);

	// Choose the modelview matrix to be the matrix
	// manipulated by further calls
	glMatrixMode(GL_MODELVIEW);
}
