-- $Id: selectedoverloads.vhdl 4330 2009-01-27 14:50:08Z potyra $ 

-- test for various different kinds of selected names.

-- Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.



package outer2 is
	signal foo : integer;
end package outer2;

entity outer1 is 
	signal foo : integer;

	type R1 is record
		elem1 : integer;
		elem2 : integer;
	end record;

	type R2 is record
		elem1 : integer;
		elem2 : R1;
	end record;

	type R3 is record
		elem1 : R1;
		elem2 : R2;
	end record;

	type myArray is array(0 to 1) of r1;
end entity outer1;

architecture inner of outer1 is
	function foo (foobar : integer) return integer is
	begin
		return - foobar;
	end;

	function foo(foobar : R1) return R1 is
	begin
		return foobar;
	end;

	function foo(foobar : integer) return R1 is
	variable r : R1;
	begin
		r.elem1 := foobar;
		r.elem2 := foobar;
		return r;
	end;

	function foo(foobar: integer) return R2 is
	variable r : R2;
	begin
		r.elem1 := foobar;
		r.elem2.elem1 := foobar;
		r.elem2.elem2 := foobar;
		return r;
	end;

	function foo(foobar: integer) return myarray is
	variable a : myarray;
	variable i1 : r1;
	begin
		i1.elem1 := foobar;
		i1.elem2 := foobar;
		a := (others => i1);
		return a;
	end;
begin
	p1 : process
		variable x : integer;
		variable rx : R1;
		variable a : myArray;
		variable rx3 : R3;
	begin
		-- x := foo(3).elem1; -- ambiguous!
		x := foo(3).elem2;
		x := foo(rx).elem1;
		rx := foo(3).elem2;
		x := foo(3).elem2.elem1;
		x := a(0).elem1;
		x := r3.elem2.elem2.elem1;
		x := a(0 to 1)(0).elem1;
		x := foo(3)(0).elem1;
		x := foo(3)(0).elem2;
		x := foo(42)(0 to 1)(0).elem1;
		x := foo(42)(0 to 1)(0).elem2;
	end process p1;
end architecture inner;
