//
// File: PanelParametresSortie.cc
// Created by: Éric Laly <elaly@free.fr>
// Created on: Tue Oct 17 18:36:00 2006
//

#include "PanelParametresSortie.h"
#include <exception>
using std::exception;

PanelParametresSortie::PanelParametresSortie(wxWindow* parent, int id):wxPanel(parent, id)
{
    sizer_panel_parametres_sortie= new wxBoxSizer(wxVERTICAL);

    panel_saisie_repertoire_base=new PanelSaisieRepertoire(wxT("Répertoire de base des sorties: "),wxT(""),true, this,-1);
    sizer_panel_parametres_sortie->Add(panel_saisie_repertoire_base, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 2);
    
    const wxString radio_box_type_sortie_choice[] = {
        wxT("Aucune"),
        wxT("Encadrement simple ou multiple"),
        wxT("Sortie PHPWebGallery")
    };
    radio_box_type_sortie= new wxRadioBox(this, -1, wxT("Type de sortie"), wxDefaultPosition, wxDefaultSize, 3, radio_box_type_sortie_choice, 0, wxRA_SPECIFY_COLS);
    radio_box_type_sortie->SetSelection(0);
    sizer_panel_parametres_sortie->Add(radio_box_type_sortie, 0, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 2);

    panel_encadrement.clear();
    
    SetSizer(sizer_panel_parametres_sortie);

    label_nombre_sorties = new wxStaticText(this, -1, wxT("Nombre de sorties: "));
    NombreSorties=1;
    text_ctrl_nombre_sorties= new wxTextCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxTE_READONLY);
    spin_button_nombre_sorties= new wxSpinButton(this, -1, wxDefaultPosition, wxDefaultSize,
        wxSP_VERTICAL| wxSP_ARROW_KEYS|wxSP_WRAP);
    sizer_nombre_sorties= new wxBoxSizer(wxHORIZONTAL);
    sizer_nombre_sorties->Add(label_nombre_sorties, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_nombre_sorties->Add(text_ctrl_nombre_sorties, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_nombre_sorties->Add(spin_button_nombre_sorties, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_panel_parametres_sortie->Add(sizer_nombre_sorties, 0, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 2);
    sizer_nombre_sorties->Show(false);
    
    
    // on crée un panel scrollable qui va contenir le(s) panel(s) de paramétrage
    sw_parametre=new wxScrolledWindow(this,-1);
    sw_parametre->SetScrollRate(10,10);
    sizer_parametres= new wxBoxSizer(wxVERTICAL);
    sw_parametre->SetSizer(sizer_parametres);

    sizer_panel_parametres_sortie->Add(sw_parametre, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 2);

    AfficheNombreSorties();

    // on connecte les évènements
   	Connect(radio_box_type_sortie->GetId( ), wxEVT_COMMAND_RADIOBOX_SELECTED, (wxObjectEventFunction) &PanelParametresSortie::OnRadioboxSelectedTypeSortie);
    Connect(spin_button_nombre_sorties->GetId( ), wxEVT_SCROLL_LINEUP,(wxObjectEventFunction) &PanelParametresSortie::OnSpinButtonUpNombreSorties);
    Connect(spin_button_nombre_sorties->GetId( ), wxEVT_SCROLL_LINEDOWN,(wxObjectEventFunction) &PanelParametresSortie::OnSpinButtonDownNombreSorties);
}

PanelParametresSortie::~PanelParametresSortie()
{
	// TODO: put destructor code here
}

void PanelParametresSortie::AfficheNombreSorties()
{
	wxString stemp(wxT(""));stemp<<NombreSorties;
    
	// on recherche la taille du text_ctrl pour contenir la valeur
	int x,y;
	wxTextCtrl* temp = new wxTextCtrl(this, -1, wxT(""));
	temp->GetTextExtent(stemp+wxT("  "), &x, &y);
	delete temp;

	// on affiche la valeur correspondant à la position du slider
	text_ctrl_nombre_sorties->SetMinSize(wxSize(x+2, y+5));
	text_ctrl_nombre_sorties->SetValue(stemp);
    sizer_nombre_sorties->Layout();// on retrace le panel pour mettre à jour la taille du textctrl
}

void  PanelParametresSortie::OnSpinButtonUpNombreSorties(wxCommandEvent& event)
{
    try
    {
        NombreSorties++;
        AfficheNombreSorties();
        wxString temp(wxT("Sortie "));temp<<NombreSorties;
        panel_encadrement.push_back(new PanelSaisieParametresImageSortie(temp,false, wxT("cadre-"), true, temp, true, sw_parametre,-1));
        sizer_parametres->Add(panel_encadrement[NombreSorties-1], 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 2);
        sizer_parametres->Layout();
        sizer_panel_parametres_sortie->Layout();// nécessaire 
    }
    catch (exception& e)
    {
        wxLogError(wxT("On ne peut plus créer une nouvelle sortie: %s"),e.what());
    }  
}    

void  PanelParametresSortie::OnSpinButtonDownNombreSorties(wxCommandEvent& event)
{
    if (NombreSorties>1) 
    {
        delete panel_encadrement[NombreSorties-1];
        panel_encadrement.resize(NombreSorties-1);
        NombreSorties--;
        AfficheNombreSorties();
        sizer_parametres->Layout();
        sizer_panel_parametres_sortie->Layout();// nécessaire 
    }   
}    

unsigned int PanelParametresSortie::GetNombreEncadrement()
{
    return panel_encadrement.size();
}    

wxString PanelParametresSortie::GetNomSortie(int index)
{
    return panel_encadrement[index]->GetNomSortie();
}    

wxString PanelParametresSortie::GetRepertoireDestination()
{
    return panel_saisie_repertoire_base->GetRepertoire();
}    

wxString PanelParametresSortie::GetSousRepertoireDestination(int index)
{
    return panel_encadrement[index]->GetRepertoireDestination();
}    

wxString PanelParametresSortie::GetPrefixeFichier(int index)
{
    return panel_encadrement[index]->GetPrefixeFichier();
}

int PanelParametresSortie::GetQualiteEnregistrement(int index)
{
   return panel_encadrement[index]->GetQualiteEnregistrement();
}

int PanelParametresSortie::GetTailleRedimensionement(int index)
{
    return panel_encadrement[index]->GetTailleRedimensionement();
}

void PanelParametresSortie::OnRadioboxSelectedTypeSortie(wxCommandEvent& event)
{
    // on autorise la sortie si on a choisi un répertoire de base.
    if (!(panel_saisie_repertoire_base->GetRepertoire().IsSameAs(wxT(""))))
    {        
        switch (radio_box_type_sortie->GetSelection())
        {
            case 0:EnleveSorties();break;
            case 1:CreeSortieSimpleOuMultiple();break;
            case 2:CreeSortiePHPWebGallery();break;
        } 
    } else {
        radio_box_type_sortie->SetSelection(0);
    }    
}

void PanelParametresSortie::EnleveSorties()
{
    for (unsigned int i=0;i<panel_encadrement.size();i++)
    {
        delete panel_encadrement[i];
    }    
    panel_encadrement.clear();
    sizer_nombre_sorties->Show(false);
    sizer_panel_parametres_sortie->Layout();
}

void PanelParametresSortie::CreeSortieSimpleOuMultiple()
{
    EnleveSorties();
    NombreSorties=1;
    AfficheNombreSorties();
    sizer_nombre_sorties->Show(true);
    panel_encadrement.push_back(new PanelSaisieParametresImageSortie(wxT("Sortie 1"),false, wxT("cadre-"), true, wxT("Sortie 1"), true, sw_parametre,-1));
    sizer_parametres->Add(panel_encadrement[0], 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 2);
    sizer_panel_parametres_sortie->Layout();// nécessaire 
    sizer_parametres->Layout();
}

void PanelParametresSortie::CreeSortiePHPWebGallery()
{
    EnleveSorties();
    panel_encadrement.push_back(new PanelSaisieParametresImageSortie(wxT("Image réduite"),true, wxT(""), false, wxT(""), false, sw_parametre,-1));
    sizer_parametres->Add(panel_encadrement[0], 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 2);
    panel_encadrement.push_back(new PanelSaisieParametresImageSortie(wxT("Vignette"),true, wxT("TN-"), false, wxT("thumbnail"), false, sw_parametre,-1));
    sizer_parametres->Add(panel_encadrement[1], 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 2);
    panel_encadrement.push_back(new PanelSaisieParametresImageSortie(wxT("Image Haute Résolution"),false, wxT(""), false, wxT("pwg_high"), false, sw_parametre,-1));
    sizer_parametres->Add(panel_encadrement[2], 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 2);
    sizer_panel_parametres_sortie->Layout();// nécessaire 
    sizer_parametres->Layout();
}
