<?php

#  Copyright (C) 2008,2009 Neil Williams <codehelp@debian.org>
#
#  This package is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

# A few notes:
# 1. There is one file / data source per suite - the reprepro logs.
# 2. Configuration is internal

##### config #####
$buildlog_path = "/var/www/grip/logs/";
$template_file = "/var/www/toolchains/emdebian.php";
$default_days = 7;
$supported_arches = array ("i386", "amd64", "arm", "armel",
 "powerpc", "mips", "mipsel" );
#### end config ##
header("Content-Type: application/rss+xml");
$now = date("D, d M Y H:i:s T");
$num_days = $default_days;
if (($_GET['days'] != ''))
{
	$num_days = htmlspecialchars ($_GET['days']);
	$num_days = preg_replace ('/\.+\/+/', "", $num_days);
}
$suite="sid";
if (($_GET['suite'] != ''))
{
	$suite = htmlspecialchars ($_GET['suite']);
	$suite = preg_replace ('/\.+\/+/', "", $suite);
}
$feed = "<?xml version=\"1.0\"?>
<rss version=\"2.0\"
xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"
xmlns:admin=\"http://webns.net/mvcb/\"
xmlns:dc=\"http://purl.org/dc/elements/1.1/\"
xmlns:slash=\"http://purl.org/rss/1.0/modules/slash/\"
xmlns:wfw=\"http://wellformedweb.org/CommentAPI/\"
xmlns:content=\"http://purl.org/rss/1.0/modules/content/\">
<channel>
<title>Emdebian Grip - $suite</title>
<link>http://www.emdebian.org/grip/</link>
<description>Emdebian Grip repository - $suite activity feed</description>
<language>en-gb</language>";
$loglist = array ();
if (!is_dir ("$buildlog_path"))
{
	$feed .= "<item>Cannot find $buildlog_path!</item>";
	$feed .= "</channel></rss>";
	echo $feed;
	exit;
}
$logfile = "$buildlog_path"."$suite"."-log";
$files = array ();
$cut_off = date ("U") - (60*60*24*$num_days);
$total = array ();

$contents = file ("$logfile");
sort ($contents);
$arches = array();
$oldpkg = "";
$c = 0;
$output = array ();
$dates=array();
$l = 0;
$pubdate=0;
foreach ($contents as $line)
{
	$matches = split (" ", $line);
	$time = $matches[1];
	$day = $matches[0];
	$thisdate = strtotime ("$day $time");
	if ($pubdate < $thisdate)
	{
		$pubdate = $thisdate;
	}
	$action = $matches[2];
	$oldversion = rtrim($matches[9]);
	if ($action == "add")     { $action = "has been added to $suite"; }
	if ($action == "remove")  { $action = "has been removed from $suite"; }
	if ($action == "replace") { $action = "replaces $oldversion in $suite"; }
	$package = $matches[7];
	$newversion = rtrim($matches[8]);
	array_push ($arches, $matches[6]);
	$arch = $matches[6];
	# catch the first package
	if ($c == 0)
	{
		$oldpkg = $package;
		$c++;
	}
	if ($oldpkg == $package)
	{
		array_push ($arches, $arch);
		$str = "<dt><b>$package</b> ($newversion)</dt>";
		$end = "<dd>$action.</dd>";
		continue;
	}
	$list = join (", ", $arches);
	if (count($arches) > 0)
	{
		$list = "{<i>".$list."</i>}";
	}
	$str = "$str $end";
	$arches = array();
	$oldpkg = $package;
	$dates["$day"][$l] = $str;
	$str = $end = "";
	$l++;
}

$feed .= "
<pubDate>".date("r",$pubdate)."</pubDate>
<image>
<title>Emdebian Grip - $suite</title>
<link>http://www.emdebian.org/grip/</link>
<url>http://www.emdebian.org/Pics/emdebian_swirl.jpg</url>
</image>
";

ksort ($dates);
foreach ($dates as $key => $line)
{
	$feed .= "<item>\n<title>Updates in $suite for $key</title>\n";
	$feed .="<link>http://www.emdebian.org/grip/</link>\n";
	$feed .= "<description>\n";
	asort ($line);
	foreach ($line as $l => $str)
	{
		if ($str !== " ")
		{
			$feed .= htmlentities("<dl>$str</dl>");
		}
	}
	$feed .= "</description>\n";
	$feed .= "<content:encoded>\n";
	foreach ($line as $l => $str)
	{
		if ($str !== " ")
		{
			$feed .= htmlentities("<dl>$str</dl>");
		}
	}
	$feed .= "</content:encoded>\n";
	$feed .= "</item>\n";
}
$feed .= "</channel></rss>";
echo $feed;
?>

