/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.config;

import amazon.fws.clicommando.exceptions.ConfigurationErrorException;

public class MapTransConfig {
    private String translation;
    private Integer ordinalStart;

    public MapTransConfig(String translation, Integer ordinalStart) {
        this.ordinalStart = ordinalStart;
        this.translation = translation;
    }

    public String getTranslation() {
        return this.translation;
    }

    public Integer getOrdinalStart() {
        return this.ordinalStart;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ordinalStart == null ? 0 : this.ordinalStart.hashCode());
        result = 31 * result + (this.translation == null ? 0 : this.translation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapTransConfig)) {
            return false;
        }
        MapTransConfig other = (MapTransConfig)obj;
        if (this.ordinalStart == null ? other.ordinalStart != null : !this.ordinalStart.equals(other.ordinalStart)) {
            return false;
        }
        return !(this.translation == null ? other.translation != null : !this.translation.equals(other.translation));
    }

    public String toString() {
        return "MapTrans Translation='" + this.translation + "' with ordinal starting at " + this.ordinalStart + "\n";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MapType {
        KEY,
        VALUE,
        KEY_VALUE;


        public static MapType parse(String stringType) throws IllegalArgumentException {
            for (MapType t : MapType.values()) {
                if (!t.name().equalsIgnoreCase(stringType.replaceAll("-", "_"))) continue;
                return t;
            }
            throw new ConfigurationErrorException("Illegal map translation type: " + stringType);
        }
    }
}

