/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.elasticloadbalancing.processors.service.route53;

import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.exceptions.ServiceExecutionException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.processors.service.ServiceResponseHandler;
import com.amazon.webservices.dns.client.Route53Client;
import com.amazon.webservices.dns.client.util.HttpResponse;
import com.amazon.webservices.dns.v20110505.ChangeResourceRecordSetsRequest;
import java.net.URL;

public class Route53ServiceResponseHandler
implements ServiceResponseHandler {
    private final Route53Client r53Client;
    private final URL serviceUrl;
    private final ChangeResourceRecordSetsRequest request;
    private final String hostedZoneId;
    private final HttpResponse response;
    private String header;
    private String debugInfo;

    public Route53ServiceResponseHandler(Route53Client r53Client, URL serviceUrl, ChangeResourceRecordSetsRequest request, String hostedZoneId, HttpResponse response) {
        this.r53Client = r53Client;
        this.serviceUrl = serviceUrl;
        this.request = request;
        this.hostedZoneId = hostedZoneId;
        this.response = response;
        this.setHeader(response);
        this.setDebugInfo(serviceUrl);
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    private void setDebugInfo(URL url) {
        StringBuilder errMsgBuilder = new StringBuilder();
        errMsgBuilder.append("Problem with service call:\nCalled:\n" + url);
        errMsgBuilder.append("\nHeaders:\n" + this.getHeader());
        errMsgBuilder.append("\nReturn:\n" + this.getResponse() + "\n");
        errMsgBuilder.append("\nCode: " + this.getStatusCode() + "\n");
        this.debugInfo = errMsgBuilder.toString();
    }

    public CliCommandoException getException() {
        return new ServiceExecutionException(this.getDebugInfo(), ErrorMessages.ErrorCode.SERVICE_ERROR, new String[]{"Please try --show-xml to see the details.", "N/A"});
    }

    public String getHeader() {
        return this.header;
    }

    private void setHeader(HttpResponse response) {
        StringBuilder headers = new StringBuilder();
        for (String header : response.getHeaders().keySet()) {
            String value = response.getHeaders().get(header);
            if (header == null) {
                headers.append(value + "\n");
                continue;
            }
            headers.append(header + ": " + value + "\n");
        }
        this.header = headers.toString();
    }

    public int getStatusCode() {
        return this.response.getStatusCode();
    }

    public String getResponse() {
        return this.response.getBody();
    }

    public String getUrl() {
        String requestUrl = this.r53Client.getRequestUrl(this.serviceUrl, this.request, this.hostedZoneId);
        String requestXml = this.r53Client.getRequestXml(this.request);
        return requestUrl + "\n" + requestXml;
    }

    public boolean isError() {
        return 300 <= this.getStatusCode();
    }
}

