/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.webservices.dns.client.impl;

import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.messages.ErrorMessages;
import com.amazon.webservices.dns.client.Route53Client;
import com.amazon.webservices.dns.client.impl.Route53Serializer;
import com.amazon.webservices.dns.client.util.HttpResponse;
import com.amazon.webservices.dns.client.util.HttpRestClient;
import com.amazon.webservices.dns.client.util.Path;
import com.amazon.webservices.dns.v20110505.AliasTarget;
import com.amazon.webservices.dns.v20110505.Change;
import com.amazon.webservices.dns.v20110505.ChangeAction;
import com.amazon.webservices.dns.v20110505.ChangeBatch;
import com.amazon.webservices.dns.v20110505.ChangeResourceRecordSetsRequest;
import com.amazon.webservices.dns.v20110505.Changes;
import com.amazon.webservices.dns.v20110505.RRType;
import com.amazon.webservices.dns.v20110505.ResourceRecordSet;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Route53ClientImpl
implements Route53Client {
    private final URL url_;
    private final HttpRestClient client_;
    private final Route53Serializer route53Serializer_;
    private final String accessKey_;
    private final String secretKey_;
    private static final String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";

    public Route53ClientImpl(URL url, String xmlns, String accessKey, String secretKey) {
        this.initializeLogging();
        this.url_ = url;
        this.client_ = new HttpRestClient(this.url_);
        this.accessKey_ = accessKey;
        this.secretKey_ = secretKey;
        this.route53Serializer_ = new Route53Serializer(xmlns);
    }

    private void initializeLogging() {
        Logger.getRootLogger().setLevel(Level.OFF);
    }

    private Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        String date = this.getRFC1123FormattedDate(new DateTime());
        String signature = null;
        signature = this.calculateRFC2104HMAC(date, this.secretKey_);
        headers.put("Date", date);
        headers.put("X-Amzn-Authorization", "AWS3-HTTPS AWSAccessKeyId=" + this.accessKey_ + ",Algorithm=HmacSHA1,Signature=" + signature);
        return headers;
    }

    private String calculateRFC2104HMAC(String data, String key) {
        String result;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes());
            result = Base64.encode(rawHmac);
        }
        catch (Exception e) {
            throw new BadInputException(ErrorMessages.ErrorCode.BAD_CREDENTIALS_CANNOT_SIGN, new String[]{e.getMessage()});
        }
        return result;
    }

    private String getRFC1123FormattedDate(DateTime time) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)RFC1123_PATTERN).withLocale(Locale.ENGLISH);
        DateTime utcTime = time.toDateTime(DateTimeZone.UTC);
        return formatter.print((ReadableInstant)utcTime);
    }

    @Override
    public ChangeResourceRecordSetsRequest createAliasResourceRecordRequest(ChangeAction action, String domainName, RRType rrType, String identifier, Long weight, String aliasTargetHostedZoneId, String aliasTargetDomainName) {
        ChangeResourceRecordSetsRequest changeResourceRecordRequest = new ChangeResourceRecordSetsRequest();
        ChangeBatch changeBatch = new ChangeBatch();
        Changes changes = new Changes();
        Change createAliasRecordChange = new Change();
        ResourceRecordSet resourceRecordSet = new ResourceRecordSet();
        AliasTarget aliasTarget = new AliasTarget();
        resourceRecordSet.setName(domainName);
        resourceRecordSet.setType(rrType);
        resourceRecordSet.setSetIdentifier(identifier);
        resourceRecordSet.setWeight(weight);
        aliasTarget.setHostedZoneId(aliasTargetHostedZoneId);
        aliasTarget.setDNSName(aliasTargetDomainName);
        resourceRecordSet.setAliasTarget(aliasTarget);
        createAliasRecordChange.setAction(action);
        createAliasRecordChange.setResourceRecordSet(resourceRecordSet);
        changes.getChange().add(createAliasRecordChange);
        changeBatch.setComment("Setting up Alias record using ELB CLI");
        changeBatch.setChanges(changes);
        changeResourceRecordRequest.setChangeBatch(changeBatch);
        return changeResourceRecordRequest;
    }

    @Override
    public HttpResponse changeRecordResourceSet(ChangeResourceRecordSetsRequest request, String hostedZoneId) {
        if (hostedZoneId == null) {
            return null;
        }
        String requestXml = this.getRequestXml(request);
        Path hostedZonePath = this.getHostedZonePath(hostedZoneId);
        Map<String, String> headers = this.getHeaders();
        return this.client_.post(hostedZonePath, headers, requestXml);
    }

    private Path getHostedZonePath(String hostedZoneId) {
        return new Path("/hostedzone/" + hostedZoneId + "/rrset");
    }

    @Override
    public String getRequestUrl(URL serviceUrl, ChangeResourceRecordSetsRequest request, String hostedZoneId) {
        return HttpRestClient.getEscapedUrl(serviceUrl, this.getHostedZonePath(hostedZoneId));
    }

    @Override
    public String getRequestXml(ChangeResourceRecordSetsRequest request) {
        return this.route53Serializer_.serialize(request);
    }
}

