/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service.binding;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.WrappedBinding;
import org.codehaus.xfire.soap.AbstractSoapBinding;
import org.codehaus.xfire.util.STAXUtils;
import org.codehaus.xfire.util.stax.DepthXMLStreamReader;

public class RPCBinding
extends WrappedBinding {
    public void readMessage(InMessage inMessage, MessageContext context) throws XFireFault {
        OperationInfo operation;
        Service endpoint = context.getService();
        ArrayList<Object> parameters = new ArrayList<Object>();
        DepthXMLStreamReader dr = new DepthXMLStreamReader(context.getInMessage().getXMLStreamReader());
        if (!STAXUtils.toNextElement(dr)) {
            throw new XFireFault("There must be a method name element.", XFireFault.SENDER);
        }
        String opName = dr.getLocalName();
        if (RPCBinding.isClientModeOn(context)) {
            opName = opName.substring(0, opName.lastIndexOf("Response"));
        }
        if ((operation = endpoint.getServiceInfo().getOperation(opName)) == null) {
            throw new XFireFault("Could not find operation: " + opName, XFireFault.SENDER);
        }
        this.nextEvent(dr);
        this.setOperation(operation, context);
        if (operation == null) {
            throw new XFireFault("Invalid operation.", XFireFault.SENDER);
        }
        Service service = context.getService();
        MessageInfo msg = RPCBinding.isClientModeOn(context) ? operation.getOutputMessage() : operation.getInputMessage();
        while (STAXUtils.toNextElement(dr)) {
            MessagePartInfo p = (MessagePartInfo)msg.getMessageParts().get(parameters.size());
            if (p == null) {
                throw new XFireFault("Parameter " + dr.getName() + " does not exist!", XFireFault.SENDER);
            }
            QName name = p.getSchemaType().isAbstract() ? new QName(service.getTargetNamespace(), dr.getLocalName()) : dr.getName();
            if (!p.getName().equals(name)) {
                throw new XFireFault("Parameter " + dr.getName() + " does not exist!", XFireFault.SENDER);
            }
            parameters.add(endpoint.getBindingProvider().readParameter(p, dr, context));
        }
        context.getInMessage().setBody(parameters);
    }

    protected String getBoundNamespace(MessageContext context, MessagePartInfo p) {
        if (p.isSchemaElement() || ((AbstractSoapBinding)context.getBinding()).getUse().equals("encoded")) {
            return p.getName().getNamespaceURI();
        }
        return "";
    }

    public Object clone() {
        return new RPCBinding();
    }
}

