/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.jaxb2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.stax.ElementWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.jaxb2.AttachmentMarshaller;
import org.codehaus.xfire.jaxb2.AttachmentUnmarshaller;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.util.Resolver;
import org.codehaus.xfire.util.stax.DOMStreamWriter;
import org.jdom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbType
extends Type {
    private static final Log LOG = LogFactory.getLog(JaxbType.class);
    public static final String SEARCH_PACKAGES = "jaxb.search.packages";
    public static final String ENABLE_VALIDATION = "jaxb.validation.enabled";
    public static final String ENABLE_RESPONSE_VALIDATION = "jaxb.validation.response.enabled";
    public static final String ENABLE_REQUEST_VALIDATION = "jaxb.validation.request.enabled";
    public static final String VALIDATION_SCHEMA = "jaxb.validation.schema";
    public static final String GENERATED_VALIDATION_SCHEMA = "jaxb.generated.validation.schema";
    private Class actualTypeClass;
    private static final QName XSI_TYPE = new QName("http://www.w3.org/2001/XMLSchema-instance", "type");
    private JAXBContext context;
    private Class<? extends XmlAdapter> adapterClz;

    public JaxbType(Class clazz) {
        this(clazz, null);
    }

    public JaxbType(Class clazz, JAXBContext jaxbContext) {
        this.setTypeClass(clazz);
        this.initType();
        this.context = jaxbContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema setupValidationSchema(Collection<String> schemaLocations) throws IOException, SAXException {
        Schema schema;
        int i;
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source[] schemaSources = new StreamSource[schemaLocations.size()];
        try {
            i = 0;
            for (String schemaLocation : schemaLocations) {
                schemaSources[i] = new StreamSource(new Resolver(schemaLocation).getInputStream());
                ++i;
            }
            schema = factory.newSchema(schemaSources);
        }
        finally {
            for (i = 0; i < schemaSources.length; ++i) {
                InputStream inputStream;
                if (schemaSources[i] == null || (inputStream = ((StreamSource)schemaSources[i]).getInputStream()) == null) continue;
                inputStream.close();
            }
        }
        return schema;
    }

    private Schema getValidationSchema(MessageContext context, JAXBContext jc) {
        Schema schema = (Schema)context.getService().getProperty(GENERATED_VALIDATION_SCHEMA);
        if (schema != null) {
            return schema;
        }
        Collection schemas = (Collection)context.getContextualProperty(VALIDATION_SCHEMA);
        if (schemas == null) {
            schemas = (Collection)context.getService().getProperty("objectServiceFactory.schemas");
        }
        try {
            if (schemas != null) {
                schema = this.setupValidationSchema(schemas);
            } else {
                final ArrayList results = new ArrayList();
                jc.generateSchema(new SchemaOutputResolver(){

                    public Result createOutput(String ns, String file) throws IOException {
                        DOMResult result = new DOMResult();
                        result.setSystemId(file);
                        results.add(result);
                        return result;
                    }
                });
                Source[] sources = new DOMSource[results.size()];
                for (int i = 0; i < sources.length; ++i) {
                    sources[i] = new DOMSource();
                    ((DOMSource)sources[i]).setNode(((DOMResult)results.get(i)).getNode().getFirstChild());
                }
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                schema = factory.newSchema(sources);
            }
            context.getService().setProperty(GENERATED_VALIDATION_SCHEMA, schema);
        }
        catch (IOException e) {
            throw new XFireRuntimeException("Error creating validating schema.", e);
        }
        catch (SAXException e) {
            throw new XFireRuntimeException("Error creating validating schema.", e);
        }
        return schema;
    }

    @Override
    public Object readObject(MessageReader reader, MessageContext context) throws XFireFault {
        try {
            Object o;
            JAXBContext jc = this.getJAXBContext(context);
            Unmarshaller u = jc.createUnmarshaller();
            u.setAttachmentUnmarshaller((javax.xml.bind.attachment.AttachmentUnmarshaller)new AttachmentUnmarshaller(context));
            boolean validationEnabled = Boolean.valueOf((String)context.getContextualProperty(ENABLE_VALIDATION));
            boolean requestValidation = Boolean.valueOf((String)context.getContextualProperty(ENABLE_REQUEST_VALIDATION));
            if (validationEnabled || requestValidation) {
                u.setSchema(this.getValidationSchema(context, jc));
            }
            if ((o = this.isAbstract() && reader.getAttributeReader(XSI_TYPE).getValue() == null ? u.unmarshal(reader.getXMLStreamReader(), this.actualTypeClass) : u.unmarshal(reader.getXMLStreamReader())) instanceof JAXBElement) {
                o = ((JAXBElement)o).getValue();
            }
            return o;
        }
        catch (JAXBException e) {
            Throwable ex = e;
            if (e.getLinkedException() != null) {
                ex = e.getLinkedException();
            }
            LOG.error((Object)ex);
            throw new XFireFault("Could not unmarshall type : " + ex.getMessage(), ex, XFireFault.RECEIVER);
        }
    }

    @Override
    public void writeObject(Object object, MessageWriter writer, MessageContext context) throws XFireFault {
        try {
            JAXBContext jc = this.getJAXBContext(context);
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            m.setAttachmentMarshaller((javax.xml.bind.attachment.AttachmentMarshaller)new AttachmentMarshaller(context));
            boolean validationEnabled = Boolean.valueOf((String)context.getContextualProperty(ENABLE_VALIDATION));
            boolean responseValidation = Boolean.valueOf((String)context.getContextualProperty(ENABLE_RESPONSE_VALIDATION));
            if (validationEnabled || responseValidation) {
                m.setSchema(this.getValidationSchema(context, jc));
            }
            if (this.isAbstract()) {
                MessagePartInfo part = (MessagePartInfo)context.getProperty("currentMessagePart");
                object = new JAXBElement(part.getName(), this.getTypeClass(), object);
            }
            XMLStreamWriter xsw = ((ElementWriter)writer).getXMLStreamWriter();
            OutputStream os = (OutputStream)context.getOutMessage().getProperty("channel.outputstream");
            if (os != null && !(xsw instanceof DOMStreamWriter)) {
                xsw.writeCharacters("");
                xsw.flush();
                m.setProperty("jaxb.encoding", (Object)context.getOutMessage().getEncoding());
                m.marshal(object, os);
            } else {
                m.marshal(object, ((ElementWriter)writer).getXMLStreamWriter());
            }
        }
        catch (JAXBException e) {
            throw new XFireFault("Could not marshall type.", e, XFireFault.RECEIVER);
        }
        catch (XMLStreamException e) {
            throw new XFireFault("Could not marshall type.", e, XFireFault.RECEIVER);
        }
    }

    public synchronized JAXBContext getJAXBContext(MessageContext mc) throws JAXBException {
        if (this.context == null) {
            String pckg = this.getPackage(this.getTypeClass().getName());
            HashSet extraPackages = (HashSet)mc.getContextualProperty(SEARCH_PACKAGES);
            if (extraPackages == null) {
                extraPackages = new HashSet();
            }
            StringBuilder pckgs = new StringBuilder();
            HashSet pkgSet = new HashSet();
            pkgSet.addAll(extraPackages);
            pkgSet.add(pckg);
            boolean first = true;
            for (String p : pkgSet) {
                if (!first) {
                    pckgs.append(":");
                } else {
                    first = false;
                }
                pckgs.append(p);
            }
            pckg = pckgs.toString();
            this.context = JAXBContext.newInstance((String)pckg);
        }
        return this.context;
    }

    private String getPackage(String pckg) {
        int i = pckg.lastIndexOf(".");
        if (i != -1) {
            pckg = pckg.substring(0, i);
        }
        return pckg;
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public boolean isWriteOuter() {
        return false;
    }

    @Override
    public QName getSchemaType() {
        return super.getSchemaType();
    }

    public void initType() {
        Class clazz = this.getTypeClass();
        this.initType(clazz);
    }

    public void initType(Class<?> clazz) {
        this.actualTypeClass = clazz;
        XmlRootElement root = clazz.getAnnotation(XmlRootElement.class);
        XmlType type = clazz.getAnnotation(XmlType.class);
        String local = null;
        String nsUri = null;
        if (root != null) {
            this.setAbstract(false);
            local = root.name();
            nsUri = root.namespace();
        } else if (type != null) {
            this.setAbstract(true);
            local = type.name();
            nsUri = type.namespace();
        } else if (clazz.isAnnotationPresent(XmlEnum.class)) {
            this.setAbstract(true);
            local = clazz.getSimpleName();
            nsUri = "##default";
        } else {
            if (clazz.isAnnotationPresent(XmlJavaTypeAdapter.class)) {
                XmlJavaTypeAdapter xjta = clazz.getAnnotation(XmlJavaTypeAdapter.class);
                this.adapterClz = xjta.value();
                ParameterizedType genericSuperclass = (ParameterizedType)this.adapterClz.getGenericSuperclass();
                Class impl = (Class)genericSuperclass.getActualTypeArguments()[0];
                this.initType(impl);
                return;
            }
            throw new XFireRuntimeException("Couldn't determine element name.");
        }
        if (local.equals("##default")) {
            local = clazz.getSimpleName();
        }
        if (nsUri.equals("##default") || nsUri.equals("")) {
            nsUri = JaxbType.getPackageNs(clazz);
        }
        this.setSchemaType(new QName(nsUri, local));
    }

    public static String getPackageNs(Class clazz) {
        AnnotatedElement pack = clazz.getPackage();
        if (pack == null) {
            try {
                pack = Class.forName(clazz.getName().substring(0, clazz.getName().lastIndexOf(46)) + ".package-info", false, clazz.getClassLoader());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (pack == null) {
            throw new XFireRuntimeException("No package info found for class " + clazz.getName() + ". Cannot lookup default schema namespace");
        }
        XmlSchema schema = pack.getAnnotation(XmlSchema.class);
        String namespace = null;
        namespace = schema != null ? schema.namespace() : "";
        return namespace;
    }

    @Override
    public void writeSchema(Element root) {
    }

    public Class getActualTypeClass() {
        return this.actualTypeClass;
    }
}

