package org.eclipse.webdav.internal.kernel;

/*
 * (c) Copyright IBM Corp. 2000, 2001.
 * All Rights Reserved.
 */

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentMarshaler implements IDocumentMarshaler {

	public Document parse(Reader reader) throws IOException {
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder parser = factory.newDocumentBuilder();
			//	xmlParser.setProcessNamespace(true);
			return parser.parse(new InputSource(reader));
		} catch (ParserConfigurationException e) {
		} catch (SAXException e) {
		}
		return null;
	}

	public void print(Document document, Writer writer, String encoding)
		throws IOException {
		OutputFormat format = new OutputFormat();
		format.setEncoding(encoding);
		Serializer serializer =
			SerializerFactory.getSerializerFactory("xml").makeSerializer(writer, format);
		serializer.asDOMSerializer().serialize(document);
	}
}