#include "ticker_tape.h"
#include "viewwin.h"
#include "font.h"
#include "random.h"
#include "color.h"
#include "console.h"

using namespace std;

extern viewport view;

const string ticker_tape::message ("-^- Many thanks to our donors so far: Jack Coghill ($100), Set Hallstrom ($76.19), Samuel Chintha ($50), Aaron Wolf ($28.41), Artem Popov ($10), Sebastian Thewes ($10), Louigi Verona ($10), Edward Diehl ($5) & Guido Lang ($5).  To join this list of Donors, please click on Donate Now! -^-");

ticker_tape::ticker_tape () {
  show_text = 1;
  mr = 0.4; mg = 0.5; mb = 1;
  add_child (&toggle);
  toggle.set_listener (this);
}

void ticker_tape::clicked (button& b) {
  if (&b == &toggle) {
    toggle_text ();
  }
}

int ticker_tape::handle_input () {
  int ret = toggle.handle_input ();
  return ret;
}

void ticker_tape::toggle_text () {
  show_text = !show_text;
  const box<int>& e = toggle.get_extents ();
  if (show_text) {
    toggle.set_pos (0, e.bottom);
    toggle.set_label (">>>");
  } else {
    toggle.set_pos (view.xmax - e.width, e.bottom);
    toggle.set_label ("<<<");
  }
}

void ticker_tape::draw () {

  toggle.draw ();

  if (!show_text) return;

  static int drip = 0;
  if (++drip >= 4) {
    if (--startx < leftxt) startx = rightxt;
    drip = 0;
  }

  glViewport (twin.left, 0, twin.width, twin.height + dy);

  glMatrixMode (GL_MODELVIEW);
  glPushMatrix ();
  glLoadIdentity ();

  glMatrixMode (GL_PROJECTION);
  glPushMatrix ();
  glLoadIdentity ();
  glOrtho (twin.left, twin.right, twin.bottom - dy, twin.top, 1, -1);

  glColor3f (mr, mg, mb);

  draw_string (message, startx, twin.bottom);

  glPopMatrix ();
  glMatrixMode (GL_MODELVIEW);
  glPopMatrix ();

  extern viewport view;
  glViewport (0, 0, view.xmax, view.ymax);

}
