#include <stdio.h>
#include <stdlib.h>
#include <colorblind.h>
#include "_test.h"

void test_color(COLORBLIND_RUNTIME* runtime,
                int colorred, int colorgreen, int colorblue,
                int touch,
                int resultred, int resultgreen, int resultblue);

int main(int argc, char** argv) {
        printf("1..52\n");
        COLORBLIND_RUNTIME* runtime = colorblind_create();
        ok(runtime != NULL,"colorblind_create returns a valid pointer");

        ok(colorblind_set_filter_type(runtime,colorblind_filter_t_hue_shift_positive)==0,"Setting the filter");

        test_color(runtime, 0  ,0  ,255  ,1,  255, 0  ,0  );
        test_color(runtime, 87 ,10 ,50   ,1,  50 , 87 ,10 );
        test_color(runtime, 0  ,90 ,90   ,1,  90 , 0  ,90 );
        test_color(runtime, 80 ,80 ,255  ,1,  255, 80 ,80 );
        test_color(runtime, 80 ,80 ,20   ,1,  20 , 80 ,80 );
        test_color(runtime, 125,0  ,255  ,1,  255, 125,0  );
        test_color(runtime, 80 ,0  ,160  ,1,  160, 80 ,0  );
        test_color(runtime, 125,255,0    ,1,  0  , 125,255);
        test_color(runtime, 100,100,100  ,0,  100, 100,100);
        test_color(runtime, 0  ,80 ,80   ,1,  80 , 0  ,80 );
        test_color(runtime, 40 ,255,40   ,1,  40 , 40 ,255);
        test_color(runtime, 0  ,0  ,0    ,0,  0  , 0  ,0  );

        ok(colorblind_set_filter_type(runtime,colorblind_filter_t_hue_shift_negative)==0,"Setting the filter");

        test_color(runtime, 0  ,0  ,255  ,1,  0  ,255,0  );
        test_color(runtime, 87 ,10 ,50   ,1,  10 ,50 ,87 );
        test_color(runtime, 0  ,90 ,90   ,1,  90 ,90 ,0  );
        test_color(runtime, 80 ,80 ,255  ,1,  80 ,255,80 );
        test_color(runtime, 80 ,80 ,20   ,1,  80 ,20 ,80 );
        test_color(runtime, 125,0  ,255  ,1,  0  ,255,125);
        test_color(runtime, 80 ,0  ,160  ,1,  0  ,160,80 );
        test_color(runtime, 125,255,0    ,1,  255,0  ,125);
        test_color(runtime, 100,100,100  ,0,  100,100,100);
        test_color(runtime, 0  ,80 ,80   ,1,  80 ,80 ,0  );
        test_color(runtime, 40 ,255,40   ,1,  255,40 ,40 );
        test_color(runtime, 0  ,0  ,0    ,0,  0  ,0  ,0  );


        colorblind_destroy(runtime);
        ok(1,"destroyed");
        return 0;
}

