#!/bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULE=src/lib/perl5/COD/CIF/Tags/Manage.pm
#END DEPEND--------------------------------------------------------------------

IMPORT_MODULE=$(\
    echo ${INPUT_MODULE} | \
    perl -pe "s|^src/lib/perl5/||; s/[.]pm$//; s|/|::|g;" \
)

perl -M"${IMPORT_MODULE}" \
<<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2024-05-26 17:12:38 +0300 (Sun, 26 May 2024) $ 
#$Revision: 10066 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.10.0/tests/shtests/has_unknown_value_003.sh $
#------------------------------------------------------------------------------
#*
#* Unit test for the COD::CIF::Tags::Manage::has_unknown_value() subroutine.
#* Tests the way the subroutine behaves when the 'types' hash entry for
#* the data item is undefined.
#**
use strict;
use warnings;

# use COD::CIF::Tags::Manage;

my $data_block =
{
  'tags'   => [ '_value' ],
  'loops'  => [ ],
  'inloop' => {},
  'values' => { '_value' => [ '?' ] },
  'precisions' => {},
  'types' => {},
};

my $data_name   = '_value';

my $unknown = COD::CIF::Tags::Manage::has_unknown_value(
                $data_block,
                $data_name,
                0 );

print "Value is " .($unknown ? 'unknown' : 'known') . ".\n";

END_SCRIPT
