(*:Name: Contour *)

(* :Title: Contour *)

(* :Author: Tom Wickham-Jones*)

(* :Summary: *)

(* :Context: ExtendGraphics`Contour` *)

(* :Package Version: 1.0 *)

(* :Mathematica Version: 2.2 *)

(*:Summary:
	This package extends the contour plotting routines of Mathematica
	to work with irregularly spaced data.   It extends ListContourPlot
	and ContourGraphics and does not generate any new symbols.
*)

(* :History:
	Created summer 1993 by Tom Wickham-Jones.
	New version winter 1993 by Tom Wickham-Jones.

	This package is described in the book
	Mathematica Graphics: Techniques and Applications.
	Tom Wickham-Jones, TELOS/Springer-Verlag 1994.

*)

(*:Warnings:
	The package installs MathLink binarys contour and delaunay.
	If this fails the functions cannot possibly work.
	If the installation fails an error message is printed.
	In case of a failure make sure that the binary is built
	properly for your system.	
*)


BeginPackage[ "ExtendGraphics`Contour`",
				"ExtendGraphics`Delaunay`", 
				"Utilities`FilterOptions`"]


Begin["`Private`"]

Contour::fail = 
	"Installation of the MathLink binary contour failed.
	 The binary must be found for this package to work."


If[ Install[ "ExtendGraphics`contour`"] === $Failed,
		Message[ Delaunay::fail]]



Unprotect[ ListContourPlot, Graphics, Display, PlotRange]

ListContourPlot[ pts_List /; MatrixQ[ N[pts], NumberQ] && 
		       	     Length[ First[ pts]] === 3,
		 opts___ /; OptionQ[ {opts}]] :=
    Block[{tri},
    	tri = Delaunay[ N[ pts]] ;
	If[ tri =!= $Failed,
		ListContourPlot[ {N[pts], First[tri], Last[tri]}, opts]]
	]
			
			
ListContourPlot[ {
		  pts_List /; MatrixQ[ pts, NumberQ] && 
		       	      Length[ First[ pts]] === 3,
		  hull_ /; VectorQ[ hull, (Head[#] === Integer)&],
		  tri_ /; MatrixQ[  tri, (Head[#] === Integer)&]
		  }, opts___] :=
	(
	Show[ GraphicsFromContour[ {pts, hull, tri}, opts]] ;
	ContourGraphics[ 
		{pts, hull, tri}, 
		Join[ {opts}, Options[ ListContourPlot]]]
	)


GraphicsFromContour[ {pts_, hull_, tri_}, opts___] :=			  
    Block[{ conts, xrng, yrng, zrng, style,
	    lines, smooth, defs, opt, shade},
	defs = Options[ ListContourPlot] ;
	opt = Flatten[ {opts}] ;
	zrng = PlotRange /. opt /. defs ;
	zrng = Last[ FixPlotRange[ zrng, pts]] ;
	zrng = CheckZRange[ zrng] ;
	conts = N[ FixContours[ Contours /. opt /. defs, zrng]] ;
	smooth = ContourSmoothing /. opt /. defs ;
	smooth = If[ smooth === True, 1, 0] ;
	shade = ContourShading /. opt /. defs ;
	style = FixStyle[ ContourStyle /. opt /. defs, Length[ conts]] ;
	lines = ContourL[ pts, tri, hull, conts, smooth] ;
	lines = Map[ 
		  		Append[ Part[ style, #[[1]]], 
		  		Line[ #[[2]]]]&, lines] ;
	If[ shade, lines = Prepend[ Map[ {{}, #}&, lines], {}]] ;
	opt = Sequence @@ Join[ {opts}, defs] ;
	Graphics[ lines, 
	         FilterOptions[ Graphics, opt]]
	]


FixStyle[ Automatic, num_] := FixStyle[ Thickness[ 0.001], num]

FixStyle[ style_, num_] :=
	If[ ListQ[ style] && Length[ style] > 0 &&
	    ListQ[ First[ style]],
		Table[ First[ RotateLeft[ style, i-1]], {i,num}],
		If[ ListQ[ style], 
			Table[ style, {num}],
			Table[ {style}, {num}]]]

	
CheckZRange[ {z0_, z1_}] :=
	If[ z0 == z1,
		If[ z0 == 0,
			{-0.5, 0.5},
			{z0 - z0 0.5, z0 + z0 0.5}],
		{z0, z1}]


FixPlotRange[ rng_ /; 
		MatrixQ[ rng, NumberQ] &&
		Length[ First[ rng] == 2], 
	      pts_] := rng

FixPlotRange[ rng_, pts_] :=
    Block[{x0, x1, y0, y1, z0, z1, x, y, z},
    	{x, y, z} = Transpose[ pts] ;
	x0 = Min[ x] ;
	x1 = Max[ x] ;
	y0 = Min[ y] ;
	y1 = Max[ y] ;
	z0 = Min[ z] ;
	z1 = Max[ z] ;
	{{x0, x1}, {y0, y1}, {z0, z1}}
	]
    
FixContours[ conts_ /; VectorQ[ conts, NumberQ], zrng_] :=
	conts

FixContours[ conts_, {z0_, z1_}] :=
    	If[ Head[ conts] === Integer &&
	    conts > 0,
	    	     zinc = (z1 - z0)/ (conts + 1) ;
		     Table[ i, {i, z0+zinc, z1-zinc, zinc}]
	    	     (* else *) ,
		     FixContours[ 10, zrng]]
		     
	
PlotRange[ 	ContourGraphics[ {
			   pts_List /; 
				MatrixQ[ pts, NumberQ] && 
		       		Length[ First[ pts]] === 3,
			   hull_ /; VectorQ[ hull, (Head[#] === Integer)&],
			   tri_ /; MatrixQ[  tri, (Head[#] === Integer)&]
			  }, opts___]] :=
		FixPlotRange[ 
			PlotRange /. Flatten[ {opts}] /. Options[ ListContourPlot], 
			pts]


Display[ chan_,
	ContourGraphics[ {
			   pts_List /; 
				MatrixQ[ pts, NumberQ] && 
		       		Length[ First[ pts]] === 3,
			   hull_ /; VectorQ[ hull, (Head[#] === Integer)&],
			   tri_ /; MatrixQ[  tri, (Head[#] === Integer)&]
			  }, opts___]] :=
	ListContourPlot[ {pts, hull, tri}, 
		DisplayFunction -> (Display[ chan, #]&), opts]


Graphics[
	ContourGraphics[ {
			   pts_List /; 
				MatrixQ[ pts, NumberQ] && 
		       		Length[ First[ pts]] === 3,
			   hull_ /; VectorQ[ hull, (Head[#] === Integer)&],
			    tri_ /; MatrixQ[  tri, (Head[#] === Integer)&]
			  }, opts___]] :=
	GraphicsFromContour[ {pts, hull, tri}, opts]


Protect[ ListContourPlot, Graphics, Display, PlotRange]


End[]

EndPackage[]


(*


<<Contour.m


data = Table[ {x = 4 Random[] -2, y = 4 Random[] -2, Sqrt[ x^2 + y^2]},
		{100}];

ListContourPlot[ data, 
		Contours -> 4,
		ContourSmoothing -> False]

Show[ %, Contours -> 6]

Graphics[ %]


*)

