{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetMode: String;
    procedure SetMode(const Value: String);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdMode: TSFString;
    { Internal wrapper for property @link(Mode). This wrapper API may change, we advise to access simpler @link(Mode) instead. }
    public property FdMode: TSFString read FFdMode;
    {  }
    property Mode: String read GetMode write SetMode;

    strict private FFdParameter: TMFFloat;
    { Internal wrapper for property @link(Parameter). This wrapper API may change, we advise to access simpler @link(Parameter) instead. }
    public property FdParameter: TMFFloat read FFdParameter;
    {  }
    procedure SetParameter(const Value: array of Single); overload;
    {  }
    procedure SetParameter(const Value: TSingleList); overload;

    strict private FFdProjectedLight: TSFNode;
    { Internal wrapper for property @link(ProjectedLight). This wrapper API may change, we advise to access simpler @link(ProjectedLight) instead. }
    public property FdProjectedLight: TSFNode read FFdProjectedLight;

{$endif read_interface}

{$ifdef read_implementation}

{ TTextureCoordinateGeneratorNode ----------------------------------------------- }

function TTextureCoordinateGeneratorNode.GetMode: String;
begin
  Result := FdMode.Value;
end;

procedure TTextureCoordinateGeneratorNode.SetMode(const Value: String);
begin
  FdMode.Send(Value);
end;

procedure TTextureCoordinateGeneratorNode.SetParameter(const Value: array of Single);
begin
  FdParameter.Send(Value);
end;

procedure TTextureCoordinateGeneratorNode.SetParameter(const Value: TSingleList);
begin
  FdParameter.Send(Value);
end;

class function TTextureCoordinateGeneratorNode.ClassX3DType: String;
begin
  Result := 'TextureCoordinateGenerator';
end;

procedure TTextureCoordinateGeneratorNode.CreateNode;
begin
  inherited;

  FFdMode := TSFString.Create(Self, True, 'mode', 'SPHERE');
   FdMode.ChangeAlways := chTextureCoordinate;
  AddField(FFdMode);

  FFdParameter := TMFFloat.Create(Self, True, 'parameter', []);
   FdParameter.ChangeAlways := chTextureCoordinate;
  AddField(FFdParameter);

  FFdProjectedLight := TSFNode.Create(Self, True, 'projectedLight', [TSpotLightNode, TDirectionalLightNode, TSpotLightNode_1, TDirectionalLightNode_1]);
   FdProjectedLight.ChangeAlways := chTextureCoordinate;
  AddField(FFdProjectedLight);
end;

{$endif read_implementation}
