{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdFieldOfView: TMFFloat;
    { Internal wrapper for property @link(FieldOfView). This wrapper API may change, we advise to access simpler @link(FieldOfView) instead. }
    public property FdFieldOfView: TMFFloat read FFdFieldOfView;
    {  }
    procedure SetFieldOfView(const Value: array of Single); overload;
    {  }
    procedure SetFieldOfView(const Value: TSingleList); overload;

    strict private FFdPosition: TSFVec3f;
    { Internal wrapper for property @link(Position). This wrapper API may change, we advise to access simpler @link(Position) instead. }
    public property FdPosition: TSFVec3f read FFdPosition;

{$endif read_interface}

{$ifdef read_implementation}

{ TOrthoViewpointNode ----------------------------------------------- }

procedure TOrthoViewpointNode.SetFieldOfView(const Value: array of Single);
begin
  FdFieldOfView.Send(Value);
end;

procedure TOrthoViewpointNode.SetFieldOfView(const Value: TSingleList);
begin
  FdFieldOfView.Send(Value);
end;

class function TOrthoViewpointNode.ClassX3DType: String;
begin
  Result := 'OrthoViewpoint';
end;

procedure TOrthoViewpointNode.CreateNode;
begin
  inherited;

  FFdFieldOfView := TMFFloat.Create(Self, True, 'fieldOfView', [-1, -1, 1, 1]);
   FdFieldOfView.ChangeAlways := chViewpointProjection;
  AddField(FFdFieldOfView);

  FFdPosition := TSFVec3f.Create(Self, True, 'position', Vector3(0, 0, 10));
   FdPosition.ChangeAlways := chViewpointVectors;
  AddField(FFdPosition);
end;

{$endif read_implementation}
