{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FEventSet_destination: TMFVec3fEvent;
    {  }
    public property EventSet_destination: TMFVec3fEvent read FEventSet_destination;

    strict private FEventSet_value: TMFVec3fEvent;
    {  }
    public property EventSet_value: TMFVec3fEvent read FEventSet_value;

    strict private FEventValue_changed: TMFVec3fEvent;
    {  }
    public property EventValue_changed: TMFVec3fEvent read FEventValue_changed;

    strict private FFdInitialDestination: TMFVec3f;
    { Internal wrapper for property @link(InitialDestination). This wrapper API may change, we advise to access simpler @link(InitialDestination) instead. }
    public property FdInitialDestination: TMFVec3f read FFdInitialDestination;
    {  }
    procedure SetInitialDestination(const Value: array of TVector3); overload;
    {  }
    procedure SetInitialDestination(const Value: TVector3List); overload;

    strict private FFdInitialValue: TMFVec3f;
    { Internal wrapper for property @link(InitialValue). This wrapper API may change, we advise to access simpler @link(InitialValue) instead. }
    public property FdInitialValue: TMFVec3f read FFdInitialValue;
    {  }
    procedure SetInitialValue(const Value: array of TVector3); overload;
    {  }
    procedure SetInitialValue(const Value: TVector3List); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TCoordinateDamperNode ----------------------------------------------- }

procedure TCoordinateDamperNode.SetInitialDestination(const Value: array of TVector3);
begin
  FdInitialDestination.Send(Value);
end;

procedure TCoordinateDamperNode.SetInitialDestination(const Value: TVector3List);
begin
  FdInitialDestination.Send(Value);
end;

procedure TCoordinateDamperNode.SetInitialValue(const Value: array of TVector3);
begin
  FdInitialValue.Send(Value);
end;

procedure TCoordinateDamperNode.SetInitialValue(const Value: TVector3List);
begin
  FdInitialValue.Send(Value);
end;

class function TCoordinateDamperNode.ClassX3DType: String;
begin
  Result := 'CoordinateDamper';
end;

procedure TCoordinateDamperNode.CreateNode;
begin
  inherited;

  FEventSet_destination := TMFVec3fEvent.Create(Self, 'set_destination', true);
  AddEvent(FEventSet_destination);

  FEventSet_value := TMFVec3fEvent.Create(Self, 'set_value', true);
  AddEvent(FEventSet_value);

  FEventValue_changed := TMFVec3fEvent.Create(Self, 'value_changed', false);
  AddEvent(FEventValue_changed);

  FFdInitialDestination := TMFVec3f.Create(Self, False, 'initialDestination', [Vector3(0, 0, 0)]);
   FdInitialDestination.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdInitialDestination);

  FFdInitialValue := TMFVec3f.Create(Self, False, 'initialValue', [Vector3(0, 0, 0)]);
   FdInitialValue.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdInitialValue);
end;

{$endif read_implementation}
