{ -*- buffer-read-only: t -*-

  Copyright 2018-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated wrapper to make vectors/colors persistent.

  Do not edit this file manually!
  Instead
  - edit tools/internal/generate-persistent-vectors/persistent_vectors_input.txt
  - and run generate-persistent-vectors in that directory.
}

{$ifdef read_interface_class}
strict private
  FSizePersistent: TCastleVector2Persistent;
  function GetSizeForPersistent: TVector2;
  procedure SetSizeForPersistent(const AValue: TVector2);
published
  { @link(Size) that can be visually edited in
    Castle Game Engine Editor, Lazarus and Delphi.
    Normal user code does not need to deal with this,
    instead read or write @link(Size) directly.

    @seealso Size }
  property SizePersistent: TCastleVector2Persistent read FSizePersistent ;
{$endif read_interface_class}

{$ifdef read_implementation_methods}
function TCastleTerrain.GetSizeForPersistent: TVector2;
begin
  Result := Size;
end;

procedure TCastleTerrain.SetSizeForPersistent(const AValue: TVector2);
begin
  Size := AValue;
end;
{$endif read_implementation_methods}

{$ifdef read_implementation_constructor}
  FSizePersistent := TCastleVector2Persistent.Create;
  FSizePersistent.InternalGetValue := {$ifdef FPC}@{$endif}GetSizeForPersistent;
  FSizePersistent.InternalSetValue := {$ifdef FPC}@{$endif}SetSizeForPersistent;
  FSizePersistent.InternalDefaultValue := Size; // current value is default
{$endif read_implementation_constructor}

{$ifdef read_implementation_destructor}
  FreeAndNil(FSizePersistent);
{$endif read_implementation_destructor}

{ -*- buffer-read-only: t -*-

  Copyright 2018-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated wrapper to make vectors/colors persistent.

  Do not edit this file manually!
  Instead
  - edit tools/internal/generate-persistent-vectors/persistent_vectors_input.txt
  - and run generate-persistent-vectors in that directory.
}

{$ifdef read_interface_class}
strict private
  FSubdivisionsPersistent: TCastleVector2Persistent;
  function GetSubdivisionsForPersistent: TVector2;
  procedure SetSubdivisionsForPersistent(const AValue: TVector2);
published
  { @link(Subdivisions) that can be visually edited in
    Castle Game Engine Editor, Lazarus and Delphi.
    Normal user code does not need to deal with this,
    instead read or write @link(Subdivisions) directly.

    @seealso Subdivisions }
  property SubdivisionsPersistent: TCastleVector2Persistent read FSubdivisionsPersistent ;
{$endif read_interface_class}

{$ifdef read_implementation_methods}
function TCastleTerrain.GetSubdivisionsForPersistent: TVector2;
begin
  Result := Subdivisions;
end;

procedure TCastleTerrain.SetSubdivisionsForPersistent(const AValue: TVector2);
begin
  Subdivisions := AValue;
end;
{$endif read_implementation_methods}

{$ifdef read_implementation_constructor}
  FSubdivisionsPersistent := TCastleVector2Persistent.Create;
  FSubdivisionsPersistent.InternalGetValue := {$ifdef FPC}@{$endif}GetSubdivisionsForPersistent;
  FSubdivisionsPersistent.InternalSetValue := {$ifdef FPC}@{$endif}SetSubdivisionsForPersistent;
  FSubdivisionsPersistent.InternalDefaultValue := Subdivisions; // current value is default
{$endif read_implementation_constructor}

{$ifdef read_implementation_destructor}
  FreeAndNil(FSubdivisionsPersistent);
{$endif read_implementation_destructor}

