# -*- coding: utf-8 -*-
# Balazar in the Rancid Skull Dungeon
# Copyright (C) 2008 Jean-Baptiste LAMY
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys, os, os.path, atexit
import soya, soya.gui as gui

import balazar3.globdef as globdef
import balazar3.game    as game
    


MENU = None
class Menu(gui.Window):
  def __init__(self, title):
    gui.Window.__init__(self, None, title, 0)
    self.table = gui.VTable(self)
    
  def show(self):
    global MENU
    if MENU: MENU.parent.remove(MENU)
    MENU = self
    soya.root_widget.add(self)
    
  def allocate(self, x, y, width, height):
    gui.Window.allocate(self, x, y, width, height)
    
    (0.2 * soya.get_screen_width ())
    
    self.move(
      (int(0.6  * soya.get_screen_width () - self.width  // 2)),
      (int(0.70 * soya.get_screen_height() - self.height // 2)),
      )

class Input(gui.Input):
  def __init__(self, parent, var):
    gui.Input.__init__(self, parent, unicode(getattr(globdef, var)))
    self.var = var

  def on_text_changed(self):
    if isinstance(self.text, unicode): text = self.text.encode("latin")
    else:                              text = self.text
    setattr(globdef, self.var, text)
    
class IntInput(gui.Input):
  def __init__(self, parent, var):
    gui.Input.__init__(self, parent, unicode(getattr(globdef, var)))
    self.var = var
    
  def on_text_changed(self):
    try: setattr(globdef, self.var, int(self.text))
    except: pass
    
class Toggle(gui.CheckBox):
  def __init__(self, parent, text, var):
    gui.CheckBox.__init__(self, parent, text, getattr(globdef, var))
    self.var = var
    
  def on_value_changed(self): setattr(globdef, self.var, self.value)


def message(text):
  global MENU
  MENU = Menu([
    MenuAction(text, lambda : None),
    MenuAction(_(u"Back"), main_menu),
    ])



  
  
def main_menu():
  if game.SERVER_PID: server_menu_text = _(u"Local server... (server is running)")
  else:               server_menu_text = _(u"Local server...")
  menu = Menu(_(u"Balazar III"))
  gui.Button(menu.table, _(u"Start single-player game..."), single_menu)
  gui.Button(menu.table, _(u"Join multi-player game..."), multi_menu)
  gui.Button(menu.table, server_menu_text, server_menu)
  gui.Button(menu.table, _(u"Preferences..."), preference_menu)
  gui.CancelButton(menu.table, _(u"Exit"), sys.exit)
  menu.show()
  
def single_menu():
  menu = Menu(_(u"Start single-player game..."))
  if os.path.exists(os.path.join(globdef.SAVED_GAME_DIR, globdef.SINGLE_LOGIN)):
    gui.Button(menu.table, _(u"Reload %s") % globdef.SINGLE_LOGIN, lambda: _start_single(globdef.SINGLE_LOGIN))
  gui.Button(menu.table, _(u"New game..."), new_single_menu)
  gui.Button(menu.table, _(u"Load..."), load_menu)
  gui.CancelButton(menu.table, _(u"Back"), main_menu)
  menu.show()

  
def load_menu(start_at = 0):
  if os.path.exists(globdef.SAVED_GAME_DIR): player_names = [dirname for dirname in os.listdir(globdef.SAVED_GAME_DIR) if dirname != "_server"]
  else:                                      player_names = []
  player_names.sort()
  
  menu = Menu(_(u"Load..."))
  list = gui.VList(gui.ScrollPane(menu.table))
  for player_name in player_names:
    gui.Label(list, player_name)
    
  gui.Button(menu.table, _(u"Load"), lambda : _start_single(player_name))
  gui.CancelButton(menu.table, _(u"Back"), main_menu)
  menu.show()

 
def new_single_menu():
  if os.path.exists(globdef.SAVED_GAME_DIR): player_names = [dirname for dirname in os.listdir(globdef.SAVED_GAME_DIR) if dirname != "_server"]
  else:                                      player_names = []
  try:
    import getpass
    globdef.SINGLE_LOGIN = base_login = getpass.getuser()
  except:
    globdef.SINGLE_LOGIN = base_login = "Player"
    
  i = 1
  while globdef.SINGLE_LOGIN in player_names:
    i += 1
    globdef.SINGLE_LOGIN = "%s%s" % (base_login, i)
    
  menu = Menu(_(u"New game..."))
  gui.Button(menu.table, _(u"Create"), lambda: _start_single(globdef.SINGLE_LOGIN))
  htable = gui.HTable(menu.table); gui.Label(htable, _(u"Player name:")); Input(htable, "SINGLE_LOGIN")
  gui.CancelButton(menu.table, _(u"Back"), main_menu)
  menu.show()
  
def multi_menu():
  menu = Menu(_(u"Join multi-player game..."))
  gui.Button(menu.table, _(u"Join"), _start_multi)
  htable = gui.Table(menu.table, 2, 4);
  gui.Label(htable, _(u"Player name:")); Input(htable, "CLIENT_LOGIN")
  gui.Label(htable, _(u"Password:"   )); Input(htable, "CLIENT_PASSWORD")
  if not game.SERVER_PID:
    gui.Label(htable, _(u"Host:")); Input   (htable, "CLIENT_HOST")
    gui.Label(htable, _(u"Port:")); IntInput(htable, "CLIENT_PORT")
  gui.CancelButton(menu.table, _(u"Back"), main_menu)
  menu.show()
  
def server_menu():
  def toggle_server():
    if game.SERVER_PID: game.kill_server()
    else:               game.start_server_spawn()
    set_button_text()
  def set_button_text():
    if game.SERVER_PID: button.text = _(u"Stop server (server is running)")
    else:               button.text = _(u"Start server")
    
  menu = Menu(_(u"Local server..."))
  button = gui.Button(menu.table, u"", toggle_server); set_button_text()
  htable = gui.Table(menu.table, 2, 2);
  gui.Label(htable, _(u"Host:")); Input   (htable, "SERVER_HOST")
  gui.Label(htable, _(u"Port:")); IntInput(htable, "SERVER_PORT")
  gui.Button(menu.table, _(u"Erase server data"), game.erase_server_data)
  gui.CancelButton(menu.table, _(u"Back"), main_menu)
  menu.show()
  
def preference_menu():
  menu = Menu(_(u"Preferences..."))
  gui.Label(menu.table, _(u"Save dir:"))
  Input (menu.table, "SAVED_GAME_DIR")
  #Toggle(menu.table, _(u"Fullscreen"), "FULLSCREEN")
  
  table = gui.Table(menu.table, 2, 5)
  gui.Label(table, _(u"Fullscreen:"))
  Toggle(table, u"", "FULLSCREEN")
  gui.Label(table, _(u"Graphics' quality:"))
  list = gui.HList(table)
  gui.Label(list, _(u"Low"))
  gui.Label(list, _(u"Medium"))
  gui.Label(list, _(u"High"))
  list.set_value(globdef.QUALITY)
  list.on_value_changed = lambda : setattr(globdef, "QUALITY", list.value)
  
  resolutions = [(640, 480), (800, 600), (1024, 768), (1152, 864), (1280, 1024), (1400, 1050), (1600, 1200), (2048, 1536), (2560, 2048),
                 (800, 480), (1024, 600), (1280, 720), (1366, 768), (1440, 900), (1600, 1024), (1680, 1050), (1920, 1080), (1920, 1200)]
  gui.Label(table, _(u"Resolution:"))
  list2 = gui.VList(gui.ScrollPane(table))
  for w, h in resolutions:
    gui.Label(list2, "%sx%s" % (w, h))
  try: list2.set_value(resolutions.index((globdef.SCREEN_WIDTH, globdef.SCREEN_HEIGHT)))
  except: pass
  def on_value_changed():
    setattr(globdef, "SCREEN_WIDTH" , resolutions[list2.value][0])
    setattr(globdef, "SCREEN_HEIGHT", resolutions[list2.value][1])
  list2.on_value_changed = on_value_changed
  
  sounds = [0.0, 0.2, 0.4, 0.6, 0.8, 1.0]
  gui.Label(table, _(u"Sound volume:"))
  list3 = gui.HList(table)
  for i in sounds:
    gui.Label(list3, "%s%%" % int(i * 100))
  list3.set_value(int((globdef.SOUND_VOLUME + 0.1) // 0.2))
  def on_value_changed():
    setattr(globdef, "SOUND_VOLUME" , sounds[list3.value])
  list3.on_value_changed = on_value_changed

  gui.Label(table, _(u"Music:"))
  Toggle(table, u"", "MUSIC")
  
  gui.CancelButton(menu.table, _(u"Exit (you need to restart the game)"), sys.exit)
  menu.show()

import balazar3.tofu as tofu
import balazar3.game 

def _start_single(player_name):
  globdef.SINGLE_LOGIN = player_name
  MAIN_LOOP.stop(game.start_single)

def _start_multi():
  MAIN_LOOP.stop(game.start_multi)

atexit.register(globdef.save_config)

MAIN_LOOP = None
def start():
  global MAIN_LOOP, MENU
  MAIN_LOOP = soya.MainLoop()
  
  root       = gui.RootLayer(None)
  background = gui.Image(root, soya.Material.get("titre"))
  
  while 1:
    soya.set_root_widget(root)
    main_menu()
    next = MAIN_LOOP.main_loop()
    if not next: break
    next()
  
  
