/* Copyright (c) 2009  Dmitry Xmelkov
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
   * Neither the name of the copyright holders nor the names of
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
 */

/* Test of cbrt() function: args pow(2,N) with all integer N.
   $Id$	*/

#define	ULPMAX	1	/* max possible error in units at last position	*/

#include <math.h>
#include <stdlib.h>
#include "progmem.h"

#ifndef	__AVR__
# include <stdio.h>
# define PRINTFLN(fmt, ...)	\
    printf ("\nLine %d: " fmt "\n", __LINE__, ##__VA_ARGS__)
# define EXIT(code)	exit ((code) < 255 ? (code) : 100 + (code) % 100)
#else
# define PRINTFLN(args...)
# define EXIT	exit
#endif

union float_u {
    unsigned long u32;
    float flt;
};

/* Result is placed into SRAM variable, allocated at the start of
   memory. This is convinient to debug: read a core dump.	*/
volatile union float_u v = {.u32 = 1};

PROGMEM const struct {
    unsigned long x;
    unsigned long z;
} t[] = {

    /* x, cbrt(x)	*/
    { 0x00000001,0x26a14518 },  /*   1:  1.4012985e-45  1.1190347e-15 */
    { 0x00000002,0x26cb2ff5 },  /*   2:  2.8025969e-45  1.4098954e-15 */
    { 0x00000004,0x27000000 },  /*   3:  5.6051939e-45  1.7763568e-15 */
    { 0x00000008,0x27214518 },  /*   4:  1.1210388e-44  2.2380694e-15 */
    { 0x00000010,0x274b2ff5 },  /*   5:  2.2420775e-44  2.8197907e-15 */
    { 0x00000020,0x27800000 },  /*   6:  4.4841551e-44  3.5527137e-15 */
    { 0x00000040,0x27a14518 },  /*   7:  8.9683102e-44  4.4761387e-15 */
    { 0x00000080,0x27cb2ff5 },  /*   8:  1.7936620e-43  5.6395814e-15 */
    { 0x00000100,0x28000000 },  /*   9:  3.5873241e-43  7.1054274e-15 */
    { 0x00000200,0x28214518 },  /*  10:  7.1746481e-43  8.9522775e-15 */
    { 0x00000400,0x284b2ff5 },  /*  11:  1.4349296e-42  1.1279163e-14 */
    { 0x00000800,0x28800000 },  /*  12:  2.8698593e-42  1.4210855e-14 */
    { 0x00001000,0x28a14518 },  /*  13:  5.7397185e-42  1.7904555e-14 */
    { 0x00002000,0x28cb2ff5 },  /*  14:  1.1479437e-41  2.2558326e-14 */
    { 0x00004000,0x29000000 },  /*  15:  2.2958874e-41  2.8421709e-14 */
    { 0x00008000,0x29214518 },  /*  16:  4.5917748e-41  3.5809110e-14 */
    { 0x00010000,0x294b2ff5 },  /*  17:  9.1835496e-41  4.5116651e-14 */
    { 0x00020000,0x29800000 },  /*  18:  1.8367099e-40  5.6843419e-14 */
    { 0x00040000,0x29a14518 },  /*  19:  3.6734198e-40  7.1618220e-14 */
    { 0x00080000,0x29cb2ff5 },  /*  20:  7.3468397e-40  9.0233303e-14 */
    { 0x00100000,0x2a000000 },  /*  21:  1.4693679e-39  1.1368684e-13 */
    { 0x00200000,0x2a214518 },  /*  22:  2.9387359e-39  1.4323644e-13 */
    { 0x00400000,0x2a4b2ff5 },  /*  23:  5.8774718e-39  1.8046661e-13 */
    { 0x00800000,0x2a800000 },  /*  24:  1.1754944e-38  2.2737368e-13 */
    { 0x01000000,0x2aa14518 },  /*  25:  2.3509887e-38  2.8647288e-13 */
    { 0x01800000,0x2acb2ff5 },  /*  26:  4.7019774e-38  3.6093321e-13 */
    { 0x02000000,0x2b000000 },  /*  27:  9.4039548e-38  4.5474735e-13 */
    { 0x02800000,0x2b214518 },  /*  28:  1.8807910e-37  5.7294576e-13 */
    { 0x03000000,0x2b4b2ff5 },  /*  29:  3.7615819e-37  7.2186642e-13 */
    { 0x03800000,0x2b800000 },  /*  30:  7.5231638e-37  9.0949470e-13 */
    { 0x04000000,0x2ba14518 },  /*  31:  1.5046328e-36  1.1458915e-12 */
    { 0x04800000,0x2bcb2ff5 },  /*  32:  3.0092655e-36  1.4437328e-12 */
    { 0x05000000,0x2c000000 },  /*  33:  6.0185311e-36  1.8189894e-12 */
    { 0x05800000,0x2c214518 },  /*  34:  1.2037062e-35  2.2917830e-12 */
    { 0x06000000,0x2c4b2ff5 },  /*  35:  2.4074124e-35  2.8874657e-12 */
    { 0x06800000,0x2c800000 },  /*  36:  4.8148249e-35  3.6379788e-12 */
    { 0x07000000,0x2ca14518 },  /*  37:  9.6296497e-35  4.5835661e-12 */
    { 0x07800000,0x2ccb2ff5 },  /*  38:  1.9259299e-34  5.7749314e-12 */
    { 0x08000000,0x2d000000 },  /*  39:  3.8518599e-34  7.2759576e-12 */
    { 0x08800000,0x2d214518 },  /*  40:  7.7037198e-34  9.1671322e-12 */
    { 0x09000000,0x2d4b2ff5 },  /*  41:  1.5407440e-33  1.1549863e-11 */
    { 0x09800000,0x2d800000 },  /*  42:  3.0814879e-33  1.4551915e-11 */
    { 0x0a000000,0x2da14518 },  /*  43:  6.1629758e-33  1.8334264e-11 */
    { 0x0a800000,0x2dcb2ff5 },  /*  44:  1.2325952e-32  2.3099726e-11 */
    { 0x0b000000,0x2e000000 },  /*  45:  2.4651903e-32  2.9103830e-11 */
    { 0x0b800000,0x2e214518 },  /*  46:  4.9303807e-32  3.6668529e-11 */
    { 0x0c000000,0x2e4b2ff5 },  /*  47:  9.8607613e-32  4.6199451e-11 */
    { 0x0c800000,0x2e800000 },  /*  48:  1.9721523e-31  5.8207661e-11 */
    { 0x0d000000,0x2ea14518 },  /*  49:  3.9443045e-31  7.3337057e-11 */
    { 0x0d800000,0x2ecb2ff5 },  /*  50:  7.8886091e-31  9.2398902e-11 */
    { 0x0e000000,0x2f000000 },  /*  51:  1.5777218e-30  1.1641532e-10 */
    { 0x0e800000,0x2f214518 },  /*  52:  3.1554436e-30  1.4667411e-10 */
    { 0x0f000000,0x2f4b2ff5 },  /*  53:  6.3108872e-30  1.8479780e-10 */
    { 0x0f800000,0x2f800000 },  /*  54:  1.2621774e-29  2.3283064e-10 */
    { 0x10000000,0x2fa14518 },  /*  55:  2.5243549e-29  2.9334823e-10 */
    { 0x10800000,0x2fcb2ff5 },  /*  56:  5.0487098e-29  3.6959561e-10 */
    { 0x11000000,0x30000000 },  /*  57:  1.0097420e-28  4.6566129e-10 */
    { 0x11800000,0x30214518 },  /*  58:  2.0194839e-28  5.8669646e-10 */
    { 0x12000000,0x304b2ff5 },  /*  59:  4.0389678e-28  7.3919122e-10 */
    { 0x12800000,0x30800000 },  /*  60:  8.0779357e-28  9.3132257e-10 */
    { 0x13000000,0x30a14518 },  /*  61:  1.6155871e-27  1.1733929e-09 */
    { 0x13800000,0x30cb2ff5 },  /*  62:  3.2311743e-27  1.4783824e-09 */
    { 0x14000000,0x31000000 },  /*  63:  6.4623485e-27  1.8626451e-09 */
    { 0x14800000,0x31214518 },  /*  64:  1.2924697e-26  2.3467858e-09 */
    { 0x15000000,0x314b2ff5 },  /*  65:  2.5849394e-26  2.9567649e-09 */
    { 0x15800000,0x31800000 },  /*  66:  5.1698788e-26  3.7252903e-09 */
    { 0x16000000,0x31a14518 },  /*  67:  1.0339758e-25  4.6935717e-09 */
    { 0x16800000,0x31cb2ff5 },  /*  68:  2.0679515e-25  5.9135297e-09 */
    { 0x17000000,0x32000000 },  /*  69:  4.1359031e-25  7.4505806e-09 */
    { 0x17800000,0x32214518 },  /*  70:  8.2718061e-25  9.3871433e-09 */
    { 0x18000000,0x324b2ff5 },  /*  71:  1.6543612e-24  1.1827059e-08 */
    { 0x18800000,0x32800000 },  /*  72:  3.3087225e-24  1.4901161e-08 */
    { 0x19000000,0x32a14518 },  /*  73:  6.6174449e-24  1.8774287e-08 */
    { 0x19800000,0x32cb2ff5 },  /*  74:  1.3234890e-23  2.3654119e-08 */
    { 0x1a000000,0x33000000 },  /*  75:  2.6469780e-23  2.9802322e-08 */
    { 0x1a800000,0x33214518 },  /*  76:  5.2939559e-23  3.7548573e-08 */
    { 0x1b000000,0x334b2ff5 },  /*  77:  1.0587912e-22  4.7308238e-08 */
    { 0x1b800000,0x33800000 },  /*  78:  2.1175824e-22  5.9604645e-08 */
    { 0x1c000000,0x33a14518 },  /*  79:  4.2351647e-22  7.5097147e-08 */
    { 0x1c800000,0x33cb2ff5 },  /*  80:  8.4703295e-22  9.4616476e-08 */
    { 0x1d000000,0x34000000 },  /*  81:  1.6940659e-21  1.1920929e-07 */
    { 0x1d800000,0x34214518 },  /*  82:  3.3881318e-21  1.5019429e-07 */
    { 0x1e000000,0x344b2ff5 },  /*  83:  6.7762636e-21  1.8923295e-07 */
    { 0x1e800000,0x34800000 },  /*  84:  1.3552527e-20  2.3841858e-07 */
    { 0x1f000000,0x34a14518 },  /*  85:  2.7105054e-20  3.0038859e-07 */
    { 0x1f800000,0x34cb2ff5 },  /*  86:  5.4210109e-20  3.7846590e-07 */
    { 0x20000000,0x35000000 },  /*  87:  1.0842022e-19  4.7683716e-07 */
    { 0x20800000,0x35214518 },  /*  88:  2.1684043e-19  6.0077717e-07 */
    { 0x21000000,0x354b2ff5 },  /*  89:  4.3368087e-19  7.5693181e-07 */
    { 0x21800000,0x35800000 },  /*  90:  8.6736174e-19  9.5367432e-07 */
    { 0x22000000,0x35a14518 },  /*  91:  1.7347235e-18  1.2015543e-06 */
    { 0x22800000,0x35cb2ff5 },  /*  92:  3.4694470e-18  1.5138636e-06 */
    { 0x23000000,0x36000000 },  /*  93:  6.9388939e-18  1.9073486e-06 */
    { 0x23800000,0x36214518 },  /*  94:  1.3877788e-17  2.4031087e-06 */
    { 0x24000000,0x364b2ff5 },  /*  95:  2.7755576e-17  3.0277272e-06 */
    { 0x24800000,0x36800000 },  /*  96:  5.5511151e-17  3.8146973e-06 */
    { 0x25000000,0x36a14518 },  /*  97:  1.1102230e-16  4.8062174e-06 */
    { 0x25800000,0x36cb2ff5 },  /*  98:  2.2204460e-16  6.0554545e-06 */
    { 0x26000000,0x37000000 },  /*  99:  4.4408921e-16  7.6293945e-06 */
    { 0x26800000,0x37214518 },  /* 100:  8.8817842e-16  9.6124348e-06 */
    { 0x27000000,0x374b2ff5 },  /* 101:  1.7763568e-15  1.2110909e-05 */
    { 0x27800000,0x37800000 },  /* 102:  3.5527137e-15  1.5258789e-05 */
    { 0x28000000,0x37a14518 },  /* 103:  7.1054274e-15  1.9224870e-05 */
    { 0x28800000,0x37cb2ff5 },  /* 104:  1.4210855e-14  2.4221818e-05 */
    { 0x29000000,0x38000000 },  /* 105:  2.8421709e-14  3.0517578e-05 */
    { 0x29800000,0x38214518 },  /* 106:  5.6843419e-14  3.8449739e-05 */
    { 0x2a000000,0x384b2ff5 },  /* 107:  1.1368684e-13  4.8443636e-05 */
    { 0x2a800000,0x38800000 },  /* 108:  2.2737368e-13  6.1035156e-05 */
    { 0x2b000000,0x38a14518 },  /* 109:  4.5474735e-13  7.6899478e-05 */
    { 0x2b800000,0x38cb2ff5 },  /* 110:  9.0949470e-13  9.6887271e-05 */
    { 0x2c000000,0x39000000 },  /* 111:  1.8189894e-12  1.2207031e-04 */
    { 0x2c800000,0x39214518 },  /* 112:  3.6379788e-12  1.5379896e-04 */
    { 0x2d000000,0x394b2ff5 },  /* 113:  7.2759576e-12  1.9377454e-04 */
    { 0x2d800000,0x39800000 },  /* 114:  1.4551915e-11  2.4414062e-04 */
    { 0x2e000000,0x39a14518 },  /* 115:  2.9103830e-11  3.0759791e-04 */
    { 0x2e800000,0x39cb2ff5 },  /* 116:  5.8207661e-11  3.8754908e-04 */
    { 0x2f000000,0x3a000000 },  /* 117:  1.1641532e-10  4.8828125e-04 */
    { 0x2f800000,0x3a214518 },  /* 118:  2.3283064e-10  6.1519583e-04 */
    { 0x30000000,0x3a4b2ff5 },  /* 119:  4.6566129e-10  7.7509817e-04 */
    { 0x30800000,0x3a800000 },  /* 120:  9.3132257e-10  9.7656250e-04 */
    { 0x31000000,0x3aa14518 },  /* 121:  1.8626451e-09  1.2303917e-03 */
    { 0x31800000,0x3acb2ff5 },  /* 122:  3.7252903e-09  1.5501963e-03 */
    { 0x32000000,0x3b000000 },  /* 123:  7.4505806e-09  1.9531250e-03 */
    { 0x32800000,0x3b214518 },  /* 124:  1.4901161e-08  2.4607833e-03 */
    { 0x33000000,0x3b4b2ff5 },  /* 125:  2.9802322e-08  3.1003927e-03 */
    { 0x33800000,0x3b800000 },  /* 126:  5.9604645e-08  3.9062500e-03 */
    { 0x34000000,0x3ba14518 },  /* 127:  1.1920929e-07  4.9215666e-03 */
    { 0x34800000,0x3bcb2ff5 },  /* 128:  2.3841858e-07  6.2007854e-03 */
    { 0x35000000,0x3c000000 },  /* 129:  4.7683716e-07  7.8125000e-03 */
    { 0x35800000,0x3c214518 },  /* 130:  9.5367432e-07  9.8431332e-03 */
    { 0x36000000,0x3c4b2ff5 },  /* 131:  1.9073486e-06  1.2401571e-02 */
    { 0x36800000,0x3c800000 },  /* 132:  3.8146973e-06  1.5625000e-02 */
    { 0x37000000,0x3ca14518 },  /* 133:  7.6293945e-06  1.9686266e-02 */
    { 0x37800000,0x3ccb2ff5 },  /* 134:  1.5258789e-05  2.4803141e-02 */
    { 0x38000000,0x3d000000 },  /* 135:  3.0517578e-05  3.1250000e-02 */
    { 0x38800000,0x3d214518 },  /* 136:  6.1035156e-05  3.9372533e-02 */
    { 0x39000000,0x3d4b2ff5 },  /* 137:  1.2207031e-04  4.9606283e-02 */
    { 0x39800000,0x3d800000 },  /* 138:  2.4414062e-04  6.2500000e-02 */
    { 0x3a000000,0x3da14518 },  /* 139:  4.8828125e-04  7.8745066e-02 */
    { 0x3a800000,0x3dcb2ff5 },  /* 140:  9.7656250e-04  9.9212566e-02 */
    { 0x3b000000,0x3e000000 },  /* 141:  1.9531250e-03  1.2500000e-01 */
    { 0x3b800000,0x3e214518 },  /* 142:  3.9062500e-03  1.5749013e-01 */
    { 0x3c000000,0x3e4b2ff5 },  /* 143:  7.8125000e-03  1.9842513e-01 */
    { 0x3c800000,0x3e800000 },  /* 144:  1.5625000e-02  2.5000000e-01 */
    { 0x3d000000,0x3ea14518 },  /* 145:  3.1250000e-02  3.1498026e-01 */
    { 0x3d800000,0x3ecb2ff5 },  /* 146:  6.2500000e-02  3.9685026e-01 */
    { 0x3e000000,0x3f000000 },  /* 147:  1.2500000e-01  5.0000000e-01 */
    { 0x3e800000,0x3f214518 },  /* 148:  2.5000000e-01  6.2996052e-01 */
    { 0x3f000000,0x3f4b2ff5 },  /* 149:  5.0000000e-01  7.9370053e-01 */
    { 0x3f800000,0x3f800000 },  /* 150:  1.0000000e+00  1.0000000e-00 */
    { 0x40000000,0x3fa14518 },  /* 151:  2.0000000e+00  1.2599210e+00 */
    { 0x40800000,0x3fcb2ff5 },  /* 152:  4.0000000e+00  1.5874011e+00 */
    { 0x41000000,0x40000000 },  /* 153:  8.0000000e+00  2.0000000e+00 */
    { 0x41800000,0x40214518 },  /* 154:  1.6000000e+01  2.5198421e+00 */
    { 0x42000000,0x404b2ff5 },  /* 155:  3.2000000e+01  3.1748021e+00 */
    { 0x42800000,0x40800000 },  /* 156:  6.4000000e+01  4.0000000e+00 */
    { 0x43000000,0x40a14518 },  /* 157:  1.2800000e+02  5.0396842e+00 */
    { 0x43800000,0x40cb2ff5 },  /* 158:  2.5600000e+02  6.3496042e+00 */
    { 0x44000000,0x41000000 },  /* 159:  5.1200000e+02  8.0000000e+00 */
    { 0x44800000,0x41214518 },  /* 160:  1.0240000e+03  1.0079368e+01 */
    { 0x45000000,0x414b2ff5 },  /* 161:  2.0480000e+03  1.2699208e+01 */
    { 0x45800000,0x41800000 },  /* 162:  4.0960000e+03  1.6000000e+01 */
    { 0x46000000,0x41a14518 },  /* 163:  8.1920000e+03  2.0158737e+01 */
    { 0x46800000,0x41cb2ff5 },  /* 164:  1.6384000e+04  2.5398417e+01 */
    { 0x47000000,0x42000000 },  /* 165:  3.2768000e+04  3.2000000e+01 */
    { 0x47800000,0x42214518 },  /* 166:  6.5536000e+04  4.0317474e+01 */
    { 0x48000000,0x424b2ff5 },  /* 167:  1.3107200e+05  5.0796834e+01 */
    { 0x48800000,0x42800000 },  /* 168:  2.6214400e+05  6.4000000e+01 */
    { 0x49000000,0x42a14518 },  /* 169:  5.2428800e+05  8.0634947e+01 */
    { 0x49800000,0x42cb2ff5 },  /* 170:  1.0485760e+06  1.0159367e+02 */
    { 0x4a000000,0x43000000 },  /* 171:  2.0971520e+06  1.2800000e+02 */
    { 0x4a800000,0x43214518 },  /* 172:  4.1943040e+06  1.6126989e+02 */
    { 0x4b000000,0x434b2ff5 },  /* 173:  8.3886080e+06  2.0318733e+02 */
    { 0x4b800000,0x43800000 },  /* 174:  1.6777216e+07  2.5600000e+02 */
    { 0x4c000000,0x43a14518 },  /* 175:  3.3554432e+07  3.2253979e+02 */
    { 0x4c800000,0x43cb2ff5 },  /* 176:  6.7108864e+07  4.0637467e+02 */
    { 0x4d000000,0x44000000 },  /* 177:  1.3421773e+08  5.1200000e+02 */
    { 0x4d800000,0x44214518 },  /* 178:  2.6843546e+08  6.4507958e+02 */
    { 0x4e000000,0x444b2ff5 },  /* 179:  5.3687091e+08  8.1274934e+02 */
    { 0x4e800000,0x44800000 },  /* 180:  1.0737418e+09  1.0240000e+03 */
    { 0x4f000000,0x44a14518 },  /* 181:  2.1474836e+09  1.2901592e+03 */
    { 0x4f800000,0x44cb2ff5 },  /* 182:  4.2949673e+09  1.6254987e+03 */
    { 0x50000000,0x45000000 },  /* 183:  8.5899346e+09  2.0480000e+03 */
    { 0x50800000,0x45214518 },  /* 184:  1.7179869e+10  2.5803183e+03 */
    { 0x51000000,0x454b2ff5 },  /* 185:  3.4359738e+10  3.2509974e+03 */
    { 0x51800000,0x45800000 },  /* 186:  6.8719477e+10  4.0960000e+03 */
    { 0x52000000,0x45a14518 },  /* 187:  1.3743895e+11  5.1606366e+03 */
    { 0x52800000,0x45cb2ff5 },  /* 188:  2.7487791e+11  6.5019947e+03 */
    { 0x53000000,0x46000000 },  /* 189:  5.4975581e+11  8.1920000e+03 */
    { 0x53800000,0x46214518 },  /* 190:  1.0995116e+12  1.0321273e+04 */
    { 0x54000000,0x464b2ff5 },  /* 191:  2.1990233e+12  1.3003989e+04 */
    { 0x54800000,0x46800000 },  /* 192:  4.3980465e+12  1.6384000e+04 */
    { 0x55000000,0x46a14518 },  /* 193:  8.7960930e+12  2.0642546e+04 */
    { 0x55800000,0x46cb2ff5 },  /* 194:  1.7592186e+13  2.6007979e+04 */
    { 0x56000000,0x47000000 },  /* 195:  3.5184372e+13  3.2768000e+04 */
    { 0x56800000,0x47214518 },  /* 196:  7.0368744e+13  4.1285093e+04 */
    { 0x57000000,0x474b2ff5 },  /* 197:  1.4073749e+14  5.2015958e+04 */
    { 0x57800000,0x47800000 },  /* 198:  2.8147498e+14  6.5536000e+04 */
    { 0x58000000,0x47a14518 },  /* 199:  5.6294995e+14  8.2570186e+04 */
    { 0x58800000,0x47cb2ff5 },  /* 200:  1.1258999e+15  1.0403192e+05 */
    { 0x59000000,0x48000000 },  /* 201:  2.2517998e+15  1.3107200e+05 */
    { 0x59800000,0x48214518 },  /* 202:  4.5035996e+15  1.6514037e+05 */
    { 0x5a000000,0x484b2ff5 },  /* 203:  9.0071993e+15  2.0806383e+05 */
    { 0x5a800000,0x48800000 },  /* 204:  1.8014399e+16  2.6214400e+05 */
    { 0x5b000000,0x48a14518 },  /* 205:  3.6028797e+16  3.3028074e+05 */
    { 0x5b800000,0x48cb2ff5 },  /* 206:  7.2057594e+16  4.1612766e+05 */
    { 0x5c000000,0x49000000 },  /* 207:  1.4411519e+17  5.2428800e+05 */
    { 0x5c800000,0x49214518 },  /* 208:  2.8823038e+17  6.6056149e+05 */
    { 0x5d000000,0x494b2ff5 },  /* 209:  5.7646075e+17  8.3225532e+05 */
    { 0x5d800000,0x49800000 },  /* 210:  1.1529215e+18  1.0485760e+06 */
    { 0x5e000000,0x49a14518 },  /* 211:  2.3058430e+18  1.3211230e+06 */
    { 0x5e800000,0x49cb2ff5 },  /* 212:  4.6116860e+18  1.6645106e+06 */
    { 0x5f000000,0x4a000000 },  /* 213:  9.2233720e+18  2.0971520e+06 */
    { 0x5f800000,0x4a214518 },  /* 214:  1.8446744e+19  2.6422459e+06 */
    { 0x60000000,0x4a4b2ff5 },  /* 215:  3.6893488e+19  3.3290213e+06 */
    { 0x60800000,0x4a800000 },  /* 216:  7.3786976e+19  4.1943040e+06 */
    { 0x61000000,0x4aa14518 },  /* 217:  1.4757395e+20  5.2844919e+06 */
    { 0x61800000,0x4acb2ff5 },  /* 218:  2.9514791e+20  6.6580426e+06 */
    { 0x62000000,0x4b000000 },  /* 219:  5.9029581e+20  8.3886080e+06 */
    { 0x62800000,0x4b214518 },  /* 220:  1.1805916e+21  1.0568984e+07 */
    { 0x63000000,0x4b4b2ff5 },  /* 221:  2.3611832e+21  1.3316085e+07 */
    { 0x63800000,0x4b800000 },  /* 222:  4.7223665e+21  1.6777216e+07 */
    { 0x64000000,0x4ba14518 },  /* 223:  9.4447330e+21  2.1137968e+07 */
    { 0x64800000,0x4bcb2ff5 },  /* 224:  1.8889466e+22  2.6632170e+07 */
    { 0x65000000,0x4c000000 },  /* 225:  3.7778932e+22  3.3554432e+07 */
    { 0x65800000,0x4c214518 },  /* 226:  7.5557864e+22  4.2275935e+07 */
    { 0x66000000,0x4c4b2ff5 },  /* 227:  1.5111573e+23  5.3264341e+07 */
    { 0x66800000,0x4c800000 },  /* 228:  3.0223145e+23  6.7108864e+07 */
    { 0x67000000,0x4ca14518 },  /* 229:  6.0446291e+23  8.4551870e+07 */
    { 0x67800000,0x4ccb2ff5 },  /* 230:  1.2089258e+24  1.0652868e+08 */
    { 0x68000000,0x4d000000 },  /* 231:  2.4178516e+24  1.3421773e+08 */
    { 0x68800000,0x4d214518 },  /* 232:  4.8357033e+24  1.6910374e+08 */
    { 0x69000000,0x4d4b2ff5 },  /* 233:  9.6714066e+24  2.1305736e+08 */
    { 0x69800000,0x4d800000 },  /* 234:  1.9342813e+25  2.6843546e+08 */
    { 0x6a000000,0x4da14518 },  /* 235:  3.8685626e+25  3.3820748e+08 */
    { 0x6a800000,0x4dcb2ff5 },  /* 236:  7.7371252e+25  4.2611473e+08 */
    { 0x6b000000,0x4e000000 },  /* 237:  1.5474250e+26  5.3687091e+08 */
    { 0x6b800000,0x4e214518 },  /* 238:  3.0948501e+26  6.7641496e+08 */
    { 0x6c000000,0x4e4b2ff5 },  /* 239:  6.1897002e+26  8.5222945e+08 */
    { 0x6c800000,0x4e800000 },  /* 240:  1.2379400e+27  1.0737418e+09 */
    { 0x6d000000,0x4ea14518 },  /* 241:  2.4758801e+27  1.3528299e+09 */
    { 0x6d800000,0x4ecb2ff5 },  /* 242:  4.9517602e+27  1.7044589e+09 */
    { 0x6e000000,0x4f000000 },  /* 243:  9.9035203e+27  2.1474836e+09 */
    { 0x6e800000,0x4f214518 },  /* 244:  1.9807041e+28  2.7056599e+09 */
    { 0x6f000000,0x4f4b2ff5 },  /* 245:  3.9614081e+28  3.4089178e+09 */
    { 0x6f800000,0x4f800000 },  /* 246:  7.9228163e+28  4.2949673e+09 */
    { 0x70000000,0x4fa14518 },  /* 247:  1.5845633e+29  5.4113197e+09 */
    { 0x70800000,0x4fcb2ff5 },  /* 248:  3.1691265e+29  6.8178356e+09 */
    { 0x71000000,0x50000000 },  /* 249:  6.3382530e+29  8.5899346e+09 */
    { 0x71800000,0x50214518 },  /* 250:  1.2676506e+30  1.0822639e+10 */
    { 0x72000000,0x504b2ff5 },  /* 251:  2.5353012e+30  1.3635671e+10 */
    { 0x72800000,0x50800000 },  /* 252:  5.0706024e+30  1.7179869e+10 */
    { 0x73000000,0x50a14518 },  /* 253:  1.0141205e+31  2.1645279e+10 */
    { 0x73800000,0x50cb2ff5 },  /* 254:  2.0282410e+31  2.7271342e+10 */
    { 0x74000000,0x51000000 },  /* 255:  4.0564819e+31  3.4359738e+10 */
    { 0x74800000,0x51214518 },  /* 256:  8.1129638e+31  4.3290558e+10 */
    { 0x75000000,0x514b2ff5 },  /* 257:  1.6225928e+32  5.4542685e+10 */
    { 0x75800000,0x51800000 },  /* 258:  3.2451855e+32  6.8719477e+10 */
    { 0x76000000,0x51a14518 },  /* 259:  6.4903711e+32  8.6581115e+10 */
    { 0x76800000,0x51cb2ff5 },  /* 260:  1.2980742e+33  1.0908537e+11 */
    { 0x77000000,0x52000000 },  /* 261:  2.5961484e+33  1.3743895e+11 */
    { 0x77800000,0x52214518 },  /* 262:  5.1922969e+33  1.7316223e+11 */
    { 0x78000000,0x524b2ff5 },  /* 263:  1.0384594e+34  2.1817074e+11 */
    { 0x78800000,0x52800000 },  /* 264:  2.0769187e+34  2.7487791e+11 */
    { 0x79000000,0x52a14518 },  /* 265:  4.1538375e+34  3.4632446e+11 */
    { 0x79800000,0x52cb2ff5 },  /* 266:  8.3076750e+34  4.3634148e+11 */
    { 0x7a000000,0x53000000 },  /* 267:  1.6615350e+35  5.4975581e+11 */
    { 0x7a800000,0x53214518 },  /* 268:  3.3230700e+35  6.9264892e+11 */
    { 0x7b000000,0x534b2ff5 },  /* 269:  6.6461400e+35  8.7268296e+11 */
    { 0x7b800000,0x53800000 },  /* 270:  1.3292280e+36  1.0995116e+12 */
    { 0x7c000000,0x53a14518 },  /* 271:  2.6584560e+36  1.3852978e+12 */
    { 0x7c800000,0x53cb2ff5 },  /* 272:  5.3169120e+36  1.7453659e+12 */
    { 0x7d000000,0x54000000 },  /* 273:  1.0633824e+37  2.1990233e+12 */
    { 0x7d800000,0x54214518 },  /* 274:  2.1267648e+37  2.7705957e+12 */
    { 0x7e000000,0x544b2ff5 },  /* 275:  4.2535296e+37  3.4907318e+12 */
    { 0x7e800000,0x54800000 },  /* 276:  8.5070592e+37  4.3980465e+12 */
    { 0x7f000000,0x54a14518 },  /* 277:  1.7014118e+38  5.5411914e+12 */
};

int main ()
{
    int i;
    union float_u tx, tz;
    
    for (i = 0;  (size_t)i < sizeof(t) / sizeof(t[0]); i++) {
	tx.u32 = pgm_read_dword (& t[i].x);
	tz.u32 = pgm_read_dword (& t[i].z);
	v.flt = cbrt (tx.flt);
	if ((v.u32 - tz.u32) > ULPMAX && (tz.u32 - v.u32) > ULPMAX) {
	    PRINTFLN ("t1[%d]={0x%08lx,0x%08lx} --> 0x%08lx\n",
		      i, tx.u32, tz.u32, v.u32);
	    EXIT (i + 1);
	}
    }
    
    return 0;
}
