
enum {
    MMXNOW_FILTERV_SOURCE,
    MMXNOW_FILTERV_CONVERT,
    MMXNOW_FILTERV_RESIZE_BILINEAR_WIDTH,
    MMXNOW_FILTERV_RESIZE_BILINEAR_HEIGHT,
};

// C, mmx, mmx2, sse, sse2, 3dnow

table_MMXNOW_FILTER_SOURCE {
    { mmxnow_flt_source, 0,

}


struct mmxnow_filter_s;

// filter processing function
typedef int(*mmxnow_func_destroy)(struct mmxnow_filter_s* filter);
typedef int(*mmxnow_func_process)(int lines, uint8_t planes[3], ...);


typedef struct mmxnow_filter_s {
    int type;
    struct mmxnow_filter_s* parent;
    unsigned char* to_plane[3];
    int to_stride[3];
    int to_width;
    int to_height;

    unsigned char* from_plane[3];
    int from_stride[3];
    int from_width;
    int from_height;
    mmxnow_func_destroy destroy;
    mmxnow_func_process process;


} mmxnow_filter_t;

static inline add_planes(mmxnow_filter_t* f)
{
    f->to_plane[0] = f->from_plane[0];
    f->from_plane[0] += f->from_stride[0];

    f->to_plane[1] = f->from_plane[1];
    f->from_plane[1] += f->from_stride[1];

    f->to_plane[2] = f->from_plane[2];
    f->from_plane[2] += f->from_stride[2];
}


mmxnow_filter_t* mmxnow_filter_create(int flags, int type, mmxnow_filter_t* parent)
{
    mmxnow_filter_t* flt;
    if (type != MMXNOW_FILTER_SOURCE && !parent)
    {
        // must be SOURCE filter when there is no parent!!
        abort();
	return 0;
    }

    flt = malloc(sizeof(mmxnow_filter_t));
    if (!flt)
        return 0;

    memset(flt, 0, sizeof(mmxnow_filter_t));
    flt->type = type;
    flt->patent = parent;

    switch (type)
    {
    case MMXNOW_FILTER_SOURCE:
	table = table_MMXNOW_FILTER_SOURCE;
        break;
    case MMXNOW_FILTER_CONVERT:
        break;
    case MMXNOW_FILTER_RESIZE_BILINEAR_WIDTH:
        break;
    case MMXNOW_FILTER_RESIZE_BILINEAR_HEIGHT:
        break;
    }


    flt->destroy = get_table(table, flags);
    flt->process = get_table(table, flags);


    return flt;
}

int mmxnow_filter_destroy_convert(mmxnow_filter_t* filter)
{
    if (filter->parent)
        mmxnow_filter_destroy(
    free(filter);
}

int mmxnow_filter_init_convert(int param, ...)
{

}

int mmxnow_filter_process(uint8_t planes[3], int lines, ...)
{

}


static sourcef()
{


}

int mmxnow_filter_process_source_planar(mmxnow_filter_t* f, uint8_t* planes[3])
{
    return 1;
}

int mmxnow_filter_process_convert_planar(mmxnow_filter_t* f, uint8_t* dstplanes[3])
{
    uint8_t* p[0];
    int i;
    int l = f->parent->process(f->parent, f->planes, 1);

    for (i = 0; i < f->width; i++)
	f->from_plane[0] = p[0];

}

int proce2()
{
    f = top;
    while (f)
    {
	f->proces(f);
        f = f->next();
    }
}
