// PNG Pong
//
// Copyright © 2019-2021 Jeron Aldaron Lau
//
// Licensed under the Apache License, Version 2.0, <LICENSE-APACHE or
// https://apache.org/licenses/LICENSE-2.0>, or the Zlib License, <LICENSE-ZLIB
// or http://opensource.org/licenses/Zlib>, at your option. This file may not be
// copied, modified, or distributed except according to those terms.

// Magic bytes to start a PNG file.
pub(super) const PNG_SIGNATURE: [u8; 8] = [137, 80, 78, 71, 13, 10, 26, 10];

// Chunk Identifiers
pub(super) const IMAGE_HEADER: [u8; 4] = *b"IHDR";
pub(super) const IMAGE_DATA: [u8; 4] = *b"IDAT";
pub(super) const BACKGROUND: [u8; 4] = *b"bKGD";
pub(super) const TRANSPARENCY: [u8; 4] = *b"tRNS";
pub(super) const IMAGE_END: [u8; 4] = *b"IEND";
pub(super) const PALETTE: [u8; 4] = *b"PLTE";
pub(super) const ITEXT: [u8; 4] = *b"iTXt";
pub(super) const PHYSICAL: [u8; 4] = *b"pHYs";
pub(super) const TIME: [u8; 4] = *b"tIME";
pub(super) const ZTEXT: [u8; 4] = *b"zTXt";
pub(super) const TEXT: [u8; 4] = *b"tEXt";

pub(super) const MAX_CHUNK_SIZE: usize = 1 << 31; // 2³¹

// Initial value for CRC32 Checksum
pub(super) const CRC32_INIT: u32 = 4_294_967_295;
// Look-up table for CRC32 Checksum
pub(super) const CRC32_LOOKUP: [u32; 256] = [
    0,
    1_996_959_894,
    3_993_919_788,
    2_567_524_794,
    124_634_137,
    1_886_057_615,
    3_915_621_685,
    2_657_392_035,
    249_268_274,
    2_044_508_324,
    3_772_115_230,
    2_547_177_864,
    162_941_995,
    2_125_561_021,
    3_887_607_047,
    2_428_444_049,
    498_536_548,
    1_789_927_666,
    4_089_016_648,
    2_227_061_214,
    450_548_861,
    1_843_258_603,
    4_107_580_753,
    2_211_677_639,
    325_883_990,
    1_684_777_152,
    4_251_122_042,
    2_321_926_636,
    335_633_487,
    1_661_365_465,
    4_195_302_755,
    2_366_115_317,
    997_073_096,
    1_281_953_886,
    3_579_855_332,
    2_724_688_242,
    1_006_888_145,
    1_258_607_687,
    3_524_101_629,
    2_768_942_443,
    901_097_722,
    1_119_000_684,
    3_686_517_206,
    2_898_065_728,
    853_044_451,
    1_172_266_101,
    3_705_015_759,
    2_882_616_665,
    651_767_980,
    1_373_503_546,
    3_369_554_304,
    3_218_104_598,
    565_507_253,
    1_454_621_731,
    3_485_111_705,
    3_099_436_303,
    671_266_974,
    1_594_198_024,
    3_322_730_930,
    2_970_347_812,
    795_835_527,
    1_483_230_225,
    3_244_367_275,
    3_060_149_565,
    1_994_146_192,
    31_158_534,
    2_563_907_772,
    4_023_717_930,
    1_907_459_465,
    112_637_215,
    2_680_153_253,
    3_904_427_059,
    2_013_776_290,
    251_722_036,
    2_517_215_374,
    3_775_830_040,
    2_137_656_763,
    141_376_813,
    2_439_277_719,
    3_865_271_297,
    1_802_195_444,
    476_864_866,
    2_238_001_368,
    4_066_508_878,
    1_812_370_925,
    453_092_731,
    2_181_625_025,
    4_111_451_223,
    1_706_088_902,
    314_042_704,
    2_344_532_202,
    4_240_017_532,
    1_658_658_271,
    366_619_977,
    2_362_670_323,
    4_224_994_405,
    1_303_535_960,
    984_961_486,
    2_747_007_092,
    3_569_037_538,
    1_256_170_817,
    1_037_604_311,
    2_765_210_733,
    3_554_079_995,
    1_131_014_506,
    879_679_996,
    2_909_243_462,
    3_663_771_856,
    1_141_124_467,
    855_842_277,
    2_852_801_631,
    3_708_648_649,
    1_342_533_948,
    654_459_306,
    3_188_396_048,
    3_373_015_174,
    1_466_479_909,
    544_179_635,
    3_110_523_913,
    3_462_522_015,
    1_591_671_054,
    702_138_776,
    2_966_460_450,
    3_352_799_412,
    1_504_918_807,
    783_551_873,
    3_082_640_443,
    3_233_442_989,
    3_988_292_384,
    2_596_254_646,
    62_317_068,
    1_957_810_842,
    3_939_845_945,
    2_647_816_111,
    81_470_997,
    1_943_803_523,
    3_814_918_930,
    2_489_596_804,
    225_274_430,
    2_053_790_376,
    3_826_175_755,
    2_466_906_013,
    167_816_743,
    2_097_651_377,
    4_027_552_580,
    2_265_490_386,
    503_444_072,
    1_762_050_814,
    4_150_417_245,
    2_154_129_355,
    426_522_225,
    1_852_507_879,
    4_275_313_526,
    2_312_317_920,
    282_753_626,
    1_742_555_852,
    4_189_708_143,
    2_394_877_945,
    397_917_763,
    1_622_183_637,
    3_604_390_888,
    2_714_866_558,
    953_729_732,
    1_340_076_626,
    3_518_719_985,
    2_797_360_999,
    1_068_828_381,
    1_219_638_859,
    3_624_741_850,
    2_936_675_148,
    906_185_462,
    1_090_812_512,
    3_747_672_003,
    2_825_379_669,
    829_329_135,
    1_181_335_161,
    3_412_177_804,
    3_160_834_842,
    628_085_408,
    1_382_605_366,
    3_423_369_109,
    3_138_078_467,
    570_562_233,
    1_426_400_815,
    3_317_316_542,
    2_998_733_608,
    733_239_954,
    1_555_261_956,
    3_268_935_591,
    3_050_360_625,
    752_459_403,
    1_541_320_221,
    2_607_071_920,
    3_965_973_030,
    1_969_922_972,
    40_735_498,
    2_617_837_225,
    3_943_577_151,
    1_913_087_877,
    83_908_371,
    2_512_341_634,
    3_803_740_692,
    2_075_208_622,
    213_261_112,
    2_463_272_603,
    3_855_990_285,
    2_094_854_071,
    198_958_881,
    2_262_029_012,
    4_057_260_610,
    1_759_359_992,
    534_414_190,
    2_176_718_541,
    4_139_329_115,
    1_873_836_001,
    414_664_567,
    2_282_248_934,
    4_279_200_368,
    1_711_684_554,
    285_281_116,
    2_405_801_727,
    4_167_216_745,
    1_634_467_795,
    376_229_701,
    2_685_067_896,
    3_608_007_406,
    1_308_918_612,
    956_543_938,
    2_808_555_105,
    3_495_958_263,
    1_231_636_301,
    1_047_427_035,
    2_932_959_818,
    3_654_703_836,
    1_088_359_270,
    936_918_000,
    2_847_714_899,
    3_736_837_829,
    1_202_900_863,
    817_233_897,
    3_183_342_108,
    3_401_237_130,
    1_404_277_552,
    615_818_150,
    3_134_207_493,
    3_453_421_203,
    1_423_857_449,
    601_450_431,
    3_009_837_614,
    3_294_710_456,
    1_567_103_746,
    711_928_724,
    3_020_668_471,
    3_272_380_065,
    1_510_334_235,
    755_167_117,
];
