/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.tool.re;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.jiapi.tool.re.Node;

class Loop {
    private final Node header;
    private List<Node> nodes = new LinkedList<Node>();
    private final Node tail;
    private boolean isForLoop = false;

    Loop(Node header, Node tail) {
        this.header = header;
        this.tail = tail;
    }

    public void addNode(Node n) {
        this.nodes.add(n);
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public boolean contains(Node n) {
        return this.nodes.contains(n);
    }

    public Node getHeader() {
        return this.header;
    }

    public Node getTail() {
        return this.tail;
    }

    public Node getLoopBody() {
        Set<Node> successors = this.header.getSuccessors();
        for (Node n : successors) {
            if (!this.nodes.contains(n)) continue;
            return n;
        }
        return null;
    }

    public Node getContinueNode() {
        if (this.isForLoop) {
            return this.getTail();
        }
        return this.getHeader();
    }

    public Node getPostDominator() {
        Set<Node> successors = this.header.getSuccessors();
        for (Node n : successors) {
            if (this.nodes.contains(n)) continue;
            return n;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Loop: ");
        for (Node node : this.nodes) {
            sb.append(node.getId());
            if (node.equals(this.header)) {
                sb.append("(hdr)");
            } else if (node.equals(this.tail)) {
                sb.append("(tail)");
            }
            sb.append(" ");
        }
        return sb.toString();
    }
}

