/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 11:58:54 GMT 2018
 */

package uk.ac.sanger.artemis.components;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.awt.datatransfer.Clipboard;
import java.util.Vector;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.SimpleGotoEventSource;
import uk.ac.sanger.artemis.components.BasePlotGroup;
import uk.ac.sanger.artemis.components.FeatureDisplay;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class FeatureDisplay_ESTest extends FeatureDisplay_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource((EntryGroup) null);
      FeatureDisplay featureDisplay0 = null;
      try {
        featureDisplay0 = new FeatureDisplay((EntryGroup) null, (Selection) null, simpleGotoEventSource0, (BasePlotGroup) null, 116);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.FeatureDisplay", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("org.biojava.bio.symbol.FuzzyLocation$AverageRangeResolver");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureDisplay featureDisplay0 = null;
      try {
        featureDisplay0 = new FeatureDisplay(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      Vector<String> vector0 = FeatureDisplay.getAllPossibleContigKeys();
      assertNotNull(vector0);
      assertEquals("[fasta_record, contig, insertion_gap, gap, scaffold, source]", vector0.toString());
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      Vector<String> vector0 = FeatureDisplay.getContigKeys();
      assertEquals("[fasta_record, contig, insertion_gap]", vector0.toString());
      assertNotNull(vector0);
      assertEquals(3, vector0.capacity());
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("uk.ac.sanger.artemis.components.LogViewer$1", "");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("Mac OS X Aqua");
      Feature feature0 = entry0.createFeature();
      String string0 = FeatureDisplay.getParentQualifier(feature0);
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Metal");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FeatureVector featureVector0 = simpleEntryGroup0.getFeaturesInIndexRange(520, 1);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "xId]Rso.<ZXeOOE5s}");
      Clipboard clipboard0 = new Clipboard("t&7vXqrbjEF.X(z");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(filteredEntryGroup0);
      FeatureDisplay featureDisplay0 = null;
      try {
        featureDisplay0 = new FeatureDisplay(filteredEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.dnd.DragSource", e);
      }
  }
}
