/*
 * Copyright (C) 2009 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.sdklib.internal.repository.packages;

import com.android.annotations.NonNull;
import com.android.sdklib.AndroidVersion;

/**
 * Interface for packages that provide an {@link AndroidVersion}.
 * <p/>
 * Note that {@link IPlatformDependency} is a similar interface, but with a different semantic.
 * The {@link IPlatformDependency} denotes that a given package can only be installed if the
 * requested platform is present, whereas this interface denotes that the given package simply
 * has a version, which is not necessarily a dependency.
 *
 * @deprecated
 * com.android.sdklib.internal.repository has moved into Studio as
 * com.android.tools.idea.sdk.remote.internal.
 */
@Deprecated
public interface IAndroidVersionProvider {

    /**
     * Returns the android version, for platform, add-on and doc packages.
     * Can be 0 if this is a local package of unknown api-level.
     */
    @NonNull
    AndroidVersion getAndroidVersion();
}
