/*
    Copyright (C) 2009 Dan Meltzer <parallelgrapefruit@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef SQLWRITELABELCAPABILITY_H
#define SQLWRITELABELCAPABILITY_H

#include "core/capabilities/WriteLabelCapability.h"
#include "SqlMeta.h"

#include <QSharedPointer>

class SqlStorage;

namespace Capabilities
{

class SqlWriteLabelCapability : public WriteLabelCapability
{
    Q_OBJECT
    public:
        SqlWriteLabelCapability( Meta::SqlTrack *track, const QSharedPointer<SqlStorage> &storage );
        void setLabels( const QStringList &removedLabels, const QStringList &newlabels ) override;

    private:
        Meta::TrackPtr m_track;
        QSharedPointer<SqlStorage> m_storage;
};

}

#endif // SQLREADLABELCAPABILITY_H
