/*******************************************************************************
 *  PROJECT: GNOME Colorscheme
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2005 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/

#ifndef __GCS_PALETTEVIEW_H
#define __GCS_PALETTEVIEW_H

#include <vector>
#include <istream>

#include <gtkmm/table.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/eventbox.h>
#include <gtkmm/box.h>
#include <gtkmm/expander.h>
#include <glibmm/ustring.h>
#include <libglademm/xml.h>

#include "core/gcs-types.h"
#include "core/gcs-color.h"
#include "paletteparser/palette.h"
#include "palette-selector.h"

using namespace Gnome;

namespace gcs
{
    class PaletteTreeModel;

    namespace Widgets
    {
        class PaletteView : public Gtk::Expander
        {
            public:
                PaletteView(GtkExpander* cobject, Glib::RefPtr<Glade::Xml>& glade);
                //~PaletteView();
                bool set_from_file(const Glib::ustring& fname);

                sigc::signal<void, ColorPtr>& signal_color_selected() {
                    return m_signal_color_selected; }

#ifdef UNIT_TEST
                friend class PaletteTests;
#endif

            protected:
                bool on_color_selected(gint index);
                void display_palette(const shared_ptr<pp::Palette>& palette);

                /** triggered whenever the mouse pointer enters the palette
                 */
                bool on_enter_swatch(GdkEventCrossing* event);

                /** triggered whenever the mouse pointer leaves the palette
                 */
                bool on_leave_swatch(GdkEventCrossing* event);

                /** triggered when the combobox selection has changed
                 */
                void on_palette_file_changed(void);

                bool on_eventbox_expose(GdkEventExpose* e);

            private:
                Gtk::Table m_table;
                Gtk::EventBox m_eventBox;
                Gtk::ScrolledWindow m_scrolledWindow;
                sigc::signal<void, ColorPtr> m_signal_color_selected;
                Glib::RefPtr<PaletteTreeModel> m_refPaletteModel;
                shared_ptr<pp::Palette> m_palette;
                shared_ptr<PaletteSelector> m_paletteSelector;
                Gtk::VBox m_vbox;
                static const gint m_minCellSize;
                static const gint m_minPaletteWidth;
                static const gint m_maxVisibleRows;
                static const gint m_maxPaletteHeight;
                guint m_rows;
        };

    } // namespace Widgets
} // namespace gcs

#endif // __GCS_PALETTEVIEW_H
