; This file was initially generated automatically from legacy documentation
; strings.  See source files in this directory for copyright and license
; information.

(in-package "ACL2")

(include-book "xdoc/top" :dir :system)

(defxdoc defmul
  :parents (defmul)
  :short "Extends a well-founded relation &lt;rel&gt; to multisets."
  :long "<p>How to use: To extend a well-founded relation &lt;rel&gt; to
   multisets we need know: - &lt;rel&gt;: The well-founded relation defined on
   A.  - &lt;theorem&gt;: The theorem with rule class \"well-founded-relation\"
   associated with &lt;rel&gt;.  - &lt;mp&gt;: The measure property defining
   the set A.  - &lt;fn&gt;: The embedding justifying the well-foundedness of
   &lt;rel&gt;.  - &lt;varx&gt;, &lt;vary&gt;: The variables used in the
   &lt;theorem&gt;.  and eval the \"defmul\" macro with the list of these
   components:</p>

 <p>(defmul (&lt;rel&gt; &lt;theorem&gt; &lt;mp&gt; &lt;fn&gt; &lt;varx&gt;
 &lt;vary&gt;))</p>

 <p>The main non-local events generated by this macro call are:</p>

 <p>- the definitions needed for the multiset relation induced by &lt;rel&gt;:
     functions exists-&lt;rel&gt;-bigger, forall-exists-&lt;rel&gt;-bigger and
     mul-&lt;rel&gt;.  - the definition of the multiset measure property,
     &lt;mp&gt;-true-listp.  - the definition of mp-&lt;fn&gt;-e0-ord, the
     embedding function from multisets to ordinals.  - the well-foundedness
     theorem for mul-&lt;rel&gt;, named
     multiset-extension-of-&lt;rel&gt;-well-founded.</p>

 <p>To see the complete list of generated events use :trans1 on a defmul
 call.</p>

 <p>We expect defmul to work without assistance from the user. After the above
 call to defmul, the function mul-&lt;rel&gt; is defined as a well-founded
 relation on multisets of elements satisfying the property &lt;mp&gt;, induced
 by the well-founded relation &lt;rel&gt;. From this moment on, mul-&lt;rel&gt;
 can be used in the admissibility test for recursive functions to show that the
 recursion terminates.</p>

 <p>This macro has three optionals arguments: :prefix &lt;prefix&gt; : With
   this argument we can use &lt;prefix&gt; as a prefix for the names of the
   events builded.  :rule-classes &lt;classes&gt; : With this argument we can
   propose &lt;classes&gt; as additional rule-classes for the well-founded
   relation theorem associated with the multiset extension. The default value
   is :well-founded-relation.  :verify-guards &lt;expr&gt; : The value of
   &lt;expr&gt; must be T or NIL. With this argument we can decide when the
   guards of the functions builded must be verified on definition time.</p>

 <p>To know the list of names that we need to supply to a \"defmul\" call, we
   have developed a tool to look up the Acl2 \"world\" and print that list:</p>

 <p>(defmul-components &lt;rel&gt;)</p>

 <p>This is only an informative tool, not a event. This macro looks up the Acl2
   \"world\", and informs if some symbols (those that the \"defmul\" macro
   builds) have been already defined. As the \"defmul\" macro, has one optional
   argument to propose a prefix: :prefix &lt;prefix&gt; : With this argument we
   can use &lt;prefix&gt; as a prefix for the names of the events builded.</p>

 <p>An example:</p>

 <p>(encapsulate ((my-mp (v) booleanp) (my-rel (v w) booleanp) (my-fn (v)
    e0-ordinalp))

    (local (defun my-mp (v) (declare (ignore v)) nil))
    (local (defun my-rel (v w) (declare (ignore v w)) nil))
    (local (defun my-fn (v) (declare (ignore v)) 1))

    (defthm my-rel-well-founded-relation
      (and (implies (my-mp v) (e0-ordinalp (my-fn v)))
   	   (implies (and (my-mp v)
   			 (my-mp w)
   			 (my-rel v w))
   	     (e0-ord-&lt; (my-fn v) (my-fn w)))))
  ;    :rule-classes :well-founded-relation) ; commented out for v2-8 ordinals changes

    (defun map-my-fn-e0-ord (l)
      l))

   ; (defmul-components my-rel)
   ; =&gt; WARNING: The symbol MAP-MY-FN-E0-ORD is defined yet. Perhaps you must
   ;    use the :PREFIX option.
   ;
   ;    The list of components is:
   ;     (MY-REL MY-REL-WELL-FOUNDED-RELATION MY-MP MY-FN V W)
   ;
   ; (defmul-components my-rel :prefix new)
   ; =&gt; The list of components is:
   ;     (MY-REL MY-REL-WELL-FOUNDED-RELATION MY-MP MY-FN V W)

   (defmul (MY-REL MY-REL-WELL-FOUNDED-RELATION MY-MP MY-FN V W)
     :prefix new :rule-classes :rewrite)</p>")
