#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Noctropolis
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250914.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='noctropolis'
GAME_NAME='Noctropolis'

ARCHIVE_BASE_0_NAME='noctropolis_en_1_0_16066.sh'
ARCHIVE_BASE_0_MD5='08bc9c0135daa87ffa4059706442687b'
ARCHIVE_BASE_0_SIZE='640000'
ARCHIVE_BASE_0_VERSION='1.0-gog16066'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/noctropolis'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN_FILES='
noctropolis'
## TODO: Check if localisation packages could be provided.
CONTENT_GAME_DATA_FILES='
DARK
DE
ES
FR'
CONTENT_DOC_DATA_FILES='
LICENSE.ogg-vorbis.txt
README.txt
README-SDL.txt'

## TODO: Extract an icon from another build of the game,
##       to provide as an optional archive.
APP_MAIN_EXE='noctropolis'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libgcc_s.so.1
libGL.so.1
libm.so.6
libpthread.so.0
libSDL2-2.0.so.0
libSDL2_mixer-2.0.so.0
libstdc++.so.6
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
