/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_SYSTEMSPECIFICSOFTWAREINVENTORYCOLLECTIONACCESS_H_
#define OPENDRIM_SYSTEMSPECIFICSOFTWAREINVENTORYCOLLECTIONACCESS_H_

#include "SoftwareInventory_Common.h"

#include "OpenDRIM_SystemSpecificSoftwareInventoryCollection.h"

int SoftwareInventory_OpenDRIM_SystemSpecificSoftwareInventoryCollection_load(const CMPIBroker* broker, string& errorMessage);

int SoftwareInventory_OpenDRIM_SystemSpecificSoftwareInventoryCollection_unload(string& errorMessage);

int SoftwareInventory_OpenDRIM_SystemSpecificSoftwareInventoryCollection_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SystemSpecificSoftwareInventoryCollection>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_SystemSpecificSoftwareInventoryCollection_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SystemSpecificSoftwareInventoryCollection& instance, const char** properties, string& errorMessage);

int SoftwareInventory_OpenDRIM_SystemSpecificSoftwareInventoryCollection_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SystemSpecificSoftwareInventoryCollection& newInstance, const OpenDRIM_SystemSpecificSoftwareInventoryCollection& oldInstance, const char** properties, string& errorMessage);

int SoftwareInventory_OpenDRIM_SystemSpecificSoftwareInventoryCollection_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SystemSpecificSoftwareInventoryCollection& instance, string& errorMessage);

int SoftwareInventory_OpenDRIM_SystemSpecificSoftwareInventoryCollection_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SystemSpecificSoftwareInventoryCollection& instance, string& errorMessage);

int SoftwareInventory_OpenDRIM_SystemSpecificSoftwareInventoryCollection_populate(OpenDRIM_SystemSpecificSoftwareInventoryCollection& instance, string& errorMessage);

#endif /*OPENDRIM_SYSTEMSPECIFICSOFTWAREINVENTORYCOLLECTIONACCESS_H_*/
