/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_ORDEREDSOFTWAREINVENTORYCOMPONENTACCESS_H_
#define OPENDRIM_ORDEREDSOFTWAREINVENTORYCOMPONENTACCESS_H_

#include "SoftwareInventory_Common.h"

#include "OpenDRIM_OrderedSoftwareInventoryComponent.h"
#include "assocOpenDRIM_OrderedSoftwareInventoryComponent.h"

int SoftwareInventory_OpenDRIM_OrderedSoftwareInventoryComponent_load(const CMPIBroker* broker, string& errorMessage);

int SoftwareInventory_OpenDRIM_OrderedSoftwareInventoryComponent_unload(string& errorMessage);

int SoftwareInventory_OpenDRIM_OrderedSoftwareInventoryComponent_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_OrderedSoftwareInventoryComponent>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_OrderedSoftwareInventoryComponent_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_OrderedSoftwareInventoryComponent& instance, const char** properties, string& errorMessage);

int SoftwareInventory_OpenDRIM_OrderedSoftwareInventoryComponent_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OrderedSoftwareInventoryComponent& newInstance, const OpenDRIM_OrderedSoftwareInventoryComponent& oldInstance, const char** properties, string& errorMessage);

int SoftwareInventory_OpenDRIM_OrderedSoftwareInventoryComponent_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OrderedSoftwareInventoryComponent& instance, string& errorMessage);

int SoftwareInventory_OpenDRIM_OrderedSoftwareInventoryComponent_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OrderedSoftwareInventoryComponent& instance, string& errorMessage);

int SoftwareInventory_OpenDRIM_OrderedSoftwareInventoryComponent_associatorPartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const char** properties, vector<Instance>& GroupComponent_associatedInstances, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_OrderedSoftwareInventoryComponent_associatorGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const char** properties, vector<Instance>& PartComponent_associatedInstances, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_OrderedSoftwareInventoryComponent_referencePartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const vector<Instance>& GroupComponent_instances, vector<OpenDRIM_OrderedSoftwareInventoryComponent>& OpenDRIM_OrderedSoftwareInventoryComponent_instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_OrderedSoftwareInventoryComponent_referenceGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const vector<Instance>& PartComponent_instances, vector<OpenDRIM_OrderedSoftwareInventoryComponent>& OpenDRIM_OrderedSoftwareInventoryComponent_instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_OrderedSoftwareInventoryComponent_populate(OpenDRIM_OrderedSoftwareInventoryComponent& instance, string& errorMessage);

#endif /*OPENDRIM_ORDEREDSOFTWAREINVENTORYCOMPONENTACCESS_H_*/
