/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "cmpiOpenDRIM_BIOSService.h"
#include "OpenDRIM_BIOSServiceAccess.h"

static const CMPIBroker * _broker;

#ifdef CMPI_VER_100
#define BIOS_OpenDRIM_BIOSServiceProviderSetInstance BIOS_OpenDRIM_BIOSServiceProviderModifyInstance
#endif

int BIOS_OpenDRIM_BIOSService_init(const CMPIBroker* broker);

int BIOS_OpenDRIM_BIOSService_finalize();

/* ---------------------------------------------------------------------------*/
/*                      Instance Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus BIOS_OpenDRIM_BIOSServiceProviderCleanup(CMPIInstanceMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = BIOS_OpenDRIM_BIOSService_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus BIOS_OpenDRIM_BIOSServiceProviderEnumInstanceNames(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_BIOSService> instances;
	string errorMessage;
	
	int errorCode = BIOS_OpenDRIM_BIOSService_retrieve(_broker, ctx, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIObjectPath* op = BIOS_OpenDRIM_BIOSService_toCMPIObjectPath(_broker, instances[i]);
		CMReturnObjectPath(rslt, op);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus BIOS_OpenDRIM_BIOSServiceProviderEnumInstances(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_BIOSService> instances;
	string errorMessage;
	
	int errorCode = BIOS_OpenDRIM_BIOSService_retrieve(_broker, ctx, instances, properties, errorMessage, "ei");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIInstance* ci = BIOS_OpenDRIM_BIOSService_toCMPIInstance(_broker, instances[i]);
		CMReturnInstance(rslt, ci);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus BIOS_OpenDRIM_BIOSServiceProviderGetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_BIOSService instance;
	BIOS_OpenDRIM_BIOSService_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = BIOS_OpenDRIM_BIOSService_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIInstance* ci = BIOS_OpenDRIM_BIOSService_toCMPIInstance(_broker, instance);
	CMReturnInstance(rslt, ci);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus BIOS_OpenDRIM_BIOSServiceProviderSetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_BIOSService newInstance, oldInstance;
	BIOS_OpenDRIM_BIOSService_toCPP(_broker, ci, newInstance);
	BIOS_OpenDRIM_BIOSService_toCPP(_broker, cop, oldInstance);
	string errorMessage;
	
	int errorCode = BIOS_OpenDRIM_BIOSService_getInstance(_broker, ctx, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = BIOS_OpenDRIM_BIOSService_setInstance(_broker, ctx, newInstance, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus BIOS_OpenDRIM_BIOSServiceProviderCreateInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_BIOSService instance;
	BIOS_OpenDRIM_BIOSService_toCPP(_broker, ci, instance);
	string errorMessage;
	
	int errorCode = BIOS_OpenDRIM_BIOSService_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != NOT_FOUND) {
		if (errorCode == OK)
			errorCode = ALREADY_EXISTS;
		errorMessage = (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = BIOS_OpenDRIM_BIOSService_createInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = BIOS_OpenDRIM_BIOSService_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIObjectPath* _cop = BIOS_OpenDRIM_BIOSService_toCMPIObjectPath(_broker, instance);
	CMReturnObjectPath(rslt, _cop);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus BIOS_OpenDRIM_BIOSServiceProviderDeleteInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_BIOSService instance;
	BIOS_OpenDRIM_BIOSService_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = BIOS_OpenDRIM_BIOSService_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = BIOS_OpenDRIM_BIOSService_deleteInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus BIOS_OpenDRIM_BIOSServiceProviderExecQuery(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* lang, const char* query) {
	_E_;
	CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

/* ---------------------------------------------------------------------------*/
/*                   End of Instance Provider Interface                       */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                        Method Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus BIOS_OpenDRIM_BIOSServiceProviderMethodCleanup(CMPIMethodMI * mi, const CMPIContext * ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = BIOS_OpenDRIM_BIOSService_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus BIOS_OpenDRIM_BIOSServiceProviderInvokeMethod(CMPIMethodMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* methodName, const CMPIArgs* in, CMPIArgs* out) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_BIOSService instance;
	BIOS_OpenDRIM_BIOSService_toCPP(_broker, ref, instance);
	string errorMessage;

	const char* properties[] = {"SystemCreationClassName", "Name", "SystemName", "CreationClassName"};
	int errorCode = BIOS_OpenDRIM_BIOSService_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}

	if ((string) methodName =="RequestStateChange") {
		unsigned int returnValue;
		OpenDRIM_BIOSService_RequestStateChange_In inArgs;
		BIOS_OpenDRIM_BIOSService_toCPP(_broker, in, inArgs);
		OpenDRIM_BIOSService_RequestStateChange_Out outArgs;
		
		errorCode = BIOS_OpenDRIM_BIOSService_RequestStateChange(_broker, ctx, instance, returnValue, inArgs, outArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		BIOS_OpenDRIM_BIOSService_toCMPIArg(_broker, out, outArgs);
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="StartService") {
		unsigned int returnValue;
		
		errorCode = BIOS_OpenDRIM_BIOSService_StartService(_broker, ctx, instance, returnValue, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="StopService") {
		unsigned int returnValue;
		
		errorCode = BIOS_OpenDRIM_BIOSService_StopService(_broker, ctx, instance, returnValue, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="SetBIOSAttribute") {
		unsigned int returnValue;
		OpenDRIM_BIOSService_SetBIOSAttribute_In inArgs;
		BIOS_OpenDRIM_BIOSService_toCPP(_broker, in, inArgs);
		OpenDRIM_BIOSService_SetBIOSAttribute_Out outArgs;
		
		errorCode = BIOS_OpenDRIM_BIOSService_SetBIOSAttribute(_broker, ctx, instance, returnValue, inArgs, outArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		BIOS_OpenDRIM_BIOSService_toCMPIArg(_broker, out, outArgs);
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="SetBIOSAttributeEmbeddedInstance") {
		unsigned int returnValue;
		OpenDRIM_BIOSService_SetBIOSAttributeEmbeddedInstance_In inArgs;
		BIOS_OpenDRIM_BIOSService_toCPP(_broker, in, inArgs);
		OpenDRIM_BIOSService_SetBIOSAttributeEmbeddedInstance_Out outArgs;
		
		errorCode = BIOS_OpenDRIM_BIOSService_SetBIOSAttributeEmbeddedInstance(_broker, ctx, instance, returnValue, inArgs, outArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		BIOS_OpenDRIM_BIOSService_toCMPIArg(_broker, out, outArgs);
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="ReadRawBIOSData") {
		unsigned int returnValue;
		OpenDRIM_BIOSService_ReadRawBIOSData_In inArgs;
		BIOS_OpenDRIM_BIOSService_toCPP(_broker, in, inArgs);
		OpenDRIM_BIOSService_ReadRawBIOSData_Out outArgs;
		
		errorCode = BIOS_OpenDRIM_BIOSService_ReadRawBIOSData(_broker, ctx, instance, returnValue, inArgs, outArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		BIOS_OpenDRIM_BIOSService_toCMPIArg(_broker, out, outArgs);
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="WriteRawBIOSData") {
		unsigned int returnValue;
		OpenDRIM_BIOSService_WriteRawBIOSData_In inArgs;
		BIOS_OpenDRIM_BIOSService_toCPP(_broker, in, inArgs);
		OpenDRIM_BIOSService_WriteRawBIOSData_Out outArgs;
		
		errorCode = BIOS_OpenDRIM_BIOSService_WriteRawBIOSData(_broker, ctx, instance, returnValue, inArgs, outArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		BIOS_OpenDRIM_BIOSService_toCMPIArg(_broker, out, outArgs);
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="SetBIOSAttributes") {
		unsigned int returnValue;
		OpenDRIM_BIOSService_SetBIOSAttributes_In inArgs;
		BIOS_OpenDRIM_BIOSService_toCPP(_broker, in, inArgs);
		OpenDRIM_BIOSService_SetBIOSAttributes_Out outArgs;
		
		errorCode = BIOS_OpenDRIM_BIOSService_SetBIOSAttributes(_broker, ctx, instance, returnValue, inArgs, outArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		BIOS_OpenDRIM_BIOSService_toCMPIArg(_broker, out, outArgs);
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else {
		errorMessage = (string) OpenDRIM_BIOSService_classnames[0] + ": " + "The requested method (" + (string) methodName +") was not found.";
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) NOT_SUPPORTED, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	CMReturn(CMPI_RC_OK);
}

/* ---------------------------------------------------------------------------*/
/*                    End of Method Provider Interface                        */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                              Provider Factory                              */
/* ---------------------------------------------------------------------------*/

int BIOS_OpenDRIM_BIOSService_init(const CMPIBroker* broker) {
	_E_;
	_broker = broker;
	static bool initialized = false;
	if (!initialized) {
		string errorMessage;
		int errorCode = BIOS_OpenDRIM_BIOSService_load(broker, errorMessage);
		if (errorCode != OK) {
			errorMessage += "BIOS_OpenDRIM_BIOSService_init FAILED: " + (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return -1;
		}
		initialized = true;
	}
	_L_;
	return OK;
}

int BIOS_OpenDRIM_BIOSService_finalize() {
	_E_;
	static bool finalized = false;
	if (!finalized) {
		string errorMessage;
		int errorCode = BIOS_OpenDRIM_BIOSService_unload(errorMessage);
		if (errorCode != OK) {
			errorMessage += "BIOS_OpenDRIM_BIOSService_unload FAILED: " + (string) OpenDRIM_BIOSService_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return errorCode;
		}
		finalized = true;
	}
	_L_;
	return OK;
}

#define BIOS_OpenDRIM_BIOSService_INIT if (BIOS_OpenDRIM_BIOSService_init(_broker) < 0) return NULL

CMInstanceMIStub(BIOS_OpenDRIM_BIOSServiceProvider, BIOS_OpenDRIM_BIOSServiceProvider, _broker, BIOS_OpenDRIM_BIOSService_INIT);
CMMethodMIStub(BIOS_OpenDRIM_BIOSServiceProvider, BIOS_OpenDRIM_BIOSServiceProvider, _broker, BIOS_OpenDRIM_BIOSService_INIT);

/* ---------------------------------------------------------------------------*/
/*                          End of Provider Factory                           */
/* ---------------------------------------------------------------------------*/
