from distutils.core import setup, Extension
from distutils.cmd import Command
from distutils.command.install_data import install_data
from distutils.command.build import build
from distutils.command.sdist import sdist
from glob import glob
from distutils.command.build_ext import build_ext
import sys
from os import path

#####################################################################
# This class overwrites the prune_file_list method of sdist to not
# remove automatically the RCS/CVS directory from the distribution.
####################################################################
 
class modified_sdist(sdist):
    def prune_file_list(self):
 
        build = self.get_finalized_command('build')
        base_dir = self.distribution.get_fullname()
        self.filelist.exclude_pattern(None, prefix=build.build_base)
        self.filelist.exclude_pattern(None, prefix=base_dir)
 
########################################################################
# Overwrite the sub_commands list of the build command so that
# the build_py is called after build_clib and build_ext. This way
# the python module generated by SWIG ('build_ext' command)  will be
# installed by 'build_py' command.  
########################################################################


class modified_build(build):
    sub_commands = [('build_clib',    build.has_c_libraries),
                    ('build_ext',     build.has_ext_modules),
                    ('build_py',      build.has_pure_modules),
                    ('build_scripts', build.has_scripts),
                    ]
## Need to use C++ compiler:
CC_exe = 'CC'
cc_exe = 'cc'
platform = sys.platform
if platform == "linux2" or platform == "darwin":
    CC_exe = 'g++'
    cc_exe = 'gcc'
from distutils import sysconfig
save_init_posix = sysconfig._init_posix

def my_init_posix():
    save_init_posix()
    g = sysconfig._config_vars
    for n,r in [('LDSHARED',CC_exe),('CC',CC_exe)]:
        if g[n][:3] == cc_exe:
            print 'my_init_posix: changing %s = %r'%(n,g[n]),
            g[n] = r+g[n][3:]
            print 'to', g[n]

if platform in ('sunos5', 'linux2', 'irix6', 'darwin'):
      sysconfig._init_posix = my_init_posix

comp_opts = []
link_opts = []

if platform == "irix6":
    comp_opts.append( "-LANG:std" )
    link_opts.append("-LANG:std")
elif platform == "win32":
    comp_opts.append("/MT")

packFullName = "UTpackages.UTmolderivatives"
packName = "UTmolderivatives"

sources = []
curv_src = ["Curvature.cpp",  "CurvaturesGridVoxel.cpp",  "SumOfGaussiansCurvature.cpp"]
math_src = ["LinearAlgebra.cpp", "AreaVolumes.cpp",  "Matrix.cpp","Ray.cpp","Tuple.cpp",
            "Quaternion.cpp", "TrilinearGrid.cpp", "Vector.cpp"]
for f in curv_src:
    sources.append(path.join("src", "Curvatures", f))
for f in math_src:
    sources.append(path.join("src", "UsefulMath", f))
sources.append(path.join(packName, "molderivatives.i"))

import numpy
numpy_include =  numpy.get_include()
source_include = [path.join("src", "Curvatures"), path.join("src", "UsefulMath"), numpy_include]
dist = setup(name=packFullName,
             version="1.0",
             description = "MolDerivatives Library, part of TexMol (developed at the University of Texas, Austin)",
             author = "Molecular Graphics Laboratory",
             author_email = "mgltools@scripps.edu",
             download_url = "http://www.scripps.edu/~sanner/python/packager.html",
             url = '',
             
             packages = [packFullName],
             package_dir = {packFullName: packName},
             cmdclass = {'build':modified_build,
                         'sdist':modified_sdist},
             ext_package = packFullName,
             ext_modules = [Extension ("_molderivatives",
                                       sources,
                                       include_dirs = source_include,
                                       extra_compile_args = comp_opts,
                                       extra_link_args = link_opts
                                       ) ]
             )
