/*
 * Decompiled with CFR 0.152.
 */
package org.openpreservation.jhove.qa.comparator;

import java.io.File;
import org.openpreservation.jhove.qa.ControllerState;
import org.openpreservation.jhove.qa.comparator.Comparator;
import org.openpreservation.jhove.qa.comparator.XmlOutputElement;
import org.openpreservation.jhove.qa.comparator.XmlXpathIgnoreEvaluator;
import org.xmlunit.XMLUnitException;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Diff;

public final class XmlUnitComparator
implements Comparator {
    private final XmlOutputElement[] ignoredElements;
    private XmlXpathIgnoreEvaluator diffEvaluator;
    private String message = "OK";

    public XmlUnitComparator() {
        this(new XmlOutputElement[0]);
    }

    public XmlUnitComparator(XmlOutputElement ... ignoredElements) {
        this.ignoredElements = ignoredElements;
        this.diffEvaluator = new XmlXpathIgnoreEvaluator(this.ignoredElements);
    }

    @Override
    public ControllerState compare(File baseline, File candidate) {
        boolean hasDifferences = true;
        try {
            Diff diff = DiffBuilder.compare(Input.fromFile(baseline)).withTest(Input.fromFile(candidate)).withDifferenceEvaluator(this.diffEvaluator).build();
            this.message = diff.toString();
            hasDifferences = diff.hasDifferences();
        }
        catch (XMLUnitException excep) {
            this.message = excep.getMessage();
        }
        return hasDifferences ? ControllerState.CONFLICT : ControllerState.OK;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

